/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;
import ddf.minim.ugens.Wavetable;

public class WaveShaper
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput outAmplitude;
    public UGen.UGenInput mapAmplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
    float mapAmp;
    float outAmp;
    boolean wrapMap;
    Wavetable mapShape;

    public WaveShaper(float outAmp, float mapAmp, Wavetable mapShape) {
        this(outAmp, mapAmp, mapShape, false);
    }

    public WaveShaper(float outAmp, float mapAmp, Wavetable mapShape, boolean wrapMap) {
        this.outAmplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.mapShape = mapShape;
        this.outAmp = outAmp;
        this.mapAmp = mapAmp;
        this.wrapMap = wrapMap;
    }

    protected void uGenerate(float[] channels) {
        if (this.mapAmplitude.isPatched()) {
            this.mapAmp = this.mapAmplitude.getLastValues()[0];
        }
        if (this.outAmplitude.isPatched()) {
            this.outAmp = this.outAmplitude.getLastValues()[0];
        }
        int i = 0;
        while (i < channels.length) {
            float tmpIndex = this.mapAmp * this.audio.getLastValues()[i] / 2.0f + 0.5f;
            if (this.wrapMap) {
                if ((tmpIndex %= 1.0f) < 0.0f) {
                    tmpIndex += 1.0f;
                }
            } else if (tmpIndex > 1.0f) {
                tmpIndex = 1.0f;
            } else if (tmpIndex < 0.0f) {
                tmpIndex = 0.0f;
            }
            channels[i] = this.outAmp * this.mapShape.value(tmpIndex);
            ++i;
        }
    }
}

