/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import java.util.ArrayList;

public abstract class UGen {
    private ArrayList<UGenInput> uGenInputs = new ArrayList();
    private float[] lastValues = new float[2];
    private float sampleRate;
    private int nOutputs = 0;
    private int currentTick = 0;

    public final UGen patch(UGen connectToUGen) {
        connectToUGen.addInput(this);
        ++this.nOutputs;
        Minim.debug("nOutputs = " + this.nOutputs);
        this.setSampleRate(connectToUGen.sampleRate);
        return connectToUGen;
    }

    public final UGen patch(UGenInput connectToInput) {
        connectToInput.setIncomingUGen(this);
        ++this.nOutputs;
        Minim.debug("nOutputs = " + this.nOutputs);
        this.setSampleRate(connectToInput.getOuterUGen().sampleRate);
        return connectToInput.getOuterUGen();
    }

    protected void addInput(UGen input) {
        Minim.debug("UGen addInput called.");
        if (this.uGenInputs.size() > 0) {
            Minim.debug("Initializing default input on something");
            this.uGenInputs.get(0).setIncomingUGen(input);
        } else {
            System.err.println("Trying to connect to UGen with no default input.");
        }
    }

    public final void patch(AudioOutput output) {
        Minim.debug("Patching " + this + " to the output " + output + ".");
        this.patch(output.bus);
        this.setSampleRate(output.sampleRate());
    }

    public final void unpatch(AudioOutput output) {
        Minim.debug("Unpatching " + this + " from the output " + output + ".");
        this.unpatch(output.bus);
    }

    public final void unpatch(UGen connectToUGen) {
        connectToUGen.removeInput(this);
        --this.nOutputs;
        Minim.debug("nOutputs = " + this.nOutputs);
    }

    protected void removeInput(UGen input) {
        Minim.debug("UGen removeInput called.");
    }

    public final void tick(float[] channels) {
        if (this.nOutputs > 0) {
            this.currentTick = (this.currentTick + 1) % this.nOutputs;
        }
        if (this.currentTick == 0) {
            if (this.uGenInputs.size() > 0) {
                int i = 0;
                while (i < this.uGenInputs.size()) {
                    if (this.uGenInputs.get(i) != null && this.uGenInputs.get(i).isPatched()) {
                        float[] tmp;
                        switch (this.uGenInputs.get(i).inputType) {
                            case CONTROL: {
                                tmp = new float[1];
                                break;
                            }
                            default: {
                                tmp = new float[channels.length];
                            }
                        }
                        this.uGenInputs.get(i).getIncomingUGen().tick(tmp);
                    }
                    ++i;
                }
            }
            this.uGenerate(channels);
            System.arraycopy(channels, 0, this.lastValues, 0, channels.length);
        }
    }

    protected abstract void uGenerate(float[] var1);

    public final float[] getLastValues() {
        return this.lastValues;
    }

    public final float sampleRate() {
        return this.sampleRate;
    }

    protected void sampleRateChanged() {
    }

    public final void setSampleRate(float newSampleRate) {
        if (this.sampleRate != newSampleRate) {
            this.sampleRate = newSampleRate;
            this.sampleRateChanged();
        }
        if (this.uGenInputs.size() > 0) {
            int i = 0;
            while (i < this.uGenInputs.size()) {
                if (this.uGenInputs.get(i) != null && this.uGenInputs.get(i).isPatched()) {
                    this.uGenInputs.get(i).getIncomingUGen().setSampleRate(newSampleRate);
                }
                ++i;
            }
        }
    }

    public void printInputs() {
        int i = 0;
        while (i < this.uGenInputs.size()) {
            Minim.debug("uGenInputs " + i + " ");
            if (this.uGenInputs.get(i) == null) {
                Minim.debug("null");
            } else {
                this.uGenInputs.get(i).printInput();
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputType {
        CONTROL,
        AUDIO;

    }

    public class UGenInput {
        private UGen incoming;
        private InputType inputType;

        public UGenInput() {
            this(InputType.AUDIO);
        }

        public UGenInput(InputType it) {
            this.inputType = it;
            UGen.this.uGenInputs.add(this);
        }

        public InputType getInputType() {
            return this.inputType;
        }

        public UGen getOuterUGen() {
            return UGen.this;
        }

        public UGen getIncomingUGen() {
            return this.incoming;
        }

        public void setIncomingUGen(UGen in) {
            this.incoming = in;
        }

        public boolean isPatched() {
            return this.incoming != null;
        }

        public float[] getLastValues() {
            return this.getIncomingUGen().getLastValues();
        }

        public String getInputTypeAsString() {
            String typeLabel = null;
            switch (this.inputType) {
                case AUDIO: {
                    typeLabel = "AUDIO";
                    break;
                }
                case CONTROL: {
                    typeLabel = "CONTROL";
                }
            }
            return typeLabel;
        }

        public void printInput() {
            Minim.debug("UGenInput:  signal = " + this.getInputTypeAsString() + " " + this.isPatched());
        }
    }
}

