/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.ugens.UGen;
import java.util.Vector;

public class Summer
extends UGen
implements AudioSignal {
    private AudioOutput out;
    private Vector<UGen> ugens;

    public Summer() {
        this.ugens = new Vector();
    }

    public Summer(AudioOutput output) {
        this.out = output;
        this.ugens = new Vector();
    }

    protected void addInput(UGen input) {
        Minim.debug("Bus::addInput - Adding " + input + " to the ugens list of " + this);
        this.ugens.add(input);
    }

    protected void removeInput(UGen input) {
        Minim.debug("Bus::removeInput - Removing " + input + " to the ugens list of " + this);
        this.ugens.remove(input);
    }

    protected void sampleRateChanged() {
        int i = 0;
        while (i < this.ugens.size()) {
            this.ugens.get(i).setSampleRate(this.sampleRate());
            ++i;
        }
    }

    protected void uGenerate(float[] channels) {
        UGen[] ugensArray = this.ugens.toArray(new UGen[0]);
        int i = 0;
        while (i < ugensArray.length) {
            float[] tmp = new float[channels.length];
            UGen u = ugensArray[i];
            u.tick(tmp);
            int c = 0;
            while (c < channels.length) {
                int n = c;
                channels[n] = channels[n] + u.getLastValues()[c];
                ++c;
            }
            ++i;
        }
    }

    public void generate(float[] mono) {
        float[] sample = new float[1];
        int i = 0;
        while (i < mono.length) {
            if (this.out != null) {
                this.out.noteManager.tick();
            }
            sample[0] = 0.0f;
            this.tick(sample);
            mono[i] = sample[0];
            ++i;
        }
    }

    public void generate(float[] left, float[] right) {
        float[] sample = new float[2];
        int i = 0;
        while (i < left.length) {
            if (this.out != null) {
                this.out.noteManager.tick();
            }
            sample[0] = 0.0f;
            sample[1] = 0.0f;
            this.tick(sample);
            left[i] = sample[0];
            right[i] = sample[1];
            ++i;
        }
    }
}

