/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;

public class Pan
extends UGen {
    public UGen.UGenInput pan;
    private UGen audio;
    private float mPanValue;
    private static float PI2 = 1.5707964f;

    public Pan(float panValue) {
        this.mPanValue = panValue;
        this.pan = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    }

    public void setPan(float panValue) {
        this.mPanValue = panValue;
    }

    protected void addInput(UGen in) {
        this.audio = in;
    }

    protected void removeInput(UGen input) {
        if (this.audio == input) {
            this.audio = null;
        }
    }

    protected void sampleRateChanged() {
        this.audio.setSampleRate(this.sampleRate());
    }

    protected void uGenerate(float[] channels) {
        if (this.pan.isPatched()) {
            this.mPanValue = this.pan.getLastValues()[0];
        }
        float[] sample = new float[1];
        if (this.audio != null) {
            this.audio.tick(sample);
            sample[0] = this.audio.getLastValues()[0];
        }
        float normBalance = (this.mPanValue + 1.0f) * 0.5f;
        float leftAmp = (float)Math.cos(PI2 * normBalance);
        float rightAmp = (float)Math.sin(PI2 * normBalance);
        channels[0] = sample[0] * leftAmp;
        channels[1] = sample[0] * rightAmp;
    }
}

