/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.Frequency;
import ddf.minim.ugens.UGen;
import ddf.minim.ugens.Waveform;
import ddf.minim.ugens.Waves;

public class Oscil
extends UGen {
    public UGen.UGenInput amplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput frequency = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput phase = new UGen.UGenInput(UGen.InputType.CONTROL);
    private Waveform wave;
    private Frequency freq;
    private float amp;
    private float fPhase;
    private float step;
    private float stepSize;
    private float oneOverSampleRate;

    public Oscil(float frequencyInHertz, float amplitude, Waveform waveform) {
        this(Frequency.ofHertz(frequencyInHertz), amplitude, waveform);
    }

    public Oscil(float frequencyInHertz, float amplitude) {
        this(Frequency.ofHertz(frequencyInHertz), amplitude);
    }

    public Oscil(Frequency frequency, float amplitude) {
        this(frequency, amplitude, (Waveform)Waves.SINE);
    }

    public Oscil(Frequency freq, float amp, Waveform wave) {
        this.wave = wave;
        this.freq = freq;
        this.amp = amp;
        this.step = 0.0f;
        this.fPhase = 0.0f;
        this.oneOverSampleRate = 1.0f;
    }

    protected void sampleRateChanged() {
        this.oneOverSampleRate = 1.0f / this.sampleRate();
        this.stepSizeChanged();
    }

    private void stepSizeChanged() {
        this.stepSize = this.freq.asHz() * this.oneOverSampleRate;
    }

    public void setFrequency(float hz) {
        this.freq.setAsHz(hz);
        this.stepSizeChanged();
    }

    public void setFrequency(Frequency newFreq) {
        this.freq.setAsHz(newFreq.asHz());
        this.stepSizeChanged();
    }

    public void setPhase(float newPhase) {
        this.fPhase = newPhase;
    }

    public void reset() {
        this.step = this.fPhase;
    }

    protected void uGenerate(float[] channels) {
        float outAmp = this.amp;
        if (this.amplitude.isPatched()) {
            outAmp = this.amplitude.getLastValues()[0];
        }
        float sample = outAmp * this.wave.value(this.step);
        int i = 0;
        while (i < channels.length) {
            channels[i] = sample;
            ++i;
        }
        if (this.frequency.isPatched()) {
            this.freq.setAsHz(this.frequency.getLastValues()[0]);
            this.stepSizeChanged();
        }
        if (this.phase.isPatched()) {
            this.fPhase = this.phase.getLastValues()[0];
        }
        this.step += this.stepSize + this.fPhase;
        if (this.step < 0.0f) {
            this.step -= (float)((int)this.step) - 1.0f;
        }
        if (this.step > 1.0f) {
            this.step -= (float)((int)this.step);
        }
    }
}

