/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.ugens.UGen;

public class Line
extends UGen {
    private float begAmp;
    private float endAmp;
    private float amp;
    private float lineTime;
    private float timeStepSize;
    private float lineNow;
    private boolean isActivated;

    public Line() {
        this(1.0f, 1.0f, 0.0f);
    }

    public Line(float dT) {
        this(dT, 1.0f, 0.0f);
    }

    public Line(float dT, float beginningAmplitude) {
        this(dT, beginningAmplitude, 0.0f);
    }

    public Line(float dT, float begAmplitude, float endAmplitude) {
        this.lineTime = dT;
        this.amp = this.begAmp = begAmplitude;
        this.endAmp = endAmplitude;
        this.lineNow = 0.0f;
        this.isActivated = false;
        Minim.debug(" dampTime = " + this.lineTime + " begAmp = " + this.begAmp + " now = " + this.lineNow);
    }

    public void activate() {
        this.lineNow = 0.0f;
        this.isActivated = true;
    }

    public void setEndAmp(float newEndAmp) {
        this.endAmp = newEndAmp;
    }

    public void setLineTime(float newLineTime) {
        this.lineTime = newLineTime;
    }

    protected void sampleRateChanged() {
        this.timeStepSize = 1.0f / this.sampleRate();
    }

    protected void uGenerate(float[] channels) {
        if (!this.isActivated) {
            int i = 0;
            while (i < channels.length) {
                channels[i] = this.begAmp;
                ++i;
            }
        } else if (this.lineNow >= this.lineTime) {
            int i = 0;
            while (i < channels.length) {
                channels[i] = this.endAmp;
                ++i;
            }
        } else {
            this.amp += (this.endAmp - this.amp) * this.timeStepSize / (this.lineTime - this.lineNow);
            int i = 0;
            while (i < channels.length) {
                channels[i] = this.amp;
                ++i;
            }
            this.lineNow += this.timeStepSize;
        }
    }
}

