/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;

public class GranulateSteady
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput grainLen = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLen = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLen = new UGen.UGenInput(UGen.InputType.CONTROL);
    private boolean insideGrain;
    private float timeSinceGrainStart;
    private float timeSinceGrainStop;
    private float timeStep;
    private float grainLength = 0.01f;
    private float spaceLength = 0.02f;
    private float fadeLength = 0.0025f;
    private float minAmp = 0.0f;
    private float maxAmp = 1.0f;

    public GranulateSteady() {
        this(0.01f, 0.02f, 0.0025f, 0.0f, 1.0f);
    }

    public GranulateSteady(float grainLength, float spaceLength, float fadeLength) {
        this(grainLength, spaceLength, fadeLength, 0.0f, 1.0f);
    }

    public GranulateSteady(float grainLength, float spaceLength, float fadeLength, float minAmp, float maxAmp) {
        this.grainLength = grainLength;
        this.spaceLength = spaceLength;
        this.fadeLength = fadeLength;
        this.minAmp = minAmp;
        this.maxAmp = maxAmp;
        this.insideGrain = true;
        this.timeSinceGrainStart = 0.0f;
        this.timeSinceGrainStop = 0.0f;
        this.timeStep = 0.0f;
    }

    protected void sampleRateChanged() {
        this.timeStep = 1.0f / this.sampleRate();
    }

    private void checkFadeLength() {
        this.fadeLength = Math.min(this.fadeLength, this.grainLength / 2.0f);
    }

    protected void uGenerate(float[] channels) {
        if (this.insideGrain) {
            float amp = this.maxAmp;
            if (this.timeSinceGrainStart < this.fadeLength) {
                amp *= this.timeSinceGrainStart / this.fadeLength;
            } else if (this.timeSinceGrainStart > this.grainLength - this.fadeLength) {
                amp *= (this.grainLength - this.timeSinceGrainStart) / this.fadeLength;
            }
            int i = 0;
            while (i < channels.length) {
                channels[i] = amp * this.audio.getLastValues()[i];
                ++i;
            }
            this.timeSinceGrainStart += this.timeStep;
            if (this.timeSinceGrainStart > this.grainLength) {
                this.timeSinceGrainStop = 0.0f;
                this.insideGrain = false;
                if (this.spaceLen.isPatched()) {
                    this.spaceLength = this.spaceLen.getLastValues()[0];
                }
            }
        } else {
            int i = 0;
            while (i < channels.length) {
                channels[i] = this.minAmp;
                ++i;
            }
            this.timeSinceGrainStop += this.timeStep;
            if (this.timeSinceGrainStop > this.spaceLength) {
                this.timeSinceGrainStart = 0.0f;
                this.insideGrain = true;
                if (this.grainLen.isPatched()) {
                    this.grainLength = this.grainLen.getLastValues()[0];
                    this.checkFadeLength();
                }
                if (this.fadeLen.isPatched()) {
                    this.fadeLength = this.fadeLen.getLastValues()[0];
                    this.checkFadeLength();
                }
            }
        }
    }
}

