/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;

public class GranulateRandom
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput grainLenMin = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLenMin = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLenMin = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput grainLenMax = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLenMax = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLenMax = new UGen.UGenInput(UGen.InputType.CONTROL);
    private boolean insideGrain;
    private float timeSinceGrainStart;
    private float timeSinceGrainStop;
    private float timeStep;
    private float fadeLength = 0.0025f;
    private float grainLength = 0.01f;
    private float spaceLength = 0.02f;
    private float fadeLengthMin = 0.0025f;
    private float grainLengthMin = 0.01f;
    private float spaceLengthMin = 0.02f;
    private float fadeLengthMax = 0.0025f;
    private float grainLengthMax = 0.01f;
    private float spaceLengthMax = 0.02f;
    private float minAmp = 0.0f;
    private float maxAmp = 1.0f;

    public GranulateRandom() {
        this(0.01f, 0.02f, 0.0025f, 0.1f, 0.2f, 0.025f, 0.0f, 1.0f);
    }

    public GranulateRandom(float grainLengthMin, float spaceLengthMin, float fadeLengthMin, float grainLengthMax, float spaceLengthMax, float fadeLengthMax) {
        this(grainLengthMin, spaceLengthMin, fadeLengthMin, grainLengthMax, spaceLengthMax, fadeLengthMax, 0.0f, 1.0f);
    }

    public GranulateRandom(float grainLengthMin, float spaceLengthMin, float fadeLengthMin, float grainLengthMax, float spaceLengthMax, float fadeLengthMax, float minAmp, float maxAmp) {
        this.grainLengthMin = grainLengthMin;
        this.spaceLengthMin = spaceLengthMin;
        this.fadeLengthMin = fadeLengthMin;
        this.grainLengthMax = grainLengthMax;
        this.spaceLengthMax = spaceLengthMax;
        this.fadeLengthMax = fadeLengthMax;
        this.insideGrain = false;
        this.timeSinceGrainStart = 0.0f;
        this.timeSinceGrainStop = 0.0f;
        this.timeStep = 0.0f;
    }

    protected void sampleRateChanged() {
        this.timeStep = 1.0f / this.sampleRate();
    }

    private void checkFadeLength() {
        this.fadeLength = Math.min(this.fadeLength, this.grainLength / 2.0f);
    }

    private float randomBetween(float min, float max) {
        return (max - min) * (float)Math.random() + min;
    }

    protected void uGenerate(float[] channels) {
        if (this.insideGrain) {
            float amp = this.maxAmp;
            if (this.timeSinceGrainStart < this.fadeLength) {
                amp *= this.timeSinceGrainStart / this.fadeLength;
            } else if (this.timeSinceGrainStart > this.grainLength - this.fadeLength) {
                amp *= (this.grainLength - this.timeSinceGrainStart) / this.fadeLength;
            }
            int i = 0;
            while (i < channels.length) {
                channels[i] = amp * this.audio.getLastValues()[i];
                ++i;
            }
            this.timeSinceGrainStart += this.timeStep;
            if (this.timeSinceGrainStart > this.grainLength) {
                this.timeSinceGrainStop = 0.0f;
                this.insideGrain = false;
                if (this.spaceLenMin != null && this.spaceLenMin.isPatched()) {
                    this.spaceLengthMin = this.spaceLenMin.getLastValues()[0];
                }
                if (this.spaceLenMax != null && this.spaceLenMax.isPatched()) {
                    this.spaceLengthMax = this.spaceLenMax.getLastValues()[0];
                }
                this.spaceLength = this.randomBetween(this.spaceLengthMin, this.spaceLengthMax);
            }
        } else {
            int i = 0;
            while (i < channels.length) {
                channels[i] = this.minAmp;
                ++i;
            }
            this.timeSinceGrainStop += this.timeStep;
            if (this.timeSinceGrainStop > this.spaceLength) {
                this.timeSinceGrainStart = 0.0f;
                this.insideGrain = true;
                if (this.grainLenMin.isPatched()) {
                    this.grainLengthMin = this.grainLenMin.getLastValues()[0];
                }
                if (this.grainLenMax.isPatched()) {
                    this.grainLengthMax = this.grainLenMax.getLastValues()[0];
                }
                this.grainLength = this.randomBetween(this.grainLengthMin, this.grainLengthMax);
                if (this.fadeLenMin.isPatched()) {
                    this.fadeLengthMin = this.fadeLenMin.getLastValues()[0];
                }
                if (this.fadeLenMax.isPatched()) {
                    this.fadeLengthMax = this.fadeLenMax.getLastValues()[0];
                }
                this.fadeLength = this.randomBetween(this.fadeLengthMin, this.fadeLengthMax);
                this.checkFadeLength();
            }
        }
    }
}

