/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioMetaData;
import ddf.minim.Minim;
import ddf.minim.Playable;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.ugens.UGen;

public class FilePlayer
extends UGen
implements Playable {
    private AudioRecordingStream mFileStream;

    public FilePlayer(AudioRecordingStream iFileStream) {
        this.mFileStream = iFileStream;
        this.mFileStream.play();
    }

    public AudioRecordingStream getStream() {
        return this.mFileStream;
    }

    public void play() {
        this.mFileStream.play();
    }

    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    public void pause() {
        this.mFileStream.pause();
    }

    public void rewind() {
        this.cue(0);
    }

    public void loop() {
        this.mFileStream.loop(-1);
    }

    public void loop(int n) {
        this.mFileStream.loop(n);
    }

    public int loopCount() {
        return this.mFileStream.getLoopCount();
    }

    public int length() {
        return this.mFileStream.getMillisecondLength();
    }

    public int position() {
        return this.mFileStream.getMillisecondPosition();
    }

    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        } else if (millis > this.length()) {
            millis = this.length();
        }
        this.mFileStream.setMillisecondPosition(millis);
    }

    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        Minim.debug("AudioPlayer.skip: skipping " + millis + " milliseconds, new position is " + pos);
        this.mFileStream.setMillisecondPosition(pos);
    }

    public boolean isLooping() {
        return this.mFileStream.getLoopCount() != 0;
    }

    public boolean isPlaying() {
        return this.mFileStream.isPlaying();
    }

    public AudioMetaData getMetaData() {
        return this.mFileStream.getMetaData();
    }

    public void setLoopPoints(int start, int stop) {
        this.mFileStream.setLoopPoints(start, stop);
    }

    public void close() {
        this.mFileStream.close();
    }

    protected void uGenerate(float[] channels) {
        if (this.mFileStream.isPlaying()) {
            float[] samples = this.mFileStream.read();
            int length = samples.length >= channels.length ? channels.length : samples.length;
            System.arraycopy(samples, 0, channels, 0, length);
        }
    }
}

