/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;
import java.util.Arrays;

public class Delay
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput delTime = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput delAmp = new UGen.UGenInput(UGen.InputType.CONTROL);
    private float delayTime;
    private float maxDelayTime;
    private float amplitudeFactor;
    private double[] delayBuffer;
    private int bufferSize;
    private int iBufferIn;
    private int iBufferOut;
    private boolean feedBackOn;
    private boolean passAudioOn;

    public Delay() {
        this(0.25f, 0.5f, false, true);
    }

    public Delay(float maxDelayTime) {
        this(maxDelayTime, 0.5f, false, true);
    }

    public Delay(float maxDelayTime, float amplitudeFactor) {
        this(maxDelayTime, amplitudeFactor, false, true);
    }

    public Delay(float maxDelayTime, float amplitudeFactor, boolean feedBackOn) {
        this(maxDelayTime, amplitudeFactor, feedBackOn, true);
    }

    public Delay(float maxDelayTime, float amplitudeFactor, boolean feedBackOn, boolean passAudioOn) {
        this.maxDelayTime = maxDelayTime;
        this.amplitudeFactor = amplitudeFactor;
        this.feedBackOn = feedBackOn;
        this.passAudioOn = passAudioOn;
        this.delayTime = this.maxDelayTime;
        this.iBufferIn = 0;
        this.iBufferOut = 0;
        this.bufferSize = 0;
    }

    protected void sampleRateChanged() {
        this.delayBuffer = new double[(int)(this.maxDelayTime * this.sampleRate())];
        Arrays.fill(this.delayBuffer, 0.0);
        this.bufferSizeChanged();
    }

    private void bufferSizeChanged() {
        int oldBufferSize = this.bufferSize;
        int newBufferSize = (int)(this.delayTime * this.sampleRate());
        if (newBufferSize < oldBufferSize) {
            Arrays.fill(this.delayBuffer, newBufferSize, (int)(this.maxDelayTime * this.sampleRate()), 0.0);
        }
        this.bufferSize = newBufferSize;
        this.iBufferOut = (this.iBufferIn + 1) % this.bufferSize;
    }

    public void setDelTime(float delTime) {
        this.delayTime = delTime;
        this.bufferSizeChanged();
    }

    public void setDelAmp(float delAmp) {
        this.amplitudeFactor = delAmp;
    }

    protected void uGenerate(float[] channels) {
        float tmpIn = 0.0f;
        int i = 0;
        while (i < channels.length) {
            tmpIn += this.audio.getLastValues()[i] / (float)channels.length;
            ++i;
        }
        float tmpOut = this.amplitudeFactor * (float)this.delayBuffer[this.iBufferOut];
        this.delayBuffer[this.iBufferIn] = tmpIn;
        if (this.feedBackOn) {
            int n = this.iBufferIn;
            this.delayBuffer[n] = this.delayBuffer[n] + (double)tmpOut;
        }
        if (this.delTime.isPatched()) {
            this.delayTime = this.delTime.getLastValues()[0];
            this.bufferSizeChanged();
        }
        this.iBufferIn = (this.iBufferIn + 1) % this.bufferSize;
        this.iBufferOut = (this.iBufferOut + 1) % this.bufferSize;
        if (this.delAmp.isPatched()) {
            this.amplitudeFactor = this.delAmp.getLastValues()[0];
        }
        if (this.passAudioOn) {
            tmpOut += tmpIn;
        }
        int i2 = 0;
        while (i2 < channels.length) {
            channels[i2] = tmpOut;
            ++i2;
        }
    }
}

