/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.ugens.UGen;

public class BitCrush
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
    public UGen.UGenInput bitRes = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    private float bitResolution;
    private float nLevels;
    private float halfNLevels;

    public BitCrush() {
        this(1.0f);
    }

    public BitCrush(float localBitRes) {
        this.bitResolution = localBitRes;
        this.nLevels = (float)Math.floor(Math.pow(2.0, this.bitResolution));
        this.halfNLevels = this.nLevels / 2.0f;
        Minim.debug("bitCrush initializing to " + this.nLevels + " levels.");
    }

    public void setBitRes(float localBitRes) {
        this.bitResolution = localBitRes;
    }

    protected void uGenerate(float[] channels) {
        int i = 0;
        while (i < channels.length) {
            if (this.bitRes.isPatched()) {
                this.bitResolution = this.bitRes.getLastValues()[0];
                this.nLevels = (float)Math.floor(Math.pow(2.0, this.bitResolution));
                this.halfNLevels = this.nLevels / 2.0f;
            }
            channels[i] = (float)(Math.floor(this.halfNLevels * this.audio.getLastValues()[i]) / (double)this.halfNLevels);
            ++i;
        }
    }
}

