/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import ddf.minim.ugens.UGen;

public class ADSR
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    private float beforeAmplitude;
    private float afterAmplitude;
    private float maxAmplitude;
    private float amplitude;
    private float attackTime;
    private float decayTime;
    private float sustainLevel;
    private float releaseTime;
    private float timeStepSize;
    private float timeFromOn;
    private float timeFromOff;
    private boolean isTurnedOn;
    private boolean isTurnedOff;
    private boolean unpatchAfterRelease;
    private AudioOutput output;

    public ADSR() {
        this(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float maxAmp) {
        this(maxAmp, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float maxAmp, float attTime) {
        this(maxAmp, attTime, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float maxAmp, float attTime, float decTime) {
        this(maxAmp, attTime, decTime, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float maxAmp, float attTime, float decTime, float susLvl) {
        this(maxAmp, attTime, decTime, susLvl, susLvl, 1.0f, 0.0f);
    }

    public ADSR(float maxAmp, float attTime, float decTime, float susLvl, float relTime) {
        this(maxAmp, attTime, decTime, susLvl, relTime, 0.0f, 0.0f);
    }

    public ADSR(float maxAmp, float attTime, float decTime, float susLvl, float relTime, float befAmp) {
        this(maxAmp, attTime, decTime, susLvl, relTime, befAmp, 0.0f);
    }

    public ADSR(float maxAmp, float attTime, float decTime, float susLvl, float relTime, float befAmp, float aftAmp) {
        this.maxAmplitude = maxAmp;
        this.attackTime = attTime;
        this.decayTime = decTime;
        this.sustainLevel = susLvl;
        this.releaseTime = relTime;
        this.beforeAmplitude = befAmp;
        this.afterAmplitude = aftAmp;
        this.amplitude = this.beforeAmplitude;
        this.isTurnedOn = false;
        this.isTurnedOff = false;
        this.timeFromOn = -1.0f;
        this.timeFromOff = -1.0f;
        this.unpatchAfterRelease = false;
    }

    public void setParameters(float maxAmp, float attTime, float decTime, float susLvl, float relTime, float befAmp, float aftAmp) {
        this.maxAmplitude = maxAmp;
        this.attackTime = attTime;
        this.decayTime = decTime;
        this.sustainLevel = susLvl;
        this.releaseTime = relTime;
        this.beforeAmplitude = befAmp;
        this.afterAmplitude = aftAmp;
    }

    public void noteOn() {
        this.timeFromOn = 0.0f;
        this.isTurnedOn = true;
    }

    public void noteOff() {
        this.timeFromOff = 0.0f;
        this.isTurnedOff = true;
    }

    protected void sampleRateChanged() {
        this.timeStepSize = 1.0f / this.sampleRate();
    }

    public void unpatchAfterRelease(AudioOutput output) {
        this.unpatchAfterRelease = true;
        this.output = output;
    }

    protected void uGenerate(float[] channels) {
        block11: {
            float timeRemain;
            block12: {
                block10: {
                    if (this.isTurnedOn) break block10;
                    int i = 0;
                    while (i < channels.length) {
                        channels[i] = this.beforeAmplitude * this.audio.getLastValues()[i];
                        ++i;
                    }
                    break block11;
                }
                if (!(this.timeFromOff > this.releaseTime)) break block12;
                int i = 0;
                while (i < channels.length) {
                    channels[i] = this.afterAmplitude * this.audio.getLastValues()[i];
                    ++i;
                }
                if (!this.unpatchAfterRelease) break block11;
                this.unpatch(this.output);
                Minim.debug(" unpatching ADSR ");
                break block11;
            }
            if (this.isTurnedOn && !this.isTurnedOff) {
                if (this.timeFromOn <= this.attackTime) {
                    timeRemain = this.attackTime - this.timeFromOn;
                    this.amplitude += (this.maxAmplitude - this.amplitude) * this.timeStepSize / timeRemain;
                } else if (this.timeFromOn > this.attackTime && this.timeFromOn <= this.attackTime + this.decayTime) {
                    timeRemain = this.attackTime + this.decayTime - this.timeFromOn;
                    this.amplitude += (this.sustainLevel * this.maxAmplitude - this.amplitude) * this.timeStepSize / timeRemain;
                } else if (this.timeFromOn > this.attackTime + this.decayTime) {
                    this.amplitude = this.sustainLevel * this.maxAmplitude;
                }
                this.timeFromOn += this.timeStepSize;
            } else {
                timeRemain = this.releaseTime - this.timeFromOff;
                this.amplitude += (this.afterAmplitude - this.amplitude) * this.timeStepSize / timeRemain;
                this.timeFromOff += this.timeStepSize;
            }
            int i = 0;
            while (i < channels.length) {
                channels[i] = this.amplitude * this.audio.getLastValues()[i];
                ++i;
            }
        }
    }
}

