/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.AudioEffect;
import ddf.minim.ugens.UGen;
import processing.core.PApplet;

public abstract class IIRFilter
extends UGen
implements AudioEffect {
    public final UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public final UGen.UGenInput cutoff = new UGen.UGenInput(UGen.InputType.CONTROL);
    protected float[] a;
    protected float[] b;
    private float[][] in;
    private float[][] out;
    private float freq;

    public IIRFilter(float freq, float sampleRate) {
        this.setSampleRate(sampleRate);
        this.setFreq(freq);
        this.initArrays(2);
    }

    protected final synchronized void initArrays(int numChannels) {
        int memSize = this.a.length >= this.b.length ? this.a.length : this.b.length;
        this.in = new float[numChannels][memSize];
        this.out = new float[numChannels][memSize];
    }

    public final synchronized void uGenerate(float[] channels) {
        if (this.in.length < channels.length) {
            this.initArrays(channels.length);
        }
        int i = 0;
        while (i < channels.length) {
            System.arraycopy(this.in[i], 0, this.in[i], 1, this.in[i].length - 1);
            this.in[i][0] = this.audio.getLastValues()[i];
            float y = 0.0f;
            int ci = 0;
            while (ci < this.a.length) {
                y += this.a[ci] * this.in[i][ci];
                ++ci;
            }
            ci = 0;
            while (ci < this.b.length) {
                y += this.b[ci] * this.out[i][ci];
                ++ci;
            }
            System.arraycopy(this.out[i], 0, this.out[i], 1, this.out[i].length - 1);
            this.out[i][0] = y;
            channels[i] = y;
            ++i;
        }
        if (this.cutoff != null && this.cutoff.isPatched()) {
            this.setFreq(this.cutoff.getLastValues()[0]);
        }
    }

    public final synchronized void process(float[] signal) {
        float[] tmp = new float[1];
        int i = 0;
        while (i < signal.length) {
            tmp[0] = signal[i];
            this.uGenerate(tmp);
            signal[i] = tmp[0];
            ++i;
        }
    }

    public final synchronized void process(float[] sigLeft, float[] sigRight) {
        float[] tmp = new float[2];
        int i = 0;
        while (i < sigLeft.length) {
            tmp[0] = sigLeft[i];
            tmp[1] = sigRight[i];
            this.uGenerate(tmp);
            sigLeft[i] = tmp[0];
            sigRight[i] = tmp[1];
            ++i;
        }
    }

    public final void setFreq(float f) {
        if (this.validFreq(f) && f != this.freq) {
            this.freq = f;
            this.calcCoeff();
        }
    }

    public boolean validFreq(float f) {
        return f > 0.0f;
    }

    public final float frequency() {
        return this.freq;
    }

    protected abstract void calcCoeff();

    public final void printCoeff() {
        PApplet.println((String)"Filter coefficients: ");
        int i = 0;
        while (i < this.a.length) {
            PApplet.print((String)("  A" + i + ": " + this.a[i]));
            ++i;
        }
        PApplet.println();
        i = 0;
        while (i < this.b.length) {
            PApplet.print((String)("  B" + (i + 1) + ": " + this.b[i]));
            ++i;
        }
        PApplet.println();
    }
}

