/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.Minim;
import ddf.minim.effects.IIRFilter;

public class ChebFilter
extends IIRFilter {
    public static final int LP = 1;
    public static final int HP = 2;
    private static final float PI = (float)Math.PI;
    private int type;
    private int poles;
    private float ripple;
    private boolean canCalc = false;

    public ChebFilter(float frequency, int type, float ripple, int poles, float sampleRate) {
        super(frequency, sampleRate);
        this.setType(type);
        this.setRipple(ripple);
        this.setPoles(poles);
        this.canCalc = true;
        this.calcCoeff();
        this.initArrays(2);
    }

    public void setType(int t) {
        if (t != 1 && t != 2) {
            Minim.error("Invalid filter type, defaulting to low pass.");
            t = 1;
        }
        this.type = t;
        this.calcCoeff();
    }

    public int getType() {
        return this.type;
    }

    public void setRipple(float r) {
        this.ripple = r;
        this.calcCoeff();
    }

    public float getRipple() {
        return this.ripple;
    }

    public void setPoles(int p) {
        if (p < 2) {
            Minim.error("ChebFilter.setPoles: The number of poles must be at least 2.");
            return;
        }
        if (p % 2 != 0) {
            Minim.error("ChebFilter.setPoles: The number of poles must be even.");
            return;
        }
        if (p > 20) {
            Minim.error("ChebFilter.setPoles: The maximum number of poles is 20.");
        }
        this.poles = p;
        this.calcCoeff();
        this.initArrays(2);
    }

    public int getPoles() {
        return this.poles;
    }

    protected synchronized void calcCoeff() {
        this.a = new float[0];
        this.b = new float[0];
        if (!this.canCalc) {
            return;
        }
        float[] ca = new float[23];
        float[] cb = new float[23];
        float[] ta = new float[23];
        float[] tb = new float[23];
        float[] pa = new float[3];
        float[] pb = new float[2];
        ca[2] = 1.0f;
        cb[2] = 1.0f;
        int p = 1;
        while (p <= this.poles / 2) {
            this.calcTwoPole(p, pa, pb);
            System.arraycopy(ca, 0, ta, 0, ta.length);
            System.arraycopy(cb, 0, tb, 0, tb.length);
            int i = 2;
            while (i < 23) {
                ca[i] = pa[0] * ta[i] + pa[1] * ta[i - 1] + pa[2] * ta[i - 2];
                cb[i] = tb[i] - pb[0] * tb[i - 1] - pb[1] * tb[i - 2];
                ++i;
            }
            ++p;
        }
        cb[2] = 0.0f;
        int i = 0;
        while (i < 21) {
            ca[i] = ca[i + 2];
            cb[i] = -cb[i + 2];
            ++i;
        }
        float sa = 0.0f;
        float sb = 0.0f;
        int i2 = 0;
        while (i2 < 21) {
            if (this.type == 1) {
                sa += ca[i2];
                sb += cb[i2];
            } else {
                sa += ca[i2] * (float)Math.pow(-1.0, i2);
                sb += cb[i2] * (float)Math.pow(-1.0, i2);
            }
            ++i2;
        }
        float gain = sa / (1.0f - sb);
        int i3 = 0;
        while (i3 < 21) {
            int n = i3++;
            ca[n] = ca[n] / gain;
        }
        this.a = new float[this.poles + 1];
        this.b = new float[this.poles];
        System.arraycopy(ca, 0, this.a, 0, this.a.length);
        System.arraycopy(cb, 1, this.b, 0, this.b.length);
    }

    private void calcTwoPole(int p, float[] pa, float[] pb) {
        float np = this.poles;
        float angle = (float)Math.PI / (np * 2.0f) + (float)(p - 1) * (float)Math.PI / np;
        float rp = -((float)Math.cos(angle));
        float ip = (float)Math.sin(angle);
        if (this.ripple > 0.0f) {
            float es = 1.0f / (float)Math.sqrt(Math.pow(100.0f / (100.0f - this.ripple), 2.0) - 1.0);
            float vx = 1.0f / np * (float)Math.log((double)es + Math.sqrt(es * es + 1.0f));
            float kx = 1.0f / np * (float)Math.log((double)es + Math.sqrt(es * es - 1.0f));
            kx = (float)(Math.exp(kx) + Math.exp(-kx)) / 2.0f;
            rp = (float)((double)rp * ((Math.exp(vx) - Math.exp(-vx)) / 2.0 / (double)kx));
            ip = (float)((double)ip * ((Math.exp(vx) + Math.exp(-vx)) / 2.0 / (double)kx));
        }
        float t = 2.0f * (float)Math.tan(0.5);
        float w = (float)Math.PI * 2 * (this.frequency() / this.sampleRate());
        float m = rp * rp + ip * ip;
        float d = 4.0f - 4.0f * rp * t + m * t * t;
        float x0 = t * t / d;
        float x1 = 2.0f * t * t / d;
        float x2 = t * t / d;
        float y1 = (8.0f - 2.0f * m * t * t) / d;
        float y2 = (-4.0f - 4.0f * rp * t - m * t * t) / d;
        float k = this.type == 2 ? -((float)Math.cos(w / 2.0f + 0.5f)) / (float)Math.cos(w / 2.0f - 0.5f) : (float)Math.sin(0.5f - w / 2.0f) / (float)Math.sin(0.5 + (double)(w / 2.0f));
        d = 1.0f + y1 * k - y2 * k * k;
        pa[0] = (x0 - x1 * k + x2 * k * k) / d;
        pa[1] = (-2.0f * x0 * k + x1 + x1 * k * k - 2.0f * x2 * k) / d;
        pa[2] = (x0 * k * k - x1 * k + x2) / d;
        pb[0] = (2.0f * k + y1 + y1 * k * k - 2.0f * y2 * k) / d;
        pb[1] = (-(k * k) - y1 * k + y2) / d;
        if (this.type == 2) {
            pa[1] = -pa[1];
            pb[0] = -pb[0];
        }
    }
}

