/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioOutput;
import ddf.minim.ugens.Instrument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class NoteManager {
    private AudioOutput out;
    private float tempo;
    private float noteOffset;
    private float durationFactor;
    private int now;
    private HashMap<Integer, ArrayList<NoteEvent>> events;
    private boolean paused;

    NoteManager(AudioOutput parent) {
        this.out = parent;
        this.events = new HashMap();
        this.tempo = 60.0f;
        this.noteOffset = 0.0f;
        this.durationFactor = 1.0f;
        this.now = 0;
        this.paused = false;
    }

    synchronized void addEvent(float startTime, float duration, Instrument instrument) {
        ArrayList<Object> eventsAtOn;
        int on = this.now + (int)(this.out.sampleRate() * (startTime + this.noteOffset) * 60.0f / this.tempo);
        Integer onAt = new Integer(on);
        if (this.events.containsKey(onAt)) {
            eventsAtOn = this.events.get(onAt);
            eventsAtOn.add(new NoteOnEvent(instrument, duration));
        } else {
            eventsAtOn = new ArrayList<NoteOnEvent>();
            eventsAtOn.add(new NoteOnEvent(instrument, duration));
            this.events.put(onAt, eventsAtOn);
        }
        Integer offAt = new Integer(on + (int)(this.out.sampleRate() * duration * this.durationFactor * 60.0f / this.tempo));
        if (this.events.containsKey(offAt)) {
            ArrayList<NoteEvent> eventsAtOff = this.events.get(offAt);
            eventsAtOff.add(new NoteOffEvent(instrument));
        } else {
            ArrayList<NoteOffEvent> eventsAtOff = new ArrayList<NoteOffEvent>();
            eventsAtOff.add(new NoteOffEvent(instrument));
            this.events.put(offAt, eventsAtOff);
        }
    }

    public void setTempo(float tempo) {
        this.tempo = tempo;
    }

    public void setNoteOffset(float noteOffset) {
        this.noteOffset = noteOffset;
    }

    public void setDurationFactor(float durationFactor) {
        this.durationFactor = durationFactor;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public synchronized void tick() {
        if (!this.paused) {
            Integer Now = new Integer(this.now);
            if (this.events.containsKey(Now)) {
                ArrayList<NoteEvent> eventsToSend = this.events.get(Now);
                Iterator<NoteEvent> iter = eventsToSend.iterator();
                while (iter.hasNext()) {
                    iter.next().send();
                }
                this.events.remove(Now);
            }
            ++this.now;
        }
    }

    private static interface NoteEvent {
        public void send();
    }

    private class NoteOffEvent
    implements NoteEvent {
        private Instrument instrument;

        public NoteOffEvent(Instrument i) {
            this.instrument = i;
        }

        public void send() {
            this.instrument.noteOff();
        }
    }

    private class NoteOnEvent
    implements NoteEvent {
        private Instrument instrument;
        private float duration;

        public NoteOnEvent(Instrument i, float dur) {
            this.instrument = i;
            this.duration = dur;
        }

        public void send() {
            this.instrument.noteOn(this.duration);
        }
    }
}

