/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.MAudioBuffer;
import java.util.ArrayList;

public class MultiChannelBuffer {
    private ArrayList<MAudioBuffer> channels;
    private int bufferSize;

    public MultiChannelBuffer(int bufferSize, int numChannels) {
        this.channels = new ArrayList(numChannels);
        this.bufferSize = bufferSize;
        this.setChannelCount(numChannels);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getChannelCount() {
        return this.channels.size();
    }

    public float[] getChannel(int channelNumber) {
        return this.channels.get(channelNumber).toArray();
    }

    public void setChannel(int channelNumber, float[] samples) {
        this.channels.get(channelNumber).set(samples);
    }

    public void setChannelCount(int numChannels) {
        if (this.channels.size() != numChannels) {
            this.channels.clear();
            int i = 0;
            while (i < numChannels) {
                this.channels.add(new MAudioBuffer(this.bufferSize));
                ++i;
            }
        }
    }

    public void setBufferSize(int bufferSize) {
        if (this.bufferSize != bufferSize) {
            this.bufferSize = bufferSize;
            int channelCount = this.channels.size();
            this.channels.clear();
            this.setChannelCount(channelCount);
        }
    }
}

