/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioBuffer;
import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.Controller;
import ddf.minim.Effectable;
import ddf.minim.EffectsChain;
import ddf.minim.Recordable;
import ddf.minim.SignalSplitter;
import ddf.minim.StereoBuffer;
import ddf.minim.spi.AudioOut;
import javax.sound.sampled.AudioFormat;

public class AudioSource
extends Controller
implements Effectable,
Recordable {
    private AudioOut stream;
    private SignalSplitter splitter;
    private StereoBuffer buffer;
    private EffectsChain effects;
    public final AudioBuffer left;
    public final AudioBuffer right;
    public final AudioBuffer mix;

    public AudioSource(AudioOut istream) {
        super(istream.getControls());
        this.stream = istream;
        this.buffer = new StereoBuffer(this.stream.getFormat().getChannels(), this.stream.bufferSize(), this);
        this.left = this.buffer.left;
        this.right = this.buffer.right;
        this.mix = this.buffer.mix;
        this.splitter = new SignalSplitter(this.stream.getFormat(), this.stream.bufferSize());
        this.splitter.addListener(this.buffer);
        this.stream.setAudioListener((AudioListener)this.splitter);
        this.effects = new EffectsChain();
        this.stream.setAudioEffect((AudioEffect)this.effects);
        this.stream.open();
    }

    public void close() {
        this.stream.close();
    }

    public void addEffect(AudioEffect effect) {
        this.effects.add(effect);
    }

    public void clearEffects() {
        this.effects.clear();
    }

    public void disableEffect(int i) {
        this.effects.disable(i);
    }

    public void disableEffect(AudioEffect effect) {
        this.effects.disable(effect);
    }

    public int effectCount() {
        return this.effects.size();
    }

    public void effects() {
        this.effects.enableAll();
    }

    public boolean hasEffect(AudioEffect e) {
        return this.effects.contains(e);
    }

    public void enableEffect(int i) {
        this.effects.enable(i);
    }

    public void enableEffect(AudioEffect effect) {
        this.effects.enable(effect);
    }

    public AudioEffect getEffect(int i) {
        return this.effects.get(i);
    }

    public boolean isEffected() {
        return this.effects.hasEnabled();
    }

    public boolean isEnabled(AudioEffect effect) {
        return this.effects.isEnabled(effect);
    }

    public void noEffects() {
        this.effects.disableAll();
    }

    public void removeEffect(AudioEffect effect) {
        this.effects.remove(effect);
    }

    public AudioEffect removeEffect(int i) {
        return this.effects.remove(i);
    }

    public void addListener(AudioListener listener) {
        this.splitter.addListener(listener);
    }

    public int bufferSize() {
        return this.stream.bufferSize();
    }

    public AudioFormat getFormat() {
        return this.stream.getFormat();
    }

    public void removeListener(AudioListener listener) {
        this.splitter.removeListener(listener);
    }

    public int type() {
        return this.stream.getFormat().getChannels();
    }

    public float sampleRate() {
        return this.stream.getFormat().getSampleRate();
    }
}

