/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSignal;
import ddf.minim.AudioSource;
import ddf.minim.NoteManager;
import ddf.minim.Polyphonic;
import ddf.minim.SignalChain;
import ddf.minim.spi.AudioOut;
import ddf.minim.ugens.DefaultInstrument;
import ddf.minim.ugens.Frequency;
import ddf.minim.ugens.Instrument;
import ddf.minim.ugens.Summer;

public class AudioOutput
extends AudioSource
implements Polyphonic {
    private AudioOut synth;
    private SignalChain signals;
    public final NoteManager noteManager;
    public final Summer bus;

    public AudioOutput(AudioOut synthesizer) {
        super(synthesizer);
        this.synth = synthesizer;
        this.signals = new SignalChain();
        this.noteManager = new NoteManager(this);
        this.bus = new Summer(this);
        this.signals.add(this.bus);
        this.synth.setAudioSignal((AudioSignal)this.signals);
    }

    public void addSignal(AudioSignal signal) {
        this.signals.add(signal);
    }

    public AudioSignal getSignal(int i) {
        return this.signals.get(i + 1);
    }

    public void removeSignal(AudioSignal signal) {
        this.signals.remove(signal);
    }

    public AudioSignal removeSignal(int i) {
        return this.signals.remove(i + 1);
    }

    public void clearSignals() {
        this.signals.clear();
        this.signals.add(this.bus);
    }

    public void disableSignal(int i) {
        this.signals.disable(i + 1);
    }

    public void disableSignal(AudioSignal signal) {
        this.signals.disable(signal);
    }

    public void enableSignal(int i) {
        this.signals.enable(i + 1);
    }

    public void enableSignal(AudioSignal signal) {
        this.signals.enable(signal);
    }

    public boolean isEnabled(AudioSignal signal) {
        return this.signals.isEnabled(signal);
    }

    public boolean isSounding() {
        int i = 1;
        while (i < this.signals.size()) {
            if (this.signals.isEnabled(this.signals.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void noSound() {
        int i = 1;
        while (i < this.signals.size()) {
            this.signals.disable(i);
            ++i;
        }
    }

    public int signalCount() {
        return this.signals.size() - 1;
    }

    public void sound() {
        int i = 1;
        while (i < this.signals.size()) {
            this.signals.enable(i);
            ++i;
        }
    }

    public boolean hasSignal(AudioSignal signal) {
        return this.signals.contains(signal);
    }

    public void playNote(float startTime, float duration, Instrument instrument) {
        this.noteManager.addEvent(startTime, duration, instrument);
    }

    public void playNote(float startTime, float duration, float hz) {
        this.noteManager.addEvent(startTime, duration, new DefaultInstrument(hz, this));
    }

    public void playNote(float startTime, float duration, String pitchName) {
        this.noteManager.addEvent(startTime, duration, new DefaultInstrument(Frequency.ofPitch(pitchName).asHz(), this));
    }

    public void playNote(float startTime, float hz) {
        this.noteManager.addEvent(startTime, 1.0f, new DefaultInstrument(hz, this));
    }

    public void playNote(float startTime, String pitchName) {
        this.noteManager.addEvent(startTime, 1.0f, new DefaultInstrument(Frequency.ofPitch(pitchName).asHz(), this));
    }

    public void playNote(float hz) {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(hz, this));
    }

    public void playNote(String pitchName) {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(Frequency.ofPitch(pitchName).asHz(), this));
    }

    public void playNote() {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(Frequency.ofPitch("").asHz(), this));
    }

    public void setTempo(float tempo) {
        this.noteManager.setTempo(tempo);
    }

    public void setNoteOffset(float noteOffset) {
        this.noteManager.setNoteOffset(noteOffset);
    }

    public void setDurationFactor(float durationFactor) {
        this.noteManager.setDurationFactor(durationFactor);
    }

    public void pauseNotes() {
        this.noteManager.pause();
    }

    public void resumeNotes() {
        this.noteManager.resume();
    }
}

