/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect.processing;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.openkinect.processing.DepthImage;
import processing.core.PApplet;

public class RGBImage
extends DepthImage {
    boolean IR = false;

    public RGBImage(PApplet p) {
        super(p);
    }

    public void setIR(boolean b) {
        this.IR = b;
    }

    public synchronized void data(ByteBuffer data) {
        if (this.IR) {
            ShortBuffer sdata = data.asShortBuffer();
            int y = 0;
            while (y < this.img.height) {
                int x = 0;
                while (x < this.img.width) {
                    int pixel;
                    int offset = x + y * this.img.width;
                    short depth = sdata.get(offset);
                    int d = PApplet.constrain((int)depth, (int)0, (int)255);
                    this.img.pixels[offset] = pixel = 0xFF000000 | (d & 0xFF) << 16 | (d & 0xFF) << 8 | (d & 0xFF) << 0;
                    ++x;
                }
                ++y;
            }
        } else {
            int y = 0;
            while (y < this.img.height) {
                int x = 0;
                while (x < this.img.width) {
                    int pixel;
                    int offset = 3 * (y * this.img.width + x);
                    int r = data.get(offset + 2) & 0xFF;
                    int g = data.get(offset + 1) & 0xFF;
                    int b = data.get(offset + 0) & 0xFF;
                    this.img.pixels[x + this.img.width * y] = pixel = 0xFF000000 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | (r & 0xFF) << 0;
                    ++x;
                }
                ++y;
            }
        }
        this.img.updatePixels();
        long now = System.currentTimeMillis();
        long passedTime = now - this.time;
        this.time = now;
        float currentFPS = 1.0f / ((float)passedTime / 1000.0f);
        this.fps = PApplet.lerp((float)this.fps, (float)currentFPS, (float)0.1f);
    }
}

