/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect.processing;

import java.lang.reflect.Method;
import java.nio.ShortBuffer;
import org.openkinect.Context;
import org.openkinect.Device;
import org.openkinect.Image;
import org.openkinect.processing.DepthImage;
import org.openkinect.processing.RGBImage;
import processing.core.PApplet;
import processing.core.PImage;

public class Kinect
extends Thread {
    public static PApplet p5parent;
    Method kinectEventMethod;
    boolean running = false;
    Context context;
    Device device;
    int w = 640;
    int h = 480;
    RGBImage kimg;
    DepthImage dimg;

    public Kinect(PApplet _p) {
        p5parent = _p;
        try {
            this.kinectEventMethod = p5parent.getClass().getMethod("kinectEvent", Kinect.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        this.context = Context.getContext();
        if (this.context.devices() < 1) {
            System.out.println("No Kinect devices found.");
        }
        this.device = this.context.getDevice(0);
        this.kimg = new RGBImage(p5parent);
        this.dimg = new DepthImage(p5parent);
        this.running = true;
        super.start();
    }

    public int[] getRawDepth() {
        ShortBuffer sb = this.dimg.getRawData();
        int[] depth = new int[this.w * this.h];
        if (sb != null) {
            int i = 0;
            while (i < depth.length) {
                depth[i] = sb.get(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < depth.length) {
                depth[i] = 0;
                ++i;
            }
        }
        return depth;
    }

    public void tilt(float deg) {
        this.device.tilt(deg);
    }

    public void processDepthImage(boolean b) {
        this.dimg.enableImage(b);
    }

    public void enableDepth(boolean b) {
        if (b) {
            this.device.depth(this.dimg);
        } else {
            this.device.depth(null);
        }
    }

    public void enableRGB(boolean b) {
        this.device.color(null);
        this.kimg.setIR(!b);
        if (b) {
            this.device.color(this.kimg);
        }
    }

    public void enableIR(boolean b) {
        this.device.color(null);
        this.kimg.setIR(b);
        if (b) {
            this.device.color((Image)this.kimg, true);
        }
    }

    public float getVideoFPS() {
        return this.kimg.getFPS();
    }

    public float getDepthFPS() {
        return this.dimg.getFPS();
    }

    public PImage getVideoImage() {
        return this.kimg.img;
    }

    public PImage getDepthImage() {
        return this.dimg.img;
    }

    public void run() {
        while (this.running) {
            boolean b = this.context.processEvents();
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void quit() {
        System.out.println("quitting");
        this.device.color(null);
        this.device.depth(null);
        this.running = false;
    }
}

