/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect.processing;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.openkinect.Image;
import processing.core.PApplet;
import processing.core.PImage;

public class DepthImage
implements Image {
    long time;
    float fps;
    PApplet parent;
    public PImage img;
    boolean processImage = true;
    ShortBuffer sdata;

    public DepthImage(PApplet p) {
        this.parent = p;
        this.img = p.createImage(640, 480, 1);
        this.time = System.currentTimeMillis();
    }

    public void enableImage(boolean b) {
        this.processImage = b;
    }

    public ShortBuffer getRawData() {
        return this.sdata;
    }

    public PImage getImage() {
        return this.img;
    }

    public void data(ByteBuffer data) {
        this.sdata = data.asShortBuffer();
        if (this.processImage) {
            int y = 0;
            while (y < this.img.height) {
                int x = 0;
                while (x < this.img.width) {
                    int pixel;
                    int offset = x + y * this.img.width;
                    short depth = this.sdata.get(offset);
                    int d = Math.round((1.0f - (float)depth / 2047.0f) * 255.0f);
                    this.img.pixels[offset] = pixel = 0xFF000000 | (d & 0xFF) << 16 | (d & 0xFF) << 8 | (d & 0xFF) << 0;
                    ++x;
                }
                ++y;
            }
            this.img.updatePixels();
        }
        long now = System.currentTimeMillis();
        long passedTime = now - this.time;
        this.time = now;
        float currentFPS = 1.0f / ((float)passedTime / 1000.0f);
        this.fps = PApplet.lerp((float)this.fps, (float)currentFPS, (float)0.1f);
    }

    static int depth2rgb(short depth) {
        int r;
        int g;
        int b;
        float v = (float)depth / 2047.0f;
        v = (float)Math.pow(v, 3.0) * 6.0f;
        v = v * 6.0f * 256.0f;
        int pval = Math.round(v);
        int lb = pval & 0xFF;
        switch (pval >> 8) {
            case 0: {
                b = 255;
                g = 255 - lb;
                r = 255 - lb;
                break;
            }
            case 1: {
                b = 255;
                g = lb;
                r = 0;
                break;
            }
            case 2: {
                b = 255 - lb;
                g = 255;
                r = 0;
                break;
            }
            case 3: {
                b = 0;
                g = 255;
                r = lb;
                break;
            }
            case 4: {
                b = 0;
                g = 255 - lb;
                r = 255;
                break;
            }
            case 5: {
                b = 0;
                g = 0;
                r = 255 - lb;
                break;
            }
            default: {
                r = 0;
                g = 0;
                b = 0;
            }
        }
        int pixel = 0xFF000000 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | (r & 0xFF) << 0;
        return pixel;
    }

    static int depth2intensity(short depth) {
        int d = Math.round((1.0f - (float)depth / 2047.0f) * 255.0f);
        int pixel = 0xFF000000 | (d & 0xFF) << 16 | (d & 0xFF) << 8 | (d & 0xFF) << 0;
        return pixel;
    }

    public float getFPS() {
        return this.fps;
    }
}

