/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.openkinect.Acceleration;
import org.openkinect.ColorFormat;
import org.openkinect.Context;
import org.openkinect.DepthFormat;
import org.openkinect.Image;
import org.openkinect.LEDStatus;

public final class Device {
    private final Context context;
    private long jni;
    private Image rgb;
    private Image depth;
    private Acceleration acceleration;

    Device(Context context, long jni) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.jni = jni;
    }

    public void light(LEDStatus led) {
        this.checkDisposed();
        this.jniSetLED(led.ordinal());
    }

    public void tilt(float deg) {
        this.checkDisposed();
        this.jniSetTiltDegs(deg);
    }

    public void color(Image image) {
        this.color(image, false);
    }

    public void color(Image image, boolean IR) {
        if (IR) {
            this.color(image, ColorFormat.IR_10BIT);
        } else {
            this.color(image, ColorFormat.RGB_8_8_8);
        }
    }

    public void color(Image image, ColorFormat format) {
        this.checkDisposed();
        if (format == ColorFormat.IR_10BIT) {
            this.jniSetFormatRGB(3);
        } else {
            this.jniSetFormatRGB(format.ordinal());
        }
        this.rgb = image;
        if (this.rgb != null) {
            this.jniStartCaptureRGB();
        } else {
            this.jniStopCaptureRGB();
        }
    }

    public void depth(Image image) {
        this.depth(image, DepthFormat.RAW_11);
    }

    public void depth(Image image, DepthFormat format) {
        this.checkDisposed();
        this.jniSetFormatDepth(format.ordinal());
        this.depth = image;
        if (this.depth != null) {
            this.jniStartCaptureDepth();
        } else {
            this.jniStopCaptureDepth();
        }
    }

    public void acceleration(Acceleration acceleration) {
        this.checkDisposed();
        this.acceleration = acceleration;
    }

    public void dispose() {
        this.context.disposeDevice(this.jni);
        this.jniClose();
        this.jni = 0L;
    }

    private void checkDisposed() {
        if (this.jni == 0L) {
            throw new IllegalStateException("Device already dispoed.");
        }
    }

    void onRGB(ByteBuffer buffer) {
        if (this.rgb != null) {
            buffer.order(ByteOrder.nativeOrder());
            this.rgb.data(buffer);
        }
    }

    void onDepth(ByteBuffer buffer) {
        if (this.depth != null) {
            buffer.order(ByteOrder.nativeOrder());
            this.depth.data(buffer);
        }
    }

    void onAcceleration(float x, float y, float z) {
        if (this.acceleration != null) {
            this.acceleration.direction(x, y, z);
        }
    }

    private native void jniClose();

    private native void jniSetLED(int var1);

    private native void jniSetTiltDegs(float var1);

    private native void jniSetFormatRGB(int var1);

    private native void jniSetFormatDepth(int var1);

    private native void jniStartCaptureRGB();

    private native void jniStartCaptureDepth();

    private native void jniStopCaptureRGB();

    private native void jniStopCaptureDepth();
}

