/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openkinect.Device;
import org.openkinect.LogLevel;
import org.openkinect.Logger;

public class Context {
    private static final Context instance;
    private final long jni;
    private Logger logger;
    private final Map<Long, Device> jniMap = new HashMap<Long, Device>();

    static {
        System.loadLibrary("kinect");
        instance = new Context();
    }

    public static Context getContext() {
        return instance;
    }

    private Context() {
        this.jni = this.jniInit();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ArrayList devices = new ArrayList(Context.this.jniMap.values());
                for (Device device : devices) {
                    device.dispose();
                }
                Context.this.jniShutdown();
            }
        });
    }

    public int devices() {
        return this.jniNumDevices();
    }

    public Device getDevice(int index) {
        long dev_ptr = this.jniOpenDevice(index);
        if (dev_ptr == 0L) {
            return null;
        }
        Device device = new Device(this, dev_ptr);
        this.jniMap.put(dev_ptr, device);
        return device;
    }

    public boolean processEvents() {
        return this.jniProcessEvents();
    }

    public Device device(long jni) {
        return this.jniMap.get(jni);
    }

    public void log(Logger logger) {
        this.log(logger, LogLevel.INFO);
    }

    public void log(Logger logger, LogLevel level) {
        this.jniSetLogLevel(level.ordinal());
        this.logger = logger;
    }

    void disposeDevice(long dev_ptr) {
        this.jniMap.remove(dev_ptr);
    }

    void onLog(String msg) {
        if (this.logger != null) {
            this.logger.log(msg);
        }
    }

    private native long jniInit();

    private native void jniShutdown();

    private native boolean jniProcessEvents();

    private native int jniNumDevices();

    private native long jniOpenDevice(int var1);

    private native void jniSetLogLevel(int var1);
}

