/*
 * Decompiled with CFR 0.152.
 */
package librarytests;

import org.openkinect.processing.Kinect;
import processing.core.PApplet;
import processing.core.PVector;

public class PointCloud
extends PApplet {
    Kinect kinect;
    float a = 0.0f;
    int w = 640;
    int h = 480;
    float[] depthLookUp = new float[2048];

    public void setup() {
        this.size(800, 600, "processing.core.PGraphics3D");
        this.kinect = new Kinect(this);
        this.kinect.start();
        this.kinect.enableDepth(true);
        this.kinect.processDepthImage(false);
        int i = 0;
        while (i < this.depthLookUp.length) {
            this.depthLookUp[i] = this.rawDepthToMeters(i);
            ++i;
        }
    }

    public void draw() {
        this.background(0);
        this.fill(255);
        this.textMode(256);
        this.text("Kinect FR: " + (int)this.kinect.getDepthFPS() + "\nProcessing FR: " + (int)this.frameRate, 10.0f, 16.0f);
        int[] depth = this.kinect.getRawDepth();
        if (depth != null) {
            int skip = 4;
            this.translate(this.width / 2, this.height / 2, -50.0f);
            this.rotateY(this.a);
            int x = 0;
            while (x < this.w) {
                int y = 0;
                while (y < this.h) {
                    int offset = x + y * this.w;
                    int rawDepth = depth[offset];
                    PVector v = this.depthToWorld(x, y, rawDepth);
                    this.stroke(255);
                    this.pushMatrix();
                    float factor = 200.0f;
                    this.translate(v.x * factor, v.y * factor, factor - v.z * factor);
                    this.point(0.0f, 0.0f);
                    this.popMatrix();
                    y += skip;
                }
                x += skip;
            }
        }
        this.a += 0.015f;
    }

    public void stop() {
        this.kinect.quit();
        super.stop();
    }

    public static void main(String[] _args) {
        PApplet.main((String[])new String[]{PointCloud.class.getName()});
    }

    float rawDepthToMeters(int depthValue) {
        if (depthValue < 2047) {
            return (float)(1.0 / ((double)depthValue * -0.0030711016 + 3.3309495161));
        }
        return 0.0f;
    }

    PVector depthToWorld(int x, int y, int depthValue) {
        double fx_d = 0.00168289441892896;
        double fy_d = 0.0016919313269589567;
        double cx_d = 339.30780975300314;
        double cy_d = 242.73913761751615;
        PVector result = new PVector();
        double depth = this.depthLookUp[depthValue];
        result.x = (float)(((double)x - 339.30780975300314) * depth * 0.00168289441892896);
        result.y = (float)(((double)y - 242.73913761751615) * depth * 0.0016919313269589567);
        result.z = (float)depth;
        return result;
    }
}

