/*
 * Decompiled with CFR 0.152.
 */
package librarytests;

import org.openkinect.processing.Kinect;
import processing.core.PApplet;

public class Kinecting
extends PApplet {
    Kinect kinect;
    boolean depth = true;
    boolean rgb = false;
    boolean ir = false;
    float deg = 15.0f;
    int a = 0;

    public void setup() {
        this.size(1280, 520);
        this.kinect = new Kinect(this);
        this.kinect.start();
        this.kinect.enableDepth(this.depth);
        this.kinect.enableRGB(this.rgb);
        this.kinect.enableIR(this.ir);
        this.kinect.tilt(this.deg);
    }

    public void draw() {
        this.background(0);
        this.image(this.kinect.getVideoImage(), 0.0f, 0.0f);
        this.image(this.kinect.getDepthImage(), 640.0f, 0.0f);
        this.fill(255);
        this.text("RGB/IR FPS: " + (int)this.kinect.getVideoFPS() + "        Camera tilt: " + (int)this.deg + " degrees", 10.0f, 495.0f);
        this.text("DEPTH FPS: " + (int)this.kinect.getDepthFPS(), 640.0f, 495.0f);
        this.text("Press 'd' to enable/disable depth    Press 'r' to enable/disable rgb image   Press 'i' to enable/disable IR image  Click mouse to tilt camera (yaxis)   Framerate: " + this.frameRate, 10.0f, 515.0f);
    }

    public void mousePressed() {
        this.deg = Kinecting.map((float)this.mouseY, (float)0.0f, (float)this.height, (float)30.0f, (float)0.0f);
        Kinecting.println((String)("Tilting to: " + this.deg + " degrees."));
        this.kinect.tilt(this.deg);
    }

    public void keyPressed() {
        if (this.key == 'd') {
            this.depth = !this.depth;
            this.kinect.enableDepth(this.depth);
        } else if (this.key == 'r') {
            boolean bl = this.rgb = !this.rgb;
            if (this.rgb) {
                this.ir = false;
            }
            this.kinect.enableRGB(this.rgb);
        } else if (this.key == 'i') {
            boolean bl = this.ir = !this.ir;
            if (this.ir) {
                this.rgb = false;
            }
            this.kinect.enableIR(this.ir);
        }
    }

    public void stop() {
        this.kinect.quit();
        super.stop();
    }

    public static void main(String[] _args) {
        PApplet.main((String[])new String[]{Kinecting.class.getName()});
    }
}

