/*
 * Decompiled with CFR 0.152.
 */
package librarytests;

import librarytests.KinectTracker;
import processing.core.PApplet;
import processing.core.PVector;

public class KinectTrackingTest
extends PApplet {
    KinectTracker tracker;
    protected static String myClassName = KinectTrackingTest.getQualifiedClassName();

    public void setup() {
        this.size(640, 520);
        KinectTracker.p = this;
        this.tracker = new KinectTracker();
    }

    public void draw() {
        this.background(255);
        this.tracker.track();
        this.tracker.display();
        PVector v1 = this.tracker.getPos();
        this.fill(50.0f, 100.0f, 250.0f, 200.0f);
        this.noStroke();
        this.ellipse(v1.x, v1.y, 20.0f, 20.0f);
        PVector v2 = this.tracker.getLerpedPos();
        this.fill(100.0f, 250.0f, 50.0f, 200.0f);
        this.noStroke();
        this.ellipse(v2.x, v2.y, 20.0f, 20.0f);
        int t = this.tracker.getThreshold();
        this.fill(0);
        this.text("threshold: " + t + "    " + "framerate: " + (int)this.frameRate, 10.0f, 500.0f);
    }

    public void keyPressed() {
        int t = this.tracker.getThreshold();
        if (this.key == '\uffff') {
            if (this.keyCode == 38) {
                this.tracker.setThreshold(t += 5);
            } else if (this.keyCode == 40) {
                this.tracker.setThreshold(t -= 5);
            }
        }
    }

    public void stop() {
        this.tracker.quit();
        super.stop();
    }

    public static void main(String[] _args) {
        PApplet.main((String[])new String[]{myClassName});
    }

    public static String getQualifiedClassName() {
        return new Exception().getStackTrace()[1].getClassName();
    }
}

