/*
 * Decompiled with CFR 0.152.
 */
package librarytests;

import org.openkinect.processing.Kinect;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class KinectTracker {
    static PApplet p;
    Kinect kinect = new Kinect(p);
    int kw = 640;
    int kh = 480;
    int threshold = 550;
    PVector loc;
    PVector lerpedLoc;
    int[] depth;
    PImage display;

    public KinectTracker() {
        this.kinect.start();
        this.kinect.enableDepth(true);
        this.kinect.processDepthImage(true);
        this.display = p.createImage(this.kw, this.kh, 1);
        this.loc = new PVector(0.0f, 0.0f);
        this.lerpedLoc = new PVector(0.0f, 0.0f);
    }

    public void track() {
        this.depth = this.kinect.getRawDepth();
        if (this.depth == null) {
            return;
        }
        float sumX = 0.0f;
        float sumY = 0.0f;
        float count = 0.0f;
        int x = 0;
        while (x < this.kw) {
            int y = 0;
            while (y < this.kh) {
                int offset = this.kw - x - 1 + y * this.kw;
                int rawDepth = this.depth[offset];
                if (rawDepth < this.threshold) {
                    sumX += (float)x;
                    sumY += (float)y;
                    count += 1.0f;
                }
                ++y;
            }
            ++x;
        }
        if (count != 0.0f) {
            this.loc = new PVector(sumX / count, sumY / count);
        }
        this.lerpedLoc.x = PApplet.lerp((float)this.lerpedLoc.x, (float)this.loc.x, (float)0.3f);
        this.lerpedLoc.y = PApplet.lerp((float)this.lerpedLoc.y, (float)this.loc.y, (float)0.3f);
    }

    public PVector getLerpedPos() {
        return this.lerpedLoc;
    }

    public PVector getPos() {
        return this.loc;
    }

    public void display() {
        PImage img = this.kinect.getDepthImage();
        if (this.depth == null || img == null) {
            return;
        }
        this.display.loadPixels();
        int x = 0;
        while (x < this.kw) {
            int y = 0;
            while (y < this.kh) {
                int offset = this.kw - x - 1 + y * this.kw;
                int rawDepth = this.depth[offset];
                int pix = x + y * this.display.width;
                this.display.pixels[pix] = rawDepth < this.threshold ? p.color(150, 50, 50) : img.pixels[offset];
                ++y;
            }
            ++x;
        }
        this.display.updatePixels();
        p.image(this.display, 0.0f, 0.0f);
    }

    public void quit() {
        this.kinect.quit();
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int t) {
        this.threshold = t;
    }
}

