/*
 * Decompiled with CFR 0.152.
 */
package librarytests;

import org.openkinect.processing.Kinect;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class FancyDepthImage
extends PApplet {
    Kinect kinect;
    float a = 0.0f;
    int w = 640;
    int h = 480;
    PImage img;
    int skip = 1;
    float[] depthLookUp = new float[2048];

    public void setup() {
        this.size(800, 600);
        this.kinect = new Kinect(this);
        this.kinect.start();
        this.kinect.enableDepth(true);
        this.kinect.processDepthImage(false);
        this.img = this.createImage(this.w / this.skip, this.h / this.skip, 1);
        int i = 0;
        while (i < this.depthLookUp.length) {
            this.depthLookUp[i] = this.rawDepthToMeters(i);
            ++i;
        }
    }

    public void draw() {
        this.background(0.0f, 255.0f, 0.0f);
        this.fill(255);
        this.text("Kinect FR: " + (int)this.kinect.getDepthFPS() + "\nProcessing FR: " + (int)this.frameRate, 10.0f, 16.0f);
        int[] depth = this.kinect.getRawDepth();
        if (depth != null) {
            int x = 0;
            while (x < this.w) {
                int y = 0;
                while (y < this.h) {
                    int offset = x + y * this.w;
                    int rawDepth = depth[offset];
                    float pixZ = FancyDepthImage.map((float)rawDepth, (float)0.0f, (float)2047.0f, (float)500.0f, (float)-750.0f);
                    this.img.pixels[this.img.width - x - 1 + y * this.img.width] = this.color(pixZ);
                    y += this.skip;
                }
                x += this.skip;
            }
            this.img.updatePixels();
        }
        this.imageMode(3);
        this.image(this.img, this.width / 2, this.height / 2);
    }

    public void stop() {
        this.kinect.quit();
        super.stop();
    }

    public static void main(String[] _args) {
        PApplet.main((String[])new String[]{FancyDepthImage.class.getName()});
    }

    float rawDepthToMeters(int depthValue) {
        if (depthValue < 2047) {
            return (float)(1.0 / ((double)depthValue * -0.0030711016 + 3.3309495161));
        }
        return 0.0f;
    }

    PVector depthToWorld(int x, int y, int depthValue) {
        double fx_d = 0.00168289441892896;
        double fy_d = 0.0016919313269589567;
        double cx_d = 339.30780975300314;
        double cy_d = 242.73913761751615;
        PVector result = new PVector();
        double depth = this.depthLookUp[depthValue];
        result.x = (float)(((double)x - 339.30780975300314) * depth * 0.00168289441892896);
        result.y = (float)(((double)y - 242.73913761751615) * depth * 0.0016919313269589567);
        result.z = (float)depth;
        return result;
    }
}

