/*
 * Decompiled with CFR 0.152.
 */
package mri.v3ds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import mri.v3ds.Camera3ds;
import mri.v3ds.Color3ds;
import mri.v3ds.Decode3ds;
import mri.v3ds.Exception3ds;
import mri.v3ds.Face3ds;
import mri.v3ds.FaceMat3ds;
import mri.v3ds.HideKey3ds;
import mri.v3ds.HideTrack3ds;
import mri.v3ds.Light3ds;
import mri.v3ds.Material3ds;
import mri.v3ds.Mesh3ds;
import mri.v3ds.MorphKey3ds;
import mri.v3ds.MorphTrack3ds;
import mri.v3ds.PKey3ds;
import mri.v3ds.PTrack3ds;
import mri.v3ds.RotationKey3ds;
import mri.v3ds.RotationTrack3ds;
import mri.v3ds.SplineKey3ds;
import mri.v3ds.TexCoord3ds;
import mri.v3ds.TextDecode3ds;
import mri.v3ds.Track3ds;
import mri.v3ds.Utils3ds;
import mri.v3ds.Vertex3ds;
import mri.v3ds.XYZKey3ds;
import mri.v3ds.XYZTrack3ds;

public class Scene3ds {
    public static final int DECODE_ALL = 3;
    public static final int DECODE_USED_PARAMS = 2;
    public static final int DECODE_USED_PARAMS_AND_CHUNKS = 1;
    Vector<Mesh3ds> mMesh = new Vector(5, 5);
    private Vector<Camera3ds> mCamera = new Vector(5, 5);
    private Vector<Material3ds> mMaterial = new Vector(5, 5);
    private Vector<Light3ds> mLight = new Vector(5, 5);
    int mStartFrame = 0;
    int mEndFrame = 0;
    private byte[] mFileData = null;
    private int mFileLength = 0;
    private int mFilePos = 0;
    private Decode3ds mDecode = null;
    static final int CHUNK_COL_RGB = 16;
    static final int CHUNK_COL_TRU = 17;
    static final int CHUNK_COL_LINRGB = 18;
    static final int CHUNK_COL_LINTRU = 19;
    static final int CHUNK_PERCENTW = 48;
    static final int CHUNK_PERCENTF = 49;
    static final int CHUNK_M3DMAGIC = 19789;
    static final int CHUNK_MDATA = 15677;
    static final int CHUNK_MAT_ENTRY = 45055;
    static final int CHUNK_MAT_NAME = 40960;
    static final int CHUNK_MAT_AMBIENT = 40976;
    static final int CHUNK_MAT_DIFFUSE = 40992;
    static final int CHUNK_MAT_SPECULAR = 41008;
    static final int CHUNK_MAT_SHININESS = 41025;
    static final int CHUNK_MAT_TRANSPARENCY = 41040;
    static final int CHUNK_MAT_MAP = 41472;
    static final int CHUNK_MAT_MAPNAME = 41728;
    static final int CHUNK_NAMED_OBJECT = 16384;
    static final int CHUNK_N_TRI_OBJECT = 16640;
    static final int CHUNK_POINT_ARRAY = 16656;
    static final int CHUNK_TEX_VERTS = 16704;
    static final int CHUNK_MESH_TEXTURE_INFO = 16752;
    static final int CHUNK_MESH_MATRIX = 16736;
    static final int CHUNK_MESH_COLOR = 16741;
    static final int CHUNK_FACE_ARRAY = 16672;
    static final int CHUNK_MSH_MAT_GROUP = 16688;
    static final int CHUNK_SMOOTH_GROUP = 16720;
    static final int CHUNK_N_LIGHT = 17920;
    static final int CHUNK_LIT_SPOT = 17936;
    static final int CHUNK_LIT_OFF = 17952;
    static final int CHUNK_LIT_ATTENUATE = 17957;
    static final int CHUNK_LIT_RAYSHAD = 17959;
    static final int CHUNK_LIT_SHADOWED = 17968;
    static final int CHUNK_LIT_LOCAL_SHADOW = 17984;
    static final int CHUNK_LIT_LOCAL_SHADOW2 = 17985;
    static final int CHUNK_LIT_SEE_CONE = 18000;
    static final int CHUNK_LIT_SPOT_RECTANGULAR = 18001;
    static final int CHUNK_LIT_SPOT_OVERSHOOT = 18002;
    static final int CHUNK_LIT_SPOT_PROJECTOR = 18003;
    static final int CHUNK_LIT_SPOT_RANGE = 18005;
    static final int CHUNK_LIT_SPOT_ROLL = 18006;
    static final int CHUNK_LIT_SPOT_ASPECT = 18007;
    static final int CHUNK_LIT_RAY_BIAS = 18008;
    static final int CHUNK_LIT_INNER_RANGE = 18009;
    static final int CHUNK_LIT_OUTER_RANGE = 18010;
    static final int CHUNK_LIT_MULTIPLIER = 18011;
    static final int CHUNK_N_CAMERA = 18176;
    static final int CHUNK_CAM_SEE_CONE = 18192;
    static final int CHUNK_CAM_RANGES = 18208;
    static final int CHUNK_KFDATA = 45056;
    static final int CHUNK_KFSEG = 45064;
    static final int CHUNK_OBJECT_NODE_TAG = 45058;
    static final int CHUNK_NODE_ID = 45104;
    static final int CHUNK_NODE_HDR = 45072;
    static final int CHUNK_PIVOT = 45075;
    static final int CHUNK_POS_TRACK_TAG = 45088;
    static final int CHUNK_ROT_TRACK_TAG = 45089;
    static final int CHUNK_SCL_TRACK_TAG = 45090;
    static final int CHUNK_MORPH_TRACK_TAG = 45094;
    static final int CHUNK_HIDE_TRACK_TAG = 45097;
    static final int CHUNK_TARGET_NODE_TAG = 45060;
    static final int CHUNK_CAMERA_NODE_TAG = 45059;
    static final int CHUNK_FOV_TRACK_TAG = 45091;
    static final int CHUNK_ROLL_TRACK_TAG = 45092;

    void addMesh(Mesh3ds m) {
        this.mMesh.addElement(m);
    }

    void addCamera(Camera3ds c) {
        this.mCamera.addElement(c);
    }

    void addMaterial(Material3ds m) {
        this.mMaterial.addElement(m);
    }

    void addLight(Light3ds l) {
        this.mLight.addElement(l);
    }

    public int meshes() {
        return this.mMesh.size();
    }

    public Mesh3ds mesh(int i) {
        return this.mMesh.elementAt(i);
    }

    public int cameras() {
        return this.mCamera.size();
    }

    public Camera3ds camera(int i) {
        return this.mCamera.elementAt(i);
    }

    public int materials() {
        return this.mMaterial.size();
    }

    public Material3ds material(int i) {
        return this.mMaterial.elementAt(i);
    }

    public int lights() {
        return this.mLight.size();
    }

    public Light3ds light(int i) {
        return this.mLight.elementAt(i);
    }

    public int startFrame() {
        return this.mStartFrame;
    }

    public int endFrame() {
        return this.mEndFrame;
    }

    public Scene3ds(byte[] file_image, TextDecode3ds decode, int level) throws Exception3ds {
        if (decode != null) {
            this.mDecode = new Decode3ds(decode, level);
        }
        this.mFileData = file_image;
        this.mFileLength = file_image.length;
        this.mFilePos = 0;
        try {
            try {
                this.read3DS();
            }
            catch (Exception3ds e) {
                throw new Exception3ds("3DS-parser: " + e.getMessage());
            }
        }
        finally {
            this.mFileData = null;
            this.mDecode = null;
        }
    }

    public Scene3ds(byte[] file_image) throws Exception3ds {
        this(file_image, null, 0);
    }

    public Scene3ds(File file, TextDecode3ds decode, int level) throws Exception3ds {
        if (decode != null) {
            this.mDecode = new Decode3ds(decode, level);
        }
        try {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                this.mFileData = new byte[(int)raf.length()];
                raf.readFully(this.mFileData);
                raf.close();
                this.mFileLength = this.mFileData.length;
                this.mFilePos = 0;
                this.read3DS();
            }
            catch (IOException e) {
                throw new Exception3ds("I/O problems: " + e.getMessage());
            }
            catch (Exception3ds e) {
                throw new Exception3ds("3DS-parser: " + e.getMessage());
            }
        }
        finally {
            this.mFileData = null;
            this.mDecode = null;
        }
    }

    public Scene3ds(File file) throws Exception3ds {
        this(file, null, 0);
    }

    public Scene3ds(InputStream stream, TextDecode3ds decode, int level) throws Exception3ds {
        if (decode != null) {
            this.mDecode = new Decode3ds(decode, level);
        }
        try {
            try {
                int b;
                int buf_size = 4096;
                int stored = 0;
                byte[] buf = new byte[buf_size];
                while ((b = stream.read()) != -1) {
                    buf[stored++] = (byte)b;
                    if (stored < buf_size) continue;
                    byte[] tmp = new byte[buf_size * 2];
                    System.arraycopy(buf, 0, tmp, 0, buf_size);
                    buf_size *= 2;
                    buf = tmp;
                }
                this.mFileData = buf;
                this.mFileLength = stored;
                this.mFilePos = 0;
                this.read3DS();
            }
            catch (IOException e) {
                throw new Exception3ds("I/O problems: " + e.getMessage());
            }
            catch (Exception3ds e) {
                throw new Exception3ds("3DS-parser: " + e.getMessage());
            }
        }
        finally {
            this.mFileData = null;
            this.mDecode = null;
        }
    }

    public Scene3ds(InputStream stream) throws Exception3ds {
        this(stream, null, 0);
    }

    private int filePos() {
        return this.mFilePos;
    }

    private byte readByte() throws Exception3ds {
        if (this.mFilePos >= this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        return this.mFileData[this.mFilePos++];
    }

    private int readUnsignedShort() throws Exception3ds {
        if (this.mFilePos + 2 > this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        int val = this.mFileData[this.mFilePos] & 0xFF | (this.mFileData[this.mFilePos + 1] & 0xFF) << 8;
        this.mFilePos += 2;
        return val;
    }

    private int readInt() throws Exception3ds {
        if (this.mFilePos + 4 > this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        int val = this.mFileData[this.mFilePos] & 0xFF | (this.mFileData[this.mFilePos + 1] & 0xFF) << 8 | (this.mFileData[this.mFilePos + 2] & 0xFF) << 16 | this.mFileData[this.mFilePos + 3] << 24;
        this.mFilePos += 4;
        return val;
    }

    private float readFloat() throws Exception3ds {
        if (this.mFilePos + 4 > this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        int val = this.mFileData[this.mFilePos] & 0xFF | (this.mFileData[this.mFilePos + 1] & 0xFF) << 8 | (this.mFileData[this.mFilePos + 2] & 0xFF) << 16 | this.mFileData[this.mFilePos + 3] << 24;
        this.mFilePos += 4;
        return Float.intBitsToFloat(val);
    }

    private int skipBytes(int n) throws Exception3ds {
        if (n < 0) {
            throw new Exception3ds("Negative chunk size! File is probably corrupt.");
        }
        if (this.mFilePos + n > this.mFileData.length) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        if (this.mDecode != null) {
            this.mDecode.printBytes(this.mFileData, this.mFilePos, n);
        }
        this.mFilePos += n;
        return n;
    }

    private void skipChunk(int chunk_len) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        this.skipBytes(chunk_len);
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private Head read_HEAD() throws Exception3ds {
        int id = this.readUnsignedShort();
        int length = this.readInt();
        if (this.mDecode != null) {
            this.mDecode.printHead(id, length);
        }
        return new Head(id, length);
    }

    private String read_NAME() throws Exception3ds {
        return this.read_NAME(32);
    }

    private String read_NAME(int length) throws Exception3ds {
        byte[] buf = new byte[length];
        boolean terminated = false;
        int n = 0;
        while (n < length) {
            buf[n] = this.readByte();
            if (buf[n] == 0) {
                terminated = true;
                break;
            }
            ++n;
        }
        if (!terminated) {
            throw new Exception3ds("Name not terminated! File is probably corrupt.");
        }
        String name = new String(buf, 0, n);
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Name: \"" + name + "\"");
            this.mDecode.leave();
        }
        return name;
    }

    private void read3DS() throws Exception3ds {
        Head head = this.read_HEAD();
        if (head.id != 19789) {
            throw new Exception3ds("Bad signature! This is not a 3D Studio R4 .3ds file.");
        }
        this.read_M3DMAGIC(head.length - 6);
    }

    private void read_M3DMAGIC(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 15677: {
                    this.read_MDATA(head.length - 6);
                    break;
                }
                case 45056: {
                    this.read_KFDATA(head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_MDATA(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16384: {
                    this.read_NAMED_OBJECT(head.length - 6);
                    break;
                }
                case 45055: {
                    this.read_MAT_ENTRY(head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private Color3ds readColor(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        Color3ds lvColor = new Color3ds();
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16: {
                    lvColor = this.readRGBColor();
                    break;
                }
                case 17: {
                    lvColor = this.readTrueColor();
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
        return lvColor;
    }

    private float readPercentage(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        float val = 0.0f;
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 48: {
                    int trans = this.readUnsignedShort();
                    val = (float)((double)trans / 100.0);
                    break;
                }
                case 49: {
                    val = this.readFloat();
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
        return val;
    }

    private void read_MAT_ENTRY(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        Material3ds mat = new Material3ds();
        this.addMaterial(mat);
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 40960: {
                    mat.mName = this.read_NAME();
                    break;
                }
                case 40976: {
                    mat.mAmbient = this.readColor(head.length - 6);
                    break;
                }
                case 41008: {
                    mat.mSpecular = this.readColor(head.length - 6);
                    break;
                }
                case 40992: {
                    mat.mDiffuse = this.readColor(head.length - 6);
                    break;
                }
                case 41728: {
                    mat.mMapName = this.read_NAME();
                    break;
                }
                case 41472: {
                    this.read_MAT_ENTRY(head.length - 6);
                    break;
                }
                case 41040: {
                    mat._transparency = this.readPercentage(head.length - 6);
                    mat._transparency = 1.0f - mat._transparency;
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_NAMED_OBJECT(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        String name = this.read_NAME();
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16640: {
                    this.read_N_TRI_OBJECT(name, head.length - 6);
                    break;
                }
                case 17920: {
                    this.read_N_LIGHT(name, head.length - 6);
                    break;
                }
                case 18176: {
                    this.read_N_CAMERA(name, head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void readSpotChunk(Light3ds pLight, int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        pLight.mTarget.X = this.readFloat();
        pLight.mTarget.Z = this.readFloat();
        pLight.mTarget.Y = this.readFloat();
        pLight.mHotspot = this.readFloat();
        pLight.mFalloff = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.println("Target: " + pLight.mTarget);
            this.mDecode.println("Hotspot: " + Utils3ds.floatToString(pLight.mHotspot, 12));
            this.mDecode.println("Falloff: " + Utils3ds.floatToString(pLight.mFalloff, 12));
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 17959: {
                    pLight.mRayShadows = true;
                    break;
                }
                case 17968: {
                    pLight.mShadowed = true;
                    break;
                }
                case 17984: {
                    this.readFloat();
                    this.readFloat();
                    this.readFloat();
                    break;
                }
                case 17985: {
                    pLight.mShadowBias = this.readFloat();
                    pLight.mShadowFilter = this.readFloat();
                    pLight.mShadowSize = this.readFloat();
                    break;
                }
                case 18000: {
                    pLight.mCone = true;
                    break;
                }
                case 18001: {
                    pLight.mRectangular = true;
                    break;
                }
                case 18002: {
                    pLight.mOvershoot = true;
                    break;
                }
                case 18003: {
                    pLight.mProjector = true;
                    pLight.mProjectorName = this.read_NAME(64);
                    break;
                }
                case 18005: {
                    this.readFloat();
                    break;
                }
                case 18006: {
                    pLight.mRoll = this.readFloat();
                    break;
                }
                case 18007: {
                    pLight.mAspect = this.readFloat();
                    break;
                }
                case 18008: {
                    pLight.mRayBias = this.readFloat();
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_N_LIGHT(String name, int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        Light3ds lit = new Light3ds();
        lit.mName = name;
        this.addLight(lit);
        lit.mPosition.X = this.readFloat();
        lit.mPosition.Z = this.readFloat();
        lit.mPosition.Y = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Position: " + lit.mPosition);
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 17952: {
                    lit.mOff = this.readUnsignedShort() > 0;
                    break;
                }
                case 17936: {
                    this.readSpotChunk(lit, head.length - 6);
                    break;
                }
                case 16: 
                case 18: {
                    lit.mColor = this.readRGBColor();
                    break;
                }
                case 17: 
                case 19: {
                    lit.mColor = this.readTrueColor();
                    break;
                }
                case 17957: {
                    lit.mAttenuation = this.readFloat();
                    break;
                }
                case 18009: {
                    lit.mInnerRange = this.readFloat();
                    break;
                }
                case 18010: {
                    lit.mOuterRange = this.readFloat();
                    break;
                }
                case 18011: {
                    lit.mMultiplexer = this.readFloat();
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private Color3ds readRGBColor() throws Exception3ds {
        Color3ds lvColor = new Color3ds();
        lvColor.mRed = this.readFloat();
        lvColor.mGreen = this.readFloat();
        lvColor.mBlue = this.readFloat();
        return lvColor;
    }

    private Color3ds readTrueColor() throws Exception3ds {
        Color3ds lvColor = new Color3ds();
        lvColor.mRed = (float)(this.readByte() & 0xFF) / 255.0f;
        lvColor.mGreen = (float)(this.readByte() & 0xFF) / 255.0f;
        lvColor.mBlue = (float)(this.readByte() & 0xFF) / 255.0f;
        return lvColor;
    }

    private void read_N_CAMERA(String name, int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        Camera3ds cam = new Camera3ds();
        cam.mName = name;
        this.addCamera(cam);
        cam.mPosition.X = this.readFloat();
        cam.mPosition.Z = this.readFloat();
        cam.mPosition.Y = this.readFloat();
        cam.mTarget.X = this.readFloat();
        cam.mTarget.Z = this.readFloat();
        cam.mTarget.Y = this.readFloat();
        cam.mRoll = this.readFloat();
        cam.mLens = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Position: " + cam.mPosition);
            this.mDecode.println("Target:   " + cam.mTarget);
            this.mDecode.println("Roll: " + Utils3ds.floatToString(cam.mRoll, 12));
            this.mDecode.println("Lens: " + Utils3ds.floatToString(cam.mLens, 12));
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 18208: {
                    this.read_CAM_RANGES(cam);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_CAM_RANGES(Camera3ds cam) throws Exception3ds {
        cam.mNearPlane = this.readFloat();
        cam.mFarPlane = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Near plane:" + Utils3ds.floatToString(cam.mNearPlane, 14));
            this.mDecode.println("Far plane: " + Utils3ds.floatToString(cam.mFarPlane, 14));
            this.mDecode.leave();
        }
    }

    private void read_N_TRI_OBJECT(String name, int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        Mesh3ds mes = new Mesh3ds();
        mes.mName = name;
        this.addMesh(mes);
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16656: {
                    mes.mVertex = this.read_POINT_ARRAY();
                    break;
                }
                case 16704: {
                    mes.mTexCoord = this.read_TEX_VERTS();
                    break;
                }
                case 16752: {
                    this.read_MESH_TEXTURE_INFO(mes);
                    break;
                }
                case 16736: {
                    this.readMatrix(mes.mLocalSystem);
                    break;
                }
                case 16672: {
                    this.read_FACE_ARRAY(mes, head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private Vertex3ds[] read_POINT_ARRAY() throws Exception3ds {
        int verts = this.readUnsignedShort();
        Vertex3ds[] v = new Vertex3ds[verts];
        int n = 0;
        while (n < verts) {
            float x = this.readFloat();
            float z = this.readFloat();
            float y = this.readFloat();
            v[n] = new Vertex3ds(x, y, z);
            ++n;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Vertices: " + verts);
            int i = 0;
            while (i < verts) {
                this.mDecode.println(" " + Utils3ds.intToString(i, 4) + ":  " + v[i]);
                ++i;
            }
            this.mDecode.leave();
        }
        return v;
    }

    private TexCoord3ds[] read_TEX_VERTS() throws Exception3ds {
        int coords = this.readUnsignedShort();
        TexCoord3ds[] tc = new TexCoord3ds[coords];
        int n = 0;
        while (n < coords) {
            float u = this.readFloat();
            float v = this.readFloat();
            if (u < -100.0f || u > 100.0f) {
                u = 0.0f;
            }
            if (v < -100.0f || v > 100.0f) {
                v = 0.0f;
            }
            tc[n] = new TexCoord3ds(u, v);
            ++n;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Coords: " + coords);
            int i = 0;
            while (i < coords) {
                this.mDecode.println(" " + Utils3ds.intToString(i, 4) + ":  " + tc[i]);
                ++i;
            }
            this.mDecode.leave();
        }
        return tc;
    }

    private void read_MESH_TEXTURE_INFO(Mesh3ds mes) throws Exception3ds {
        mes.mTexMapType = this.readUnsignedShort();
        mes.mTexUTile = this.readFloat();
        mes.mTexVTile = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            String type = "";
            switch (mes.mTexMapType) {
                case 0: {
                    type = "PLANAR";
                    break;
                }
                case 1: {
                    type = "CYLINDRICAL";
                    break;
                }
                case 2: {
                    type = "SPHERICAL";
                    break;
                }
                default: {
                    type = "" + mes.mTexMapType;
                }
            }
            this.mDecode.println("Texture mapping type: " + type);
            this.mDecode.println("Texture U tiling: " + Utils3ds.floatToString(mes.mTexUTile, 9));
            this.mDecode.println("Texture V tiling: " + Utils3ds.floatToString(mes.mTexVTile, 9));
        }
        this.skipBytes(76);
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void readMatrix(float[][] mtx) throws Exception3ds {
        mtx[0][0] = this.readFloat();
        mtx[0][2] = this.readFloat();
        mtx[0][1] = this.readFloat();
        mtx[2][0] = this.readFloat();
        mtx[2][2] = this.readFloat();
        mtx[2][1] = this.readFloat();
        mtx[1][0] = this.readFloat();
        mtx[1][2] = this.readFloat();
        mtx[1][1] = this.readFloat();
        mtx[0][3] = this.readFloat();
        mtx[2][3] = this.readFloat();
        mtx[1][3] = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            int n = 0;
            while (n < 3) {
                this.mDecode.println(Utils3ds.floatToString(mtx[n][0], 13) + " " + Utils3ds.floatToString(mtx[n][1], 13) + " " + Utils3ds.floatToString(mtx[n][2], 13) + " " + Utils3ds.floatToString(mtx[n][3], 13));
                ++n;
            }
            this.mDecode.leave();
        }
    }

    private void read_FACE_ARRAY(Mesh3ds mes, int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        int faces = this.readUnsignedShort();
        mes.mFace = new Face3ds[faces];
        int n = 0;
        while (n < faces) {
            int p0 = this.readUnsignedShort();
            int p1 = this.readUnsignedShort();
            int p2 = this.readUnsignedShort();
            int flags = this.readUnsignedShort();
            mes.mFace[n] = new Face3ds(p0, p1, p2, flags);
            ++n;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Faces: " + faces);
            int i = 0;
            while (i < faces) {
                this.mDecode.println(" " + Utils3ds.intToString(i, 4) + ":  " + mes.mFace[i]);
                ++i;
            }
        }
        while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16688: {
                    this.read_MSH_MAT_GROUP(mes);
                    break;
                }
                case 16720: {
                    this.read_SMOOTH_GROUP(mes, head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_MSH_MAT_GROUP(Mesh3ds mes) throws Exception3ds {
        String name = this.read_NAME();
        FaceMat3ds fm = new FaceMat3ds();
        mes.addFaceMat(fm);
        int i = 0;
        while (i < this.materials()) {
            if (this.material(i).name().equals(name)) {
                fm.mMatIndex = i;
                break;
            }
            ++i;
        }
        int indexes = this.readUnsignedShort();
        fm.mFaceIndex = new int[indexes];
        int n = 0;
        while (n < indexes) {
            fm.mFaceIndex[n] = this.readUnsignedShort();
            ++n;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Faces: " + indexes);
            int t = 0;
            while (t < indexes) {
                this.mDecode.println("  face: " + fm.mFaceIndex[t]);
                ++t;
            }
            this.mDecode.leave();
        }
    }

    private void read_SMOOTH_GROUP(Mesh3ds mes, int chunk_len) throws Exception3ds {
        int entrys = chunk_len / 4;
        mes.mSmoothGroup = new int[entrys];
        int n = 0;
        while (n < entrys) {
            mes.mSmoothGroup[n] = this.readInt();
            ++n;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Entrys: " + entrys);
            int i = 0;
            while (i < entrys) {
                this.mDecode.println(String.valueOf(Utils3ds.intToString(i, 4)) + ": " + Utils3ds.intToBinString(mes.mSmoothGroup[i], 32));
                ++i;
            }
            this.mDecode.leave();
        }
        if (entrys != mes.faces()) {
            throw new Exception3ds("SMOOTH_GROUP entrys != faces. File is probably corrupt!");
        }
    }

    private void read_KFDATA(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        block6: while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45064: {
                    this.mStartFrame = this.readInt();
                    this.mEndFrame = this.readInt();
                    if (this.mDecode == null) continue block6;
                    this.mDecode.enter();
                    this.mDecode.println("Start frame: " + this.mStartFrame);
                    this.mDecode.println("End frame:   " + this.mEndFrame);
                    this.mDecode.leave();
                    break;
                }
                case 45058: {
                    this.read_OBJECT_NODE_TAG(head.length - 6);
                    break;
                }
                case 45060: {
                    this.read_TARGET_NODE_TAG(head.length - 6);
                    break;
                }
                case 45059: {
                    this.read_CAMERA_NODE_TAG(head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_OBJECT_NODE_TAG(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int node_id = 0;
        String name = "";
        int mesh_index = 0;
        Mesh3ds mes = null;
        block10: while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45104: {
                    node_id = this.read_NODE_ID();
                    break;
                }
                case 45072: {
                    name = this.read_NAME();
                    int i = 0;
                    while (i < this.meshes()) {
                        if (this.mesh(i).name().equals(name)) {
                            mesh_index = i;
                            break;
                        }
                        ++i;
                    }
                    mes = this.mesh(mesh_index);
                    mes.mNodeId = node_id;
                    mes.mNodeFlags = this.readInt();
                    mes.mParentNodeId = this.readUnsignedShort();
                    if (this.mDecode == null) continue block10;
                    this.mDecode.enter();
                    this.mDecode.println("Node flags: 0x" + Utils3ds.intToHexString(mes.mNodeFlags, 8));
                    this.mDecode.println("Parent node id: " + mes.mParentNodeId);
                    this.mDecode.leave();
                    break;
                }
                case 45075: {
                    mes.mPivot.X = this.readFloat();
                    mes.mPivot.Z = this.readFloat();
                    mes.mPivot.Y = this.readFloat();
                    if (this.mDecode == null) continue block10;
                    this.mDecode.enter();
                    this.mDecode.println(mes.mPivot.toString());
                    this.mDecode.leave();
                    break;
                }
                case 45088: {
                    this.read_POS_TRACK_TAG(mes.mPositionTrack);
                    break;
                }
                case 45089: {
                    this.read_ROT_TRACK_TAG(mes.mRotationTrack);
                    break;
                }
                case 45090: {
                    this.read_POS_TRACK_TAG(mes.mScaleTrack);
                    break;
                }
                case 45094: {
                    this.read_MORPH_TRACK_TAG(mes.mMorphTrack);
                    break;
                }
                case 45097: {
                    this.read_HIDE_TRACK_TAG(mes.mHideTrack);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_TARGET_NODE_TAG(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int target_node_id = 0;
        String name = "";
        int camera_index = 0;
        Camera3ds cam = null;
        block5: while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45104: {
                    target_node_id = this.read_NODE_ID();
                    break;
                }
                case 45072: {
                    name = this.read_NAME();
                    int i = 0;
                    while (i < this.cameras()) {
                        if (this.camera(i).name().equals(name)) {
                            camera_index = i;
                            break;
                        }
                        ++i;
                    }
                    cam = this.camera(camera_index);
                    cam.mTargetNodeId = target_node_id;
                    cam.mTargetNodeFlags = this.readInt();
                    cam.mTargetParentNodeId = this.readUnsignedShort();
                    if (this.mDecode == null) continue block5;
                    this.mDecode.enter();
                    this.mDecode.println("Target node flags: 0x" + Utils3ds.intToHexString(cam.mTargetNodeFlags, 8));
                    this.mDecode.println("Target parent node id: " + cam.mTargetParentNodeId);
                    this.mDecode.leave();
                    break;
                }
                case 45088: {
                    this.read_POS_TRACK_TAG(cam.mTargetTrack);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_CAMERA_NODE_TAG(int chunk_len) throws Exception3ds {
        int chunk_end = this.filePos() + chunk_len;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int position_node_id = 0;
        String name = "";
        int camera_index = 0;
        Camera3ds cam = null;
        block7: while (this.filePos() < chunk_end) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45104: {
                    position_node_id = this.read_NODE_ID();
                    break;
                }
                case 45072: {
                    name = this.read_NAME();
                    int i = 0;
                    while (i < this.cameras()) {
                        if (this.camera(i).name().equals(name)) {
                            camera_index = i;
                            break;
                        }
                        ++i;
                    }
                    cam = this.camera(camera_index);
                    cam.mPositionNodeId = position_node_id;
                    cam.mPositionNodeFlags = this.readInt();
                    cam.mPositionParentNodeId = this.readUnsignedShort();
                    if (this.mDecode == null) continue block7;
                    this.mDecode.enter();
                    this.mDecode.println("Position node flags: 0x" + Utils3ds.intToHexString(cam.mPositionNodeFlags, 8));
                    this.mDecode.println("Position parent node id: " + cam.mPositionParentNodeId);
                    this.mDecode.leave();
                    break;
                }
                case 45088: {
                    this.read_POS_TRACK_TAG(cam.mPositionTrack);
                    break;
                }
                case 45091: {
                    this.readPTrack(cam.mFovTrack);
                    break;
                }
                case 45092: {
                    this.readPTrack(cam.mRollTrack);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private int read_NODE_ID() throws Exception3ds {
        int id = this.readUnsignedShort();
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Node id: " + id);
            this.mDecode.leave();
        }
        return id;
    }

    private int readTrackHead(Track3ds track) throws Exception3ds {
        int flags;
        track.mFlags = flags = this.readUnsignedShort();
        if (this.mDecode != null) {
            String loop;
            switch (track.loopType()) {
                case 0: {
                    loop = "SINGLE";
                    break;
                }
                case 2: {
                    loop = "REPEAT";
                    break;
                }
                case 3: {
                    loop = "LOOP";
                    break;
                }
                default: {
                    loop = "" + track.loopType();
                }
            }
            this.mDecode.println("Loop type: " + loop);
            this.mDecode.println("Flags: lock " + ((flags & 8) == 8 ? "X " : "- ") + ((flags & 0x10) == 16 ? "Y " : "- ") + ((flags & 0x20) == 32 ? "Z " : "- ") + "  unlink " + ((flags & 0x80) == 128 ? "X " : "- ") + ((flags & 0x100) == 256 ? "Y " : "- ") + ((flags & 0x200) == 512 ? "Z " : "- "));
        }
        this.skipBytes(8);
        int keys = this.readInt();
        if (this.mDecode != null) {
            this.mDecode.println("Keys: " + keys);
        }
        return keys;
    }

    private void readSplineParams(SplineKey3ds key) throws Exception3ds {
        int flags = this.readUnsignedShort();
        if (flags != 0) {
            if ((flags & 1) != 0) {
                key.Tension = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Tension:    " + Utils3ds.floatToString(key.Tension, 7));
                }
            }
            if ((flags & 2) != 0) {
                key.Bias = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Bias:       " + Utils3ds.floatToString(key.Bias, 7));
                }
            }
            if ((flags & 4) != 0) {
                key.Continuity = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Continuity: " + Utils3ds.floatToString(key.Continuity, 7));
                }
            }
            if ((flags & 8) != 0) {
                key.EaseTo = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Ease to:    " + Utils3ds.floatToString(key.EaseTo, 7));
                }
            }
            if ((flags & 0x10) != 0) {
                key.EaseFrom = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Ease from:  " + Utils3ds.floatToString(key.EaseFrom, 7));
                }
            }
        }
    }

    private void readPTrack(PTrack3ds track) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int keys = this.readTrackHead(track);
        track.mKey = new PKey3ds[keys];
        int i = 0;
        while (i < keys) {
            PKey3ds key = new PKey3ds();
            key.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + key.Frame);
            }
            this.readSplineParams(key);
            key.P = this.readFloat();
            if (this.mDecode != null) {
                this.mDecode.println("  " + Utils3ds.floatToString(key.P, 13));
            }
            track.mKey[i] = key;
            ++i;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_POS_TRACK_TAG(XYZTrack3ds track) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int keys = this.readTrackHead(track);
        track.mKey = new XYZKey3ds[keys];
        int i = 0;
        while (i < keys) {
            XYZKey3ds key = new XYZKey3ds();
            key.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + key.Frame);
            }
            this.readSplineParams(key);
            key.X = this.readFloat();
            key.Z = this.readFloat();
            key.Y = this.readFloat();
            if (this.mDecode != null) {
                this.mDecode.println("    X Y Z:" + Utils3ds.floatToString(key.X, 13) + Utils3ds.floatToString(key.Y, 13) + Utils3ds.floatToString(key.Z, 13));
            }
            track.mKey[i] = key;
            ++i;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_ROT_TRACK_TAG(RotationTrack3ds track) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int keys = this.readTrackHead(track);
        track.mKey = new RotationKey3ds[keys];
        int i = 0;
        while (i < keys) {
            RotationKey3ds key = new RotationKey3ds();
            key.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + key.Frame);
            }
            this.readSplineParams(key);
            key.A = this.readFloat();
            key.X = this.readFloat();
            key.Z = this.readFloat();
            key.Y = this.readFloat();
            if (this.mDecode != null) {
                this.mDecode.println("    A X Y Z:" + Utils3ds.floatToString(key.A, 12) + Utils3ds.floatToString(key.X, 9) + Utils3ds.floatToString(key.Y, 9) + Utils3ds.floatToString(key.Z, 9));
            }
            track.mKey[i] = key;
            ++i;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_MORPH_TRACK_TAG(MorphTrack3ds track) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int keys = this.readTrackHead(track);
        track.mKey = new MorphKey3ds[keys];
        int i = 0;
        while (i < keys) {
            MorphKey3ds key = new MorphKey3ds();
            key.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + key.Frame);
            }
            this.readSplineParams(key);
            String name = this.read_NAME();
            int n = 0;
            while (n < this.meshes()) {
                if (this.mesh(n).name().equals(name)) {
                    key.Mesh = n;
                    break;
                }
                ++n;
            }
            track.mKey[i] = key;
            ++i;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_HIDE_TRACK_TAG(HideTrack3ds track) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        SplineKey3ds dummy = new SplineKey3ds();
        int keys = this.readTrackHead(track);
        track.mKey = new HideKey3ds[keys];
        int i = 0;
        while (i < keys) {
            HideKey3ds key = new HideKey3ds();
            key.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + key.Frame);
            }
            this.readSplineParams(dummy);
            track.mKey[i] = key;
            ++i;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private static class Head {
        public int id;
        public int length;

        public Head(int id, int length) {
            this.id = id;
            this.length = length;
        }
    }
}

