/*
 * Decompiled with CFR 0.152.
 */
package mri;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.media.opengl.GL;
import mri.v3ds.Exception3ds;
import mri.v3ds.Face3ds;
import mri.v3ds.FaceMat3ds;
import mri.v3ds.Material3ds;
import mri.v3ds.Mesh3ds;
import mri.v3ds.Scene3ds;
import mri.v3ds.TexCoord3ds;
import mri.v3ds.TextDecode3ds;
import mri.v3ds.Vertex3ds;
import processing.core.PApplet;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;

public class V3dsScene {
    static final boolean FLIPV = true;
    static final boolean FLIPYZ = false;
    boolean _useMaterials;
    float _r;
    float _g;
    float _b;
    float _a;
    boolean _isLoaded;
    Scene3ds _scene;
    ArrayList<Material> _materials;
    ArrayList<Texture> _textures;
    Mesh[] _meshes;
    Camera[] _cameras;
    Light[] _lights;
    PApplet _parent;
    GL _gl;
    int _callListID;
    boolean _callListCompiled;

    public V3dsScene(PApplet p, String filename) {
        this._parent = p;
        this._gl = ((PGraphicsOpenGL)this._parent.g).beginGL();
        this._callListID = 0;
        this._callListCompiled = false;
        this._callListID = this._gl.glGenLists(1);
        ((PGraphicsOpenGL)this._parent.g).endGL();
        this._useMaterials = true;
        this._r = 1.0f;
        this._g = 1.0f;
        this._b = 1.0f;
        this._a = 1.0f;
        this._isLoaded = false;
        this.loadScene(filename);
    }

    public V3dsScene(GL gl, String filename) {
        this._parent = null;
        this._gl = gl;
        this._callListID = 0;
        this._callListCompiled = false;
        this._callListID = this._gl.glGenLists(1);
        this._useMaterials = true;
        this._isLoaded = false;
        this.loadScene(filename);
    }

    public void loadScene(String filename) {
        if (this._isLoaded) {
            System.err.println("(V3dsScene)  A scene has already been loaded using this object.");
            return;
        }
        TextDecode3ds decode = new TextDecode3ds();
        int level = 3;
        try {
            File f = null;
            f = this._parent != null ? new File(this._parent.dataPath(filename)) : new File(this.dataPath(filename));
            this._scene = new Scene3ds(f, decode, level);
        }
        catch (Exception3ds e) {
            System.err.println("(V3dsScene)  Failed to load 3ds file:  " + e);
            return;
        }
        this.init();
        this.computeNormals();
        this._textures = new ArrayList();
        this._materials = new ArrayList();
        int texIndex = 0;
        Material matPrev = null;
        int m = 0;
        while (m < this._scene.materials()) {
            Material3ds mat = this._scene.material(m);
            Material mmat = new Material();
            mmat.texId = -1;
            mmat.name = mat.name();
            mmat.ambient = new float[]{mat.ambient().red(), mat.ambient().green(), mat.ambient().blue(), 1.0f};
            mmat.diffuse = new float[]{mat.diffuse().red(), mat.diffuse().green(), mat.diffuse().blue(), mat.transparency()};
            mmat.specular = new float[]{mat.specular().red(), mat.specular().green(), mat.specular().blue(), 1.0f};
            mmat.textureName = mat.mapName();
            if (mat.mapName().length() > 0) {
                Texture _tex = null;
                try {
                    _tex = this._parent != null ? TextureIO.newTexture((File)new File(this._parent.dataPath(mat.mapName())), (boolean)true) : TextureIO.newTexture((File)new File(this.dataPath(mat.mapName())), (boolean)true);
                    _tex.setTexParameteri(10242, 10497);
                    _tex.setTexParameteri(10243, 10497);
                }
                catch (IOException e) {
                    System.err.println("(V3dsScene) Failed loading texture '" + mat.mapName() + "' with error: " + e);
                }
                if (_tex != null) {
                    if (matPrev != null) {
                        matPrev.texId = texIndex;
                        matPrev.textureName = mat.mapName().toString();
                    }
                    ++texIndex;
                } else if (matPrev != null) {
                    matPrev.texId = -1;
                }
                this._textures.add(_tex);
            }
            matPrev = mmat;
            this._materials.add(mmat);
            ++m;
        }
    }

    public void draw() {
        if (this._parent == null) {
            System.err.println("PApplet reference is null. abort!");
        }
        this._gl = ((PGraphicsOpenGL)this._parent.g).beginGL();
        if (this._callListID > 0 && this._callListCompiled) {
            this._gl.glCallList(this._callListID);
            ((PGraphicsOpenGL)this._parent.g).endGL();
            return;
        }
        if (this._callListID > 0 && !this._callListCompiled) {
            this._gl.glNewList(this._callListID, 4864);
        }
        int mi = 0;
        while (mi < this._scene.meshes()) {
            Mesh3ds m = this._scene.mesh(mi);
            int fm = 0;
            while (fm < m.faceMats()) {
                Material mat;
                FaceMat3ds fmat = m.faceMat(fm);
                try {
                    mat = this._materials.get(fmat.material());
                }
                catch (IndexOutOfBoundsException e) {
                    mat = null;
                }
                if (this._useMaterials) {
                    if (mat != null) {
                        this._gl.glEnable(2903);
                        this._gl.glMaterialfv(1032, 4608, mat.ambient, 0);
                        this._gl.glMaterialfv(1032, 4609, mat.diffuse, 0);
                        this._gl.glMaterialfv(1032, 5633, new float[]{32.0f}, 0);
                        this._gl.glMaterialfv(1032, 4610, mat.specular, 0);
                    }
                    if (mat != null && mat.texId >= 0) {
                        this._gl.glEnable(3553);
                        this._gl.glBindTexture(3553, this._textures.get(mat.texId).getTextureObject());
                    } else {
                        this._gl.glBindTexture(3553, 0);
                        this._gl.glDisable(3553);
                    }
                } else {
                    this._gl.glEnable(2903);
                    this._gl.glMaterialfv(1032, 4609, new float[]{this._r, this._g, this._b, this._a}, 0);
                    this._gl.glMaterialfv(1032, 5633, new float[]{32.0f}, 0);
                    this._gl.glMaterialfv(1032, 4610, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 0);
                    this._gl.glBindTexture(3553, 0);
                    this._gl.glDisable(3553);
                }
                PVector uv0 = new PVector();
                PVector uv1 = new PVector();
                PVector uv2 = new PVector();
                this._gl.glBegin(4);
                int fi = 0;
                while (fi < fmat.faces()) {
                    int idx = fmat.face(fi);
                    Face3ds f = m.face(idx);
                    PVector n0 = this._meshes[mi].vertexNormals[f.P0];
                    PVector n1 = this._meshes[mi].vertexNormals[f.P1];
                    PVector n2 = this._meshes[mi].vertexNormals[f.P2];
                    PVector v0 = this._meshes[mi].vertices[f.P0];
                    PVector v1 = this._meshes[mi].vertices[f.P1];
                    PVector v2 = this._meshes[mi].vertices[f.P2];
                    if (m.texCoords() > 0) {
                        uv0 = this._meshes[mi].texCoords[f.P0];
                        uv1 = this._meshes[mi].texCoords[f.P1];
                        uv2 = this._meshes[mi].texCoords[f.P2];
                    }
                    if (mat != null) {
                        this._gl.glColor4f(mat.diffuse[0], mat.diffuse[1], mat.diffuse[2], mat.diffuse[3]);
                    } else {
                        this._gl.glColor4f(this._r, this._g, this._b, this._a);
                    }
                    this._gl.glNormal3f(n0.x, n0.y, n0.z);
                    if (m.texCoords() > 0) {
                        this._gl.glTexCoord2f(uv0.x, uv0.y);
                    }
                    this._gl.glVertex3f(v0.x, v0.y, v0.z);
                    this._gl.glNormal3f(n1.x, n1.y, n1.z);
                    if (m.texCoords() > 0) {
                        this._gl.glTexCoord2f(uv1.x, uv1.y);
                    }
                    this._gl.glVertex3f(v1.x, v1.y, v1.z);
                    this._gl.glNormal3f(n2.x, n2.y, n2.z);
                    if (m.texCoords() > 0) {
                        this._gl.glTexCoord2f(uv2.x, uv2.y);
                    }
                    this._gl.glVertex3f(v2.x, v2.y, v2.z);
                    ++fi;
                }
                this._gl.glEnd();
                ++fm;
            }
            ++mi;
        }
        if (this._callListID > 0 && !this._callListCompiled) {
            this._gl.glEndList();
            this._callListCompiled = true;
        }
        ((PGraphicsOpenGL)this._parent.g).endGL();
    }

    public void draw(GL gl) {
        if (this._callListID > 0 && this._callListCompiled) {
            this._gl.glCallList(this._callListID);
            return;
        }
        if (this._callListID > 0 && !this._callListCompiled) {
            this._gl.glNewList(this._callListID, 4864);
        }
        int mi = 0;
        while (mi < this._scene.meshes()) {
            Mesh3ds m = this._scene.mesh(mi);
            int fm = 0;
            while (fm < m.faceMats()) {
                Material mat;
                FaceMat3ds fmat = m.faceMat(fm);
                try {
                    mat = this._materials.get(fmat.material());
                }
                catch (IndexOutOfBoundsException e) {
                    mat = null;
                }
                if (this._useMaterials) {
                    if (mat != null) {
                        this._gl.glEnable(2903);
                        this._gl.glMaterialfv(1032, 4608, mat.ambient, 0);
                        this._gl.glMaterialfv(1032, 4609, mat.diffuse, 0);
                        this._gl.glMaterialfv(1032, 5633, new float[]{32.0f}, 0);
                        this._gl.glMaterialfv(1032, 4610, mat.specular, 0);
                    }
                    if (mat != null && mat.texId >= 0) {
                        this._gl.glEnable(3553);
                        this._gl.glBindTexture(3553, this._textures.get(mat.texId).getTextureObject());
                    } else {
                        this._gl.glBindTexture(3553, 0);
                        this._gl.glDisable(3553);
                    }
                } else {
                    this._gl.glEnable(2903);
                    this._gl.glBindTexture(3553, 0);
                    this._gl.glDisable(3553);
                }
                PVector uv0 = new PVector();
                PVector uv1 = new PVector();
                PVector uv2 = new PVector();
                this._gl.glBegin(4);
                int fi = 0;
                while (fi < fmat.faces()) {
                    int idx = fmat.face(fi);
                    Face3ds f = m.face(idx);
                    PVector n0 = this._meshes[mi].vertexNormals[f.P0];
                    PVector n1 = this._meshes[mi].vertexNormals[f.P1];
                    PVector n2 = this._meshes[mi].vertexNormals[f.P2];
                    PVector v0 = this._meshes[mi].vertices[f.P0];
                    PVector v1 = this._meshes[mi].vertices[f.P1];
                    PVector v2 = this._meshes[mi].vertices[f.P2];
                    if (m.texCoords() > 0) {
                        uv0 = this._meshes[mi].texCoords[f.P0];
                        uv1 = this._meshes[mi].texCoords[f.P1];
                        uv2 = this._meshes[mi].texCoords[f.P2];
                    }
                    if (mat != null) {
                        this._gl.glColor4f(mat.diffuse[0], mat.diffuse[1], mat.diffuse[2], mat.diffuse[3]);
                    } else {
                        this._gl.glColor4f(this._r, this._g, this._b, this._a);
                    }
                    this._gl.glNormal3f(n0.x, n0.y, n0.z);
                    if (m.texCoords() > 0) {
                        this._gl.glTexCoord2f(uv0.x, uv0.y);
                    }
                    this._gl.glVertex3f(v0.x, v0.y, v0.z);
                    this._gl.glNormal3f(n1.x, n1.y, n1.z);
                    if (m.texCoords() > 0) {
                        this._gl.glTexCoord2f(uv1.x, uv1.y);
                    }
                    this._gl.glVertex3f(v1.x, v1.y, v1.z);
                    this._gl.glNormal3f(n2.x, n2.y, n2.z);
                    if (m.texCoords() > 0) {
                        this._gl.glTexCoord2f(uv2.x, uv2.y);
                    }
                    this._gl.glVertex3f(v2.x, v2.y, v2.z);
                    ++fi;
                }
                this._gl.glEnd();
                ++fm;
            }
            ++mi;
        }
        if (this._callListID > 0 && !this._callListCompiled) {
            this._gl.glEndList();
            this._callListCompiled = true;
        }
    }

    public void init() {
        int i;
        this._meshes = new Mesh[this._scene.meshes()];
        System.out.println("Cameras: " + this._scene.cameras());
        if (this._scene.cameras() > 0) {
            this._cameras = new Camera[this._scene.cameras()];
            i = 0;
            while (i < this._scene.cameras()) {
                this._cameras[i] = new Camera();
                this._cameras[i]._name = this._scene.camera(i).name();
                this._cameras[i]._roll = this._scene.camera(i).fixedRoll();
                this._cameras[i]._up = new PVector(0.0f, 1.0f, 0.0f);
                this._cameras[i]._position = new PVector();
                this._cameras[i]._position.x = this._scene.camera((int)i).fixedPosition().X;
                this._cameras[i]._position.y = this._scene.camera((int)i).fixedPosition().Y;
                this._cameras[i]._position.z = this._scene.camera((int)i).fixedPosition().Z;
                this._cameras[i]._target = new PVector();
                this._cameras[i]._target.x = this._scene.camera((int)i).fixedTarget().X;
                this._cameras[i]._target.y = this._scene.camera((int)i).fixedTarget().Y;
                this._cameras[i]._target.z = this._scene.camera((int)i).fixedTarget().Z;
                ++i;
            }
        }
        System.out.println("Lights: " + this._scene.lights());
        if (this._scene.lights() > 0) {
            this._lights = new Light[this._scene.lights()];
            i = 0;
            while (i < this._scene.lights()) {
                this._lights[i] = new Light();
                this._lights[i]._name = this._scene.light(i).name();
                this._lights[i]._position = new PVector();
                this._lights[i]._position.x = this._scene.light((int)i).fixedPosition().X;
                this._lights[i]._position.y = this._scene.light((int)i).fixedPosition().Y;
                this._lights[i]._position.z = this._scene.light((int)i).fixedPosition().Z;
                this._lights[i]._target = new PVector();
                this._lights[i]._target.x = this._scene.light((int)i).fixedTarget().X;
                this._lights[i]._target.y = this._scene.light((int)i).fixedTarget().Y;
                this._lights[i]._target.z = this._scene.light((int)i).fixedTarget().Z;
                this._lights[i]._color = new PVector();
                this._lights[i]._color.x = this._scene.light(i).color().red();
                this._lights[i]._color.y = this._scene.light(i).color().green();
                this._lights[i]._color.z = this._scene.light(i).color().blue();
                ++i;
            }
        }
    }

    public void computeNormals() {
        PVector vcenter = new PVector();
        float vcounter = 0.0f;
        int i = 0;
        while (i < this._scene.meshes()) {
            Mesh3ds m = this._scene.mesh(i);
            this._meshes[i] = new Mesh();
            this._meshes[i].faceNormals = new PVector[m.faces()];
            this._meshes[i].faceMiddlePoint = new PVector[m.faces()];
            this._meshes[i].vertices = new PVector[m.vertices()];
            this._meshes[i].vertexNormals = new PVector[m.vertices()];
            this._meshes[i]._numTexCoords = 0;
            this._meshes[i].texCoords = new PVector[m.vertices()];
            PVector[] tmpFaceNormals = new PVector[m.faces()];
            int fi = 0;
            while (fi < m.faces()) {
                Face3ds f = m.face(fi);
                Vertex3ds p0 = m.vertex(f.P0);
                Vertex3ds p1 = m.vertex(f.P1);
                Vertex3ds p2 = m.vertex(f.P2);
                this._meshes[i].faceMiddlePoint[fi] = new PVector();
                this._meshes[i].faceMiddlePoint[fi].x = (p0.X + p1.X + p2.X) / 3.0f;
                this._meshes[i].faceMiddlePoint[fi].y = (p0.Y + p1.Y + p2.Y) / 3.0f;
                this._meshes[i].faceMiddlePoint[fi].z = (p0.Z + p1.Z + p2.Z) / 3.0f;
                PVector v0 = new PVector(p0.X, p0.Y, p0.Z);
                PVector v1 = new PVector(p1.X, p1.Y, p1.Z);
                PVector v2 = new PVector(p2.X, p2.Y, p2.Z);
                PVector e0 = PVector.sub((PVector)v1, (PVector)v0);
                PVector e1 = PVector.sub((PVector)v2, (PVector)v0);
                this._meshes[i].faceNormals[fi] = e1.cross(e0);
                tmpFaceNormals[fi] = this._meshes[i].faceNormals[fi].get();
                this._meshes[i].faceNormals[fi].normalize();
                ++fi;
            }
            PVector n = new PVector();
            TexCoord3ds tc = new TexCoord3ds(0.0f, 0.0f);
            int vi = 0;
            while (vi < m.vertices()) {
                Vertex3ds p = m.vertex(vi);
                vcenter.add(p.X, p.Y, p.Z);
                vcounter += 1.0f;
                if (m.texCoords() > 0) {
                    tc = m.texCoord(vi);
                }
                n.set(0.0f, 0.0f, 0.0f);
                float num = 0.0f;
                int fi2 = 0;
                while (fi2 < m.faces()) {
                    Face3ds f = m.face(fi2);
                    if (vi == f.P0 || vi == f.P1 || vi == f.P2) {
                        num += 1.0f;
                        n.add(tmpFaceNormals[fi2]);
                    }
                    ++fi2;
                }
                if (num > 0.0f) {
                    n.mult(1.0f / num);
                }
                n.normalize();
                this._meshes[i].vertexNormals[vi] = n.get();
                this._meshes[i].vertices[vi] = new PVector(p.X, p.Y, p.Z);
                this._meshes[i]._numTexCoords = m.texCoords();
                if (m.texCoords() > 0) {
                    this._meshes[i].texCoords[vi] = new PVector(tc.U, 1.0f - tc.V, 0.0f);
                }
                ++vi;
            }
            tmpFaceNormals = null;
            ++i;
        }
        if ((double)vcounter > 0.0) {
            vcenter.div(vcounter);
        }
    }

    public Camera[] getCameras() {
        if (this._cameras.length == 0) {
            System.err.println("Cameras are not available on this scene");
            return null;
        }
        return this._cameras;
    }

    public Camera getCamera(int idx) {
        if (this._cameras.length == 0) {
            System.err.println("Cameras are not available on this scene");
            return null;
        }
        if (idx >= 0 && idx < this._cameras.length) {
            return this._cameras[idx];
        }
        System.err.println("Index for camera array is not valid");
        return null;
    }

    public Camera getCameraByName(String name) {
        if (this._cameras.length == 0) {
            System.err.println("Cameras are not available on this scene");
            return null;
        }
        int i = 0;
        while (i < this._cameras.length) {
            if (this._cameras[i]._name.equals(name)) {
                return this._cameras[i];
            }
            ++i;
        }
        return null;
    }

    public Light[] getLights() {
        if (this._lights.length == 0) {
            System.err.println("Cameras are not available on this scene");
            return null;
        }
        return this._lights;
    }

    public Light getLight(int idx) {
        if (this._lights.length == 0) {
            System.err.println("Lights are not available on this scene");
            return null;
        }
        if (idx >= 0 && idx < this._lights.length) {
            return this._lights[idx];
        }
        System.err.println("Index for light array is not valid");
        return null;
    }

    public Light getLightByName(String name) {
        if (this._lights.length == 0) {
            System.err.println("Lights are not available on this scene");
            return null;
        }
        int i = 0;
        while (i < this._lights.length) {
            if (this._lights[i]._name.equals(name)) {
                return this._lights[i];
            }
            ++i;
        }
        return null;
    }

    public void useMaterial(boolean f) {
        this._useMaterials = f;
    }

    public void setGlobalColor(float r, float g, float b, float a) {
        this._r = r;
        this._g = g;
        this._b = b;
        this._a = a;
    }

    public static String sketchPath() {
        try {
            return System.getProperty("user.dir");
        }
        catch (Exception exception) {
            return null;
        }
    }

    String dataPath(String where) {
        if (new File(where).isAbsolute()) {
            return where;
        }
        return String.valueOf(V3dsScene.sketchPath()) + File.separator + "data" + File.separator + where;
    }

    public class Camera {
        public String _name;
        public PVector _position;
        public PVector _target;
        public PVector _up;
        public float _roll;

        public String getName() {
            return this._name;
        }

        public PVector getPosition() {
            return this._position;
        }

        public PVector getTarget() {
            return this._target;
        }
    }

    public class Light {
        public String _name;
        public String _type;
        public PVector _position;
        public PVector _target;
        public PVector _color;

        public String getName() {
            return this._name;
        }

        public PVector getPosition() {
            return this._position;
        }

        public PVector getTarget() {
            return this._target;
        }

        public PVector getColor() {
            return this._color;
        }

        public int getIntColor() {
            return 1;
        }
    }

    public class Material {
        String name;
        float[] ambient;
        float[] diffuse;
        float[] specular;
        String textureName;
        int texId;
    }

    public class Mesh {
        PVector[] faceNormals;
        PVector[] faceMiddlePoint;
        PVector[] vertices;
        PVector[] vertexNormals;
        int _numTexCoords;
        PVector[] texCoords;
    }
}

