/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.Tab;
import processing.core.PApplet;

public class Toggle
extends Controller {
    int cnt;
    protected boolean isOn = false;
    protected float internalValue = -1.0f;
    protected static int autoWidth = 40;
    protected static int autoHeight = 20;
    protected CVector3f autoSpacing = new CVector3f(10.0f, 20.0f, 0.0f);

    public Toggle(ControlP5 controlP5, Tab tab, String string, float f, float f2, float f3, int n, int n2) {
        super(controlP5, tab, string, f2, f3, n, n2);
        this._myValue = f;
    }

    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position().x(), this.position().y());
        this._myDisplay.display(pApplet, this);
        pApplet.popMatrix();
    }

    protected void onEnter() {
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    public void mousePressed() {
        this.setState(!this.isOn);
        this.isActive = false;
    }

    public void setValue(float f) {
        if (f == 0.0f) {
            this.setState(false);
        } else {
            this.setState(true);
        }
    }

    public void setValue(boolean bl) {
        this.setValue(bl ? 1.0f : 0.0f);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void setState(boolean bl) {
        this.isOn = bl;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
        this.broadcast(1);
    }

    public boolean getState() {
        return this.isOn;
    }

    protected void deactivate() {
        this.isOn = false;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    protected void activate() {
        this.isOn = true;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    public void toggle() {
        if (this.isOn) {
            this.setState(false);
        } else {
            this.setState(true);
        }
    }

    public void setMode(int n) {
        this.updateDisplayMode(n);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "toggle");
    }

    public void setInternalValue(float f) {
        this.internalValue = f;
    }

    public float internalValue() {
        return this.internalValue;
    }

    public Controller linebreak() {
        this.controlP5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new ToggleDisplay();
                break;
            }
            case 2: {
                this._myDisplay = new ToggleSpriteDisplay();
                break;
            }
            case 1: {
                this._myDisplay = new ToggleImageDisplay();
                break;
            }
            case 100: {
                this._myDisplay = new ToggleSwitchDisplay();
                break;
            }
        }
    }

    class ToggleSwitchDisplay
    implements ControllerDisplay {
        ToggleSwitchDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.fill(Toggle.this.color.colorBackground);
            pApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            pApplet.fill(Toggle.this.color.colorActive);
            if (Toggle.this.isOn) {
                pApplet.rect(0.0f, 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            } else {
                pApplet.rect((float)((Toggle.this.width % 2 == 0 ? 0 : 1) + Toggle.this.width / 2), 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            }
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(pApplet, 0, Toggle.this.height + 4);
            }
        }
    }

    class ToggleImageDisplay
    implements ControllerDisplay {
        ToggleImageDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Toggle.this.isActive) {
                pApplet.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else if (Toggle.this.isOn) {
                pApplet.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else {
                pApplet.image(Toggle.this.images[0], 0.0f, 0.0f);
            }
            pApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
        }
    }

    class ToggleSpriteDisplay
    implements ControllerDisplay {
        ToggleSpriteDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Toggle.this.isActive) {
                Toggle.this.sprite.setState(1);
            } else if (Toggle.this.isOn) {
                Toggle.this.sprite.setState(1);
            } else {
                Toggle.this.sprite.setState(0);
            }
        }
    }

    class ToggleDisplay
    implements ControllerDisplay {
        ToggleDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Toggle.this.isActive) {
                pApplet.fill(Toggle.this.color.colorActive);
            } else {
                pApplet.fill(Toggle.this.isOn ? Toggle.this.color.colorActive : Toggle.this.color.colorBackground);
            }
            pApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(pApplet, 0, Toggle.this.height + 4);
            }
        }
    }
}

