/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.CRect;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.MultiList;
import controlP5.MultiListInterface;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiListButton
extends Button
implements MultiListInterface {
    MultiListInterface parent;
    MultiList root;
    CRect _myRect;
    protected int _myDirection = 39;

    protected MultiListButton(ControlP5 controlP5, String string, float f, int n, int n2, int n3, int n4, MultiListInterface multiListInterface, MultiList multiList) {
        super(controlP5, (ControllerGroup)multiList.parent(), string, f, n, n2, n3, n4);
        this.parent = multiListInterface;
        this.root = multiList;
        this.isXMLsavable = false;
        this.updateRect(this.position().x(), this.position().y(), this.width, this.height);
    }

    @Override
    public void remove() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.parent.subelements().size(); ++n) {
            if ((MultiListButton)this.parent.subelements().get(n) == this) {
                n2 = this.height + 1;
            }
            ((MultiListButton)this.parent.subelements().get(n)).updateLocation(0.0f, -n2);
        }
        if (this._myParent != null) {
            this.removeListener(this.root);
            this._myParent.remove(this);
        }
        if (this.controlP5 != null) {
            this.removeListener(this.root);
            this.controlP5.remove(this);
        }
        for (n = 0; n < this.subelements.size(); ++n) {
            ((MultiListButton)this.subelements.get(n)).remove();
        }
    }

    @Override
    public List<Controller> subelements() {
        return this.subelements;
    }

    @Override
    public int getDirection() {
        return this._myDirection;
    }

    protected void setDirection(int n) {
        this._myDirection = n;
    }

    public void updateRect(float f, float f2, float f3, float f4) {
        this._myRect = new CRect(f, f2, f3, f4);
    }

    @Override
    public void updateLocation(float f, float f2) {
        this.position().x += f;
        this.position().y += f2;
        this.updateRect(this.position().x, this.position().y, this.width, this.height);
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListInterface)this.subelements.get(i)).updateLocation(f, f2);
        }
    }

    @Override
    public Controller setWidth(int n) {
        int n2 = this._myDirection == 37 ? n - this.width : 0;
        this.width = n;
        this.updateLocation(-n2, 0.0f);
        return this;
    }

    @Override
    public Controller setHeight(int n) {
        int n2 = this.height;
        this.height = n;
        n2 = this.height - n2;
        int n3 = 0;
        for (int i = 0; i < this.parent.subelements().size(); ++i) {
            ((MultiListButton)this.parent.subelements().get(i)).updateLocation(0.0f, n3);
            if ((MultiListButton)this.parent.subelements().get(i) != this) continue;
            n3 = n2;
        }
        this.updateLocation(0.0f, 0.0f);
        return this;
    }

    public MultiListButton add(String string, float f) {
        int n;
        int n2 = -(this.height + 1);
        for (n = 0; n < this.subelements().size(); ++n) {
            n2 += ((MultiListButton)this.subelements().get((int)n)).height + 1;
        }
        n = (int)this.position().x + (this.width + 1);
        MultiListButton multiListButton = new MultiListButton(this.controlP5, string, f, n, (int)this.position().y + (this.height + 1) + n2, this.width, this.height, this, this.root);
        multiListButton.isMoveable = false;
        multiListButton.hide();
        this.controlP5.register(multiListButton);
        multiListButton.addListener(this.root);
        this.subelements.add(multiListButton);
        this.updateRect(n, this.position().y(), this.width, this.height + 1 + n2);
        return multiListButton;
    }

    @Override
    protected void onEnter() {
        if (!this.root.isUpdateLocation) {
            this.isActive = true;
            this.root.occupied(true);
            this.root.mostRecent = this;
            this.parent.close(this);
            this.open();
        }
    }

    @Override
    protected void onLeave() {
        if (!this.parent.observe() && !this.root.isUpdateLocation && this.root.mostRecent == this) {
            this.isActive = false;
            this.root.occupied(false);
        }
    }

    @Override
    public void mouseReleasedOutside() {
    }

    @Override
    public boolean observe() {
        return CRect.inside(this._myRect, this._myControlWindow.mouseX, this._myControlWindow.mouseY);
    }

    @Override
    public void close(MultiListInterface multiListInterface) {
        for (int i = 0; i < this.subelements.size(); ++i) {
            if (multiListInterface == (MultiListInterface)this.subelements.get(i)) continue;
            ((MultiListInterface)this.subelements.get(i)).close();
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListButton)this.subelements.get(i)).close();
            ((MultiListButton)this.subelements.get(i)).hide();
        }
    }

    @Override
    public void open() {
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListButton)this.subelements.get(i)).show();
        }
    }

    @Override
    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        ControlP5XMLElement controlP5XMLElement2 = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement2.setName("mlbutton");
        controlP5XMLElement2.setAttribute("name", this.name());
        controlP5XMLElement2.setAttribute("parent", this.parent.name());
        controlP5XMLElement.addChild(controlP5XMLElement2);
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListInterface)this.subelements.get(i)).addToXMLElement(controlP5XMLElement);
        }
    }
}

