/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.util.Vector;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Attribute;
import jm.util.ConversionException;
import jm.util.Element;
import jm.util.StandardXMLStyle;
import jm.util.XMLStyle;
import jm.util.XMLStyles;

class XMLParser {
    private static final XMLStyle DEFAULT_XML_STYLE = new StandardXMLStyle();

    private XMLParser() {
    }

    public static String scoreToXMLString(Score score) {
        return String.valueOf(DEFAULT_XML_STYLE.initialXMLDeclaration()) + XMLParser.scoreToXMLString(score, DEFAULT_XML_STYLE);
    }

    private static String scoreToXMLString(Score score, XMLStyle xmlStyle) {
        int size;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(xmlStyle.getLeftAngleBracket()) + xmlStyle.getScoreTagName());
        if (!score.getTitle().equals("Untitled Score")) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getTitleAttributeName() + "=" + xmlStyle.getDoubleQuote());
            String title = score.getTitle();
            i = 0;
            while (i < title.length()) {
                char character = title.charAt(i);
                if (character == ' ') {
                    buffer.append(xmlStyle.getSpace());
                } else if (character == '/') {
                    buffer.append(xmlStyle.getSlash());
                } else if (character == '&') {
                    buffer.append(xmlStyle.getAmpersandInString());
                } else if (character == '<') {
                    buffer.append(xmlStyle.getLeftAngleBracketInString());
                } else if (character == '>') {
                    buffer.append(xmlStyle.getRightAngleBracketInString());
                } else if (character == '\"') {
                    buffer.append(xmlStyle.getDoubleQuoteInString());
                } else if (character == '#') {
                    buffer.append(xmlStyle.getHash());
                } else if (character == '/') {
                    buffer.append(xmlStyle.getSlash());
                } else if (character == '?') {
                    buffer.append(xmlStyle.getQuestionMark());
                } else if (character == ';') {
                    buffer.append(xmlStyle.getSemicolon());
                } else {
                    buffer.append(character);
                }
                ++i;
            }
            buffer.append(xmlStyle.getDoubleQuote());
        }
        if (score.getTempo() != 60.0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getTempoAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(score.getTempo(), 2) : Double.toString(score.getTempo())) + xmlStyle.getDoubleQuote());
        }
        if (score.getVolume() != 100) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getVolumeAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(score.getVolume()) + xmlStyle.getDoubleQuote());
        }
        if (score.getKeySignature() != 0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getKeySignatureAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(score.getKeySignature()) + xmlStyle.getDoubleQuote());
        }
        if (score.getKeyQuality() != 0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getKeyQualityAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(score.getKeyQuality()) + xmlStyle.getDoubleQuote());
        }
        if (score.getNumerator() != 4) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getNumeratorAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(score.getNumerator()) + xmlStyle.getDoubleQuote());
        }
        if (score.getDenominator() != 4) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getDenominatorAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(score.getDenominator()) + xmlStyle.getDoubleQuote());
        }
        if ((size = score.size()) == 0) {
            buffer.append(String.valueOf(xmlStyle.getSlash()) + xmlStyle.getRightAngleBracket());
        } else {
            buffer.append(xmlStyle.getRightAngleBracket());
            i = 0;
            while (i < score.size()) {
                buffer.append(XMLParser.partToXMLString(score.getPart(i), xmlStyle));
                ++i;
            }
            buffer.append(String.valueOf(xmlStyle.getLeftAngleBracket()) + xmlStyle.getSlash() + xmlStyle.getScoreTagName() + xmlStyle.getRightAngleBracket());
        }
        return buffer.toString();
    }

    public static String partToXMLString(Part part) {
        return String.valueOf(DEFAULT_XML_STYLE.initialXMLDeclaration()) + XMLParser.partToXMLString(part, DEFAULT_XML_STYLE);
    }

    private static String partToXMLString(Part part, XMLStyle xmlStyle) {
        int size;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(xmlStyle.getLeftAngleBracket()) + xmlStyle.getPartTagName());
        if (!part.getTitle().equals("Untitled Part")) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getTitleAttributeName() + "=" + xmlStyle.getDoubleQuote());
            String title = part.getTitle();
            i = 0;
            while (i < title.length()) {
                char character = title.charAt(i);
                if (character == ' ') {
                    buffer.append(xmlStyle.getSpace());
                } else if (character == '/') {
                    buffer.append(xmlStyle.getSlash());
                } else if (character == '&') {
                    buffer.append(xmlStyle.getAmpersandInString());
                } else if (character == '<') {
                    buffer.append(xmlStyle.getLeftAngleBracketInString());
                } else if (character == '>') {
                    buffer.append(xmlStyle.getRightAngleBracketInString());
                } else if (character == '\"') {
                    buffer.append(xmlStyle.getDoubleQuoteInString());
                } else if (character == '#') {
                    buffer.append(xmlStyle.getHash());
                } else if (character == '?') {
                    buffer.append(xmlStyle.getQuestionMark());
                } else if (character == ';') {
                    buffer.append(xmlStyle.getSemicolon());
                } else {
                    buffer.append(character);
                }
                ++i;
            }
            buffer.append(xmlStyle.getDoubleQuote());
        }
        if (part.getChannel() != 0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getChannelAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(part.getChannel()) + xmlStyle.getDoubleQuote());
        }
        if (part.getInstrument() != 0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getInstrumentAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(part.getInstrument()) + xmlStyle.getDoubleQuote());
        }
        if (part.getTempo() != -1.0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getTempoAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(part.getTempo(), 2) : Double.toString(part.getTempo())) + xmlStyle.getDoubleQuote());
        }
        if (part.getVolume() != 100) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getVolumeAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(part.getVolume()) + xmlStyle.getDoubleQuote());
        }
        if (part.getKeySignature() != Integer.MIN_VALUE) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getKeySignatureAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(part.getKeySignature()) + xmlStyle.getDoubleQuote());
        }
        if (part.getKeyQuality() != Integer.MIN_VALUE) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getKeyQualityAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(part.getKeyQuality()) + xmlStyle.getDoubleQuote());
        }
        if (part.getNumerator() != Integer.MIN_VALUE) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getNumeratorAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(part.getNumerator()) + xmlStyle.getDoubleQuote());
        }
        if (part.getDenominator() != Integer.MIN_VALUE) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getDenominatorAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(part.getDenominator()) + xmlStyle.getDoubleQuote());
        }
        if (part.getPan() != 0.5) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getPanAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(part.getPan(), 2) : Double.toString(part.getPan())) + xmlStyle.getDoubleQuote());
        }
        if ((size = part.size()) == 0) {
            buffer.append(String.valueOf(xmlStyle.getSlash()) + xmlStyle.getRightAngleBracket());
        } else {
            buffer.append(xmlStyle.getRightAngleBracket());
            i = 0;
            while (i < part.size()) {
                buffer.append(XMLParser.phraseToXMLString(part.getPhrase(i), xmlStyle));
                ++i;
            }
            buffer.append(String.valueOf(xmlStyle.getLeftAngleBracket()) + xmlStyle.getSlash() + xmlStyle.getPartTagName() + xmlStyle.getRightAngleBracket());
        }
        return buffer.toString();
    }

    public static String phraseToXMLString(Phrase phrase) {
        return String.valueOf(DEFAULT_XML_STYLE.initialXMLDeclaration()) + XMLParser.phraseToXMLString(phrase, DEFAULT_XML_STYLE);
    }

    private static String phraseToXMLString(Phrase phrase, XMLStyle xmlStyle) {
        int size;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(xmlStyle.getLeftAngleBracket()) + xmlStyle.getPhraseTagName());
        if (!phrase.getTitle().equals("Untitled Phrase")) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getTitleAttributeName() + "=" + xmlStyle.getDoubleQuote());
            String title = phrase.getTitle();
            i = 0;
            while (i < title.length()) {
                char character = title.charAt(i);
                if (character == ' ') {
                    buffer.append(xmlStyle.getSpace());
                } else if (character == '/') {
                    buffer.append(xmlStyle.getSlash());
                } else if (character == '&') {
                    buffer.append(xmlStyle.getAmpersandInString());
                } else if (character == '<') {
                    buffer.append(xmlStyle.getLeftAngleBracketInString());
                } else if (character == '>') {
                    buffer.append(xmlStyle.getRightAngleBracketInString());
                } else if (character == '\"') {
                    buffer.append(xmlStyle.getDoubleQuoteInString());
                } else if (character == '#') {
                    buffer.append(xmlStyle.getHash());
                } else if (character == '?') {
                    buffer.append(xmlStyle.getQuestionMark());
                } else if (character == ';') {
                    buffer.append(xmlStyle.getSemicolon());
                } else {
                    buffer.append(character);
                }
                ++i;
            }
            buffer.append(xmlStyle.getDoubleQuote());
        }
        if (phrase.getStartTime() != 0.0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getStartTimeAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(phrase.getStartTime(), 2) : Double.toString(phrase.getStartTime())) + xmlStyle.getDoubleQuote());
        }
        if (phrase.getInstrument() != -1) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getInstrumentAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(phrase.getInstrument()) + xmlStyle.getDoubleQuote());
        }
        if (phrase.getPan() != -1.0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getTempoAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(phrase.getTempo(), 2) : Double.toString(phrase.getTempo())) + xmlStyle.getDoubleQuote());
        }
        if (phrase.getAppend()) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getAppendAttributeName() + "=" + xmlStyle.getDoubleQuote() + (phrase.getAppend() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()) + xmlStyle.getDoubleQuote());
        }
        if (phrase.getPan() != 0.5) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getPanAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(phrase.getPan(), 2) : Double.toString(phrase.getPan())) + xmlStyle.getDoubleQuote());
        }
        if ((size = phrase.size()) == 0) {
            buffer.append(String.valueOf(xmlStyle.getSlash()) + xmlStyle.getRightAngleBracket());
        } else {
            buffer.append(xmlStyle.getRightAngleBracket());
            i = 0;
            while (i < size) {
                buffer.append(XMLParser.noteToXMLString(phrase.getNote(i), xmlStyle));
                ++i;
            }
            buffer.append(String.valueOf(xmlStyle.getLeftAngleBracket()) + xmlStyle.getSlash() + xmlStyle.getPhraseTagName() + xmlStyle.getRightAngleBracket());
        }
        return buffer.toString();
    }

    public static String noteToXMLString(Note note) {
        return String.valueOf(DEFAULT_XML_STYLE.initialXMLDeclaration()) + XMLParser.noteToXMLString(note, DEFAULT_XML_STYLE);
    }

    private static String noteToXMLString(Note note, XMLStyle xmlStyle) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(xmlStyle.getLeftAngleBracket()) + xmlStyle.getNoteTagName());
        if (!note.getPitchType()) {
            if (note.getPitch() != 60) {
                buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getPitchAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(note.getPitch()) + xmlStyle.getDoubleQuote());
            }
        } else {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getFrequencyAttributeName() + "=" + xmlStyle.getDoubleQuote() + Double.toString(note.getFrequency()) + xmlStyle.getDoubleQuote());
        }
        if (note.getDynamic() != 85) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getDynamicAttributeName() + "=" + xmlStyle.getDoubleQuote() + Integer.toString(note.getDynamic()) + xmlStyle.getDoubleQuote());
        }
        if (note.getRhythmValue() != 1.0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getRhythmValueAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getRhythmValue(), 2) : Double.toString(note.getRhythmValue())) + xmlStyle.getDoubleQuote());
        }
        if (note.getPan() != 0.5) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getPanAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getPan(), 2) : Double.toString(note.getPan())) + xmlStyle.getDoubleQuote());
        }
        if (note.getDuration() != 0.9) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getDurationAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getDuration(), 2) : Double.toString(note.getDuration())) + xmlStyle.getDoubleQuote());
        }
        if (note.getOffset() != 0.0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getOffsetAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getOffset(), 2) : Double.toString(note.getOffset())) + xmlStyle.getDoubleQuote());
        }
        if (note.getSampleStartTime() != 0.0) {
            buffer.append(String.valueOf(xmlStyle.getSpace()) + xmlStyle.getSampleStartTimeAttributeName() + "=" + xmlStyle.getDoubleQuote() + (xmlStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getSampleStartTime(), 2) : Double.toString(note.getSampleStartTime())) + xmlStyle.getDoubleQuote());
        }
        buffer.append(String.valueOf(xmlStyle.getSlash()) + xmlStyle.getRightAngleBracket());
        return buffer.toString();
    }

    private static String limitDecimalPlaces(double d, int places) {
        String dString = Double.toString(d);
        int lastIndex = dString.lastIndexOf(".") + places + 1;
        if (lastIndex > dString.length()) {
            lastIndex = dString.length();
        }
        return dString.substring(0, lastIndex);
    }

    public static Score xmlStringToScore(String string) throws ConversionException {
        String xmlAsString = XMLParser.preprocessString(string);
        Element[] elements = XMLParser.xmlStringToElements(xmlAsString);
        if (elements.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elements.length + " root elements.");
        }
        Element element = elements[0];
        if (XMLStyles.isValidScoreTag(elements[0].getName())) {
            return XMLParser.elementToScore(elements[0]);
        }
        if (XMLStyles.isValidPartTag(elements[0].getName())) {
            return new Score(XMLParser.elementToPart(elements[0]));
        }
        if (XMLStyles.isValidPhraseTag(elements[0].getName())) {
            return new Score(new Part(XMLParser.elementToPhrase(elements[0])));
        }
        if (XMLStyles.isValidNoteTag(elements[0].getName())) {
            return new Score(new Part(new Phrase(XMLParser.elementToNote(elements[0]))));
        }
        throw new ConversionException("Unrecognised root element: " + elements[0].getName());
    }

    public static Part xmlStringToPart(String string) throws ConversionException {
        String xmlAsString = XMLParser.preprocessString(string);
        Element[] elements = XMLParser.xmlStringToElements(xmlAsString);
        if (elements.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elements.length + " root elements.");
        }
        Element element = elements[0];
        if (XMLStyles.isValidScoreTag(elements[0].getName())) {
            throw new ConversionException("This XML string represents a Score, use the xmlStringToScore(String) method instead.");
        }
        if (XMLStyles.isValidPartTag(elements[0].getName())) {
            return XMLParser.elementToPart(elements[0]);
        }
        if (XMLStyles.isValidPhraseTag(elements[0].getName())) {
            return new Part(XMLParser.elementToPhrase(elements[0]));
        }
        if (XMLStyles.isValidNoteTag(elements[0].getName())) {
            return new Part(new Phrase(XMLParser.elementToNote(elements[0])));
        }
        throw new ConversionException("Unrecognised root element: " + elements[0].getName());
    }

    public static Phrase xmlStringToPhrase(String string) throws ConversionException {
        String xmlAsString = XMLParser.preprocessString(string);
        Element[] elements = XMLParser.xmlStringToElements(xmlAsString);
        if (elements.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elements.length + " root elements.");
        }
        Element element = elements[0];
        if (XMLStyles.isValidScoreTag(elements[0].getName())) {
            throw new ConversionException("This XML string represents a Score, use the xmlStringToScore(String) method instead.");
        }
        if (XMLStyles.isValidPartTag(elements[0].getName())) {
            throw new ConversionException("This XML string represents a Part, use the xmlStringToPart(String) method instead.");
        }
        if (XMLStyles.isValidPhraseTag(elements[0].getName())) {
            return XMLParser.elementToPhrase(elements[0]);
        }
        if (XMLStyles.isValidNoteTag(elements[0].getName())) {
            return new Phrase(XMLParser.elementToNote(elements[0]));
        }
        throw new ConversionException("Unrecognised root element: " + elements[0].getName());
    }

    public static Note xmlStringToNote(String string) throws ConversionException {
        String xmlAsString = XMLParser.preprocessString(string);
        Element[] elements = XMLParser.xmlStringToElements(xmlAsString);
        if (elements.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elements.length + " root elements.");
        }
        Element element = elements[0];
        if (XMLStyles.isValidScoreTag(elements[0].getName())) {
            throw new ConversionException("This XML string represents a Score, use the xmlStringToScore(String) method instead.");
        }
        if (XMLStyles.isValidPartTag(elements[0].getName())) {
            throw new ConversionException("This XML string represents a Part, use the xmlStringToPart(String) method instead.");
        }
        if (XMLStyles.isValidPhraseTag(elements[0].getName())) {
            throw new ConversionException("This XML string represents a Phrase, use the xmlStringToPhrase(String) method instead.");
        }
        if (XMLStyles.isValidNoteTag(elements[0].getName())) {
            return XMLParser.elementToNote(elements[0]);
        }
        throw new ConversionException("Unrecognised root element: " + elements[0].getName());
    }

    /*
     * Unable to fully structure code
     */
    private static String preprocessString(String string) throws ConversionException {
        xmlAsString = string;
        i = 0;
        while (i < XMLStyles.styles.length) {
            decl = XMLStyles.styles[i].initialXMLDeclaration();
            if (string.startsWith(decl)) {
                xmlAsString = xmlAsString.substring(decl.length());
                break;
            }
            ++i;
        }
        xmlAsCharArray = xmlAsString.toCharArray();
        buffer = null;
        xmlStyle = new StandardXMLStyle();
        CHARS_ARRAY = xmlStyle.getEncodingsOfReferenceChars();
        REFERENCE_CHARS = xmlStyle.getReferenceChars();
        i = 0;
        while (i < CHARS_ARRAY.length) {
            buffer = new StringBuffer();
            pattern = new String(CHARS_ARRAY[i]);
            lastIndex = 0;
            currentIndex = xmlAsString.indexOf(pattern);
            ** GOTO lbl30
            {
                buffer.append(xmlAsCharArray[lastIndex]);
                ++lastIndex;
                do {
                    if (lastIndex < currentIndex) continue block2;
                    buffer.append(REFERENCE_CHARS[i]);
                    currentIndex = xmlAsString.indexOf(pattern, lastIndex += 3);
lbl30:
                    // 2 sources

                } while (currentIndex != -1);
            }
            currentIndex = xmlAsString.length();
            while (lastIndex < currentIndex) {
                buffer.append(xmlAsCharArray[lastIndex]);
                ++lastIndex;
            }
            xmlAsString = buffer.toString();
            xmlAsCharArray = xmlAsString.toCharArray();
            ++i;
        }
        return xmlAsString;
    }

    private static Score elementToScore(Element element) throws ConversionException {
        StandardXMLStyle xmlStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidScoreTag(element.getName())) {
            throw new ConversionException("The root element must have the name '" + xmlStyle.getScoreTagName() + "'.  The invalid name used " + "was '" + element.getName() + "'.");
        }
        Score returnScore = new Score();
        String attributeValue = XMLStyles.getTitleAttributeValue(element);
        if (!attributeValue.equals("")) {
            returnScore.setTitle(attributeValue);
        }
        if (!(attributeValue = XMLStyles.getTempoAttributeValue(element)).equals("")) {
            try {
                returnScore.setTempo(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getTempoAttributeName() + "' of element '" + xmlStyle.getScoreTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getVolumeAttributeValue(element)).equals("")) {
            try {
                returnScore.setVolume(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getVolumeAttributeName() + "' of element '" + xmlStyle.getScoreTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getKeySignatureAttributeValue(element)).equals("")) {
            try {
                returnScore.setKeySignature(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getKeySignatureAttributeName() + "' of element '" + xmlStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getKeyQualityAttributeValue(element)).equals("")) {
            try {
                returnScore.setKeyQuality(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getKeyQualityAttributeName() + "' of element '" + xmlStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getNumeratorAttributeValue(element)).equals("")) {
            try {
                returnScore.setNumerator(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getNumeratorAttributeName() + "' of element '" + xmlStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getDenominatorAttributeValue(element)).equals("")) {
            try {
                returnScore.setDenominator(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getDenominatorAttributeName() + "' of element '" + xmlStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        Element[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (XMLStyles.isValidPartTag(children[i].getName())) {
                returnScore.addPart(XMLParser.elementToPart(children[i]));
            }
            ++i;
        }
        return returnScore;
    }

    private static Part elementToPart(Element element) throws ConversionException {
        StandardXMLStyle xmlStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidPartTag(element.getName())) {
            throw new ConversionException("Invalid element: " + element.getName() + ".  The only " + "accepted tag name is '" + xmlStyle.getPartTagName() + "'.");
        }
        Part returnPart = new Part();
        String attributeValue = XMLStyles.getTitleAttributeValue(element);
        if (!attributeValue.equals("")) {
            returnPart.setTitle(attributeValue);
        }
        if (!(attributeValue = XMLStyles.getChannelAttributeValue(element)).equals("")) {
            try {
                returnPart.setChannel(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getChannelAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getInstrumentAttributeValue(element)).equals("")) {
            try {
                returnPart.setInstrument(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getInstrumentAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getTempoAttributeValue(element)).equals("")) {
            try {
                returnPart.setTempo(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getTempoAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getVolumeAttributeValue(element)).equals("")) {
            try {
                returnPart.setVolume(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getVolumeAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getKeySignatureAttributeValue(element)).equals("")) {
            try {
                returnPart.setKeySignature(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getKeySignatureAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getKeyQualityAttributeValue(element)).equals("")) {
            try {
                returnPart.setKeyQuality(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getKeyQualityAttributeName() + "' of element '" + xmlStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getNumeratorAttributeValue(element)).equals("")) {
            try {
                returnPart.setNumerator(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getNumeratorAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getDenominatorAttributeValue(element)).equals("")) {
            try {
                returnPart.setDenominator(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getDenominatorAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getPanAttributeValue(element)).equals("")) {
            try {
                returnPart.setPan(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getPanAttributeName() + "' of element '" + xmlStyle.getPartTagName() + "' must represent a Java double.");
            }
        }
        Element[] elements = element.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (XMLStyles.isValidPhraseTag(elements[i].getName())) {
                returnPart.addPhrase(XMLParser.elementToPhrase(elements[i]));
            }
            ++i;
        }
        return returnPart;
    }

    private static Phrase elementToPhrase(Element element) throws ConversionException {
        StandardXMLStyle xmlStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidPhraseTag(element.getName())) {
            throw new ConversionException("Invalid element: " + element.getName() + ".  The only " + "accepted tag name is '" + xmlStyle.getPhraseTagName() + "'.");
        }
        Phrase returnPhrase = new Phrase();
        String attributeValue = XMLStyles.getTitleAttributeValue(element);
        if (!attributeValue.equals("")) {
            try {
                returnPhrase.setTitle(attributeValue);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getTitleAttributeName() + "' of element '" + xmlStyle.getPhraseTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getStartTimeAttributeValue(element)).equals("")) {
            try {
                returnPhrase.setStartTime(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getStartTimeAttributeName() + "' of element '" + xmlStyle.getPhraseTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getInstrumentAttributeValue(element)).equals("")) {
            try {
                returnPhrase.setInstrument(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getInstrumentAttributeName() + "' of element '" + xmlStyle.getPhraseTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getTempoAttributeValue(element)).equals("")) {
            try {
                returnPhrase.setTempo(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getTempoAttributeName() + "' of element '" + xmlStyle.getPhraseTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getAppendAttributeValue(element)).equals("")) {
            returnPhrase.setAppend(new Boolean(attributeValue));
        }
        if (!(attributeValue = XMLStyles.getPanAttributeValue(element)).equals("")) {
            try {
                returnPhrase.setPan(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getPanAttributeName() + "' of element '" + xmlStyle.getPhraseTagName() + "' must represent a Java double.");
            }
        }
        Element[] elements = element.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (XMLStyles.isValidNoteTag(elements[i].getName())) {
                returnPhrase.addNote(XMLParser.elementToNote(elements[i]));
            }
            ++i;
        }
        return returnPhrase;
    }

    private static Note elementToNote(Element element) throws ConversionException {
        StandardXMLStyle xmlStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidNoteTag(element.getName())) {
            throw new ConversionException("Invalid element: " + element.getName() + ".  The only " + "accepted tag name is '" + xmlStyle.getNoteTagName() + "'.");
        }
        Note returnNote = new Note();
        String attributeValue = XMLStyles.getPitchAttributeValue(element);
        if (!attributeValue.equals("")) {
            try {
                returnNote.setPitch(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getPitchAttributeName() + "' of element '" + xmlStyle.getNoteTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getFrequencyAttributeValue(element)).equals("")) {
            try {
                double tempVal = Double.valueOf(attributeValue);
                returnNote.setFrequency(tempVal);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getFrequencyAttributeName() + "' of element '" + xmlStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getDynamicAttributeValue(element)).equals("")) {
            try {
                returnNote.setDynamic(Integer.parseInt(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getDynamicAttributeName() + "' of element '" + xmlStyle.getNoteTagName() + "' must represent a Java integer.");
            }
        }
        if (!(attributeValue = XMLStyles.getRhythmValueAttributeValue(element)).equals("")) {
            try {
                returnNote.setRhythmValue(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getRhythmValueAttributeName() + "' of element '" + xmlStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getPanAttributeValue(element)).equals("")) {
            try {
                returnNote.setPan(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getPanAttributeName() + "' of element '" + xmlStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getDurationAttributeValue(element)).equals("")) {
            try {
                returnNote.setDuration(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getDurationAttributeName() + "' of element '" + xmlStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getOffsetAttributeValue(element)).equals("")) {
            try {
                returnNote.setOffset(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getOffsetAttributeName() + "' of element '" + xmlStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(attributeValue = XMLStyles.getSampleStartTimeAttributeValue(element)).equals("")) {
            try {
                returnNote.setSampleStartTime(Double.valueOf(attributeValue));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Invalid attribute value: " + attributeValue + ".  The " + "attribute '" + xmlStyle.getSampleStartTimeAttributeName() + "' of " + "element '" + xmlStyle.getNoteTagName() + "' must represent a " + "Java double.");
            }
        }
        return returnNote;
    }

    private static Element[] xmlStringToElements(String string) throws ConversionException {
        Vector<Element> elementsToBeReturned = new Vector<Element>();
        StandardXMLStyle xmlStyle = new StandardXMLStyle();
        char[][] ENCODINGS_ARRAY = ((XMLStyle)xmlStyle).getEncodingsOfValueReferenceChars();
        char[] REFERENCE_CHARS = ((XMLStyle)xmlStyle).getValueReferenceChars();
        try {
            int count = 0;
            if (string.charAt(count++) != '<') {
                throw new ConversionException("XML String does not begin with '<'");
            }
            StringBuffer elementName = new StringBuffer();
            char character = string.charAt(count++);
            while (character != ' ' && character != '/' && character != '>') {
                elementName.append(character);
                character = string.charAt(count++);
            }
            Element element = new Element(elementName.toString());
            while (character == ' ') {
                StringBuffer attributeName = new StringBuffer();
                character = string.charAt(count++);
                while (character != '=') {
                    if (character == '/') {
                        throw new ConversionException("Illegal character '/' in attribute name of the '" + element.getName() + "' element.");
                    }
                    if (character == '>') {
                        throw new ConversionException("Illegal character '>' in attribute name of the '" + element.getName() + "' element.");
                    }
                    attributeName.append(character);
                    character = string.charAt(count++);
                }
                Attribute attribute = new Attribute(attributeName.toString());
                if ((character = string.charAt(count++)) != '\"') {
                    throw new ConversionException("The value of the '" + attribute.getName() + "' attribute in the '" + element.getName() + "' element does not begin with a double-quote " + "(\").");
                }
                StringBuffer valueBuffer = new StringBuffer();
                character = string.charAt(count++);
                while (character != '\"') {
                    int i = 0;
                    block8: while (i < ENCODINGS_ARRAY.length) {
                        int j = 0;
                        while (j < ENCODINGS_ARRAY[i].length) {
                            try {
                                if (ENCODINGS_ARRAY[i][j] != string.charAt(count + j - 1)) {
                                    if (i != ENCODINGS_ARRAY.length - 1) break;
                                    valueBuffer.append(character);
                                    break;
                                }
                                if (j == ENCODINGS_ARRAY[i].length - 1) {
                                    count += ENCODINGS_ARRAY[i].length - 1;
                                    valueBuffer.append(REFERENCE_CHARS[i]);
                                    break block8;
                                }
                            }
                            catch (IndexOutOfBoundsException e) {
                                if (i != ENCODINGS_ARRAY.length - 1) break;
                                valueBuffer.append(character);
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    character = string.charAt(count++);
                }
                attribute.setValue(valueBuffer.toString());
                element.addAttribute(attribute);
                character = string.charAt(count++);
            }
            if (character == '>') {
                int endIndex = string.indexOf("</" + element.getName() + ">");
                if (endIndex == -1) {
                    throw new ConversionException("No closing tag found: </" + element.getName() + ">");
                }
                element.appendChildren(XMLParser.xmlStringToElements(string.substring(count, endIndex)));
                count = endIndex + element.getName().length() + 3;
            } else if (character == '/') {
                if ((character = string.charAt(count++)) != '>') {
                    throw new ConversionException("Character '>' is expected to terminate the '" + element.getName() + "' element but was not " + "found.");
                }
            } else {
                throw new ConversionException("Either '>' or '/>' is expected to terminate the '" + element.getName() + "' element but neither was " + "found.");
            }
            elementsToBeReturned.addElement(element);
            if (count < string.length()) {
                Element[] furtherElements = XMLParser.xmlStringToElements(string.substring(count));
                int i = 0;
                while (i < furtherElements.length) {
                    elementsToBeReturned.addElement(furtherElements[i]);
                    ++i;
                }
            }
            Object[] returnElements = new Element[elementsToBeReturned.size()];
            elementsToBeReturned.copyInto(returnElements);
            return returnElements;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConversionException("Xml string ended prematurely.  Further characters were excepted.");
        }
    }
}

