/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import jm.JMC;
import jm.audio.Audio;
import jm.audio.Instrument;
import jm.audio.io.AudioFileOut;
import jm.midi.MidiParser;
import jm.midi.SMF;
import jm.music.data.CPhrase;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.XMLParser;

public class Write
implements JMC {
    public static void midi(Score score) {
        FileDialog fd = new FileDialog(new Frame(), "Save as a MIDI file ...", 1);
        fd.setFile("jMusic_composition.mid");
        fd.show();
        if (fd.getFile() != null) {
            Write.midi(score, String.valueOf(fd.getDirectory()) + fd.getFile());
        }
    }

    public static void midi(Score scr, OutputStream outputStream) {
        SMF smf = new SMF();
        try {
            smf.clearTracks();
            MidiParser.scoreToSMF(scr, smf);
            smf.write(outputStream);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void midi(Score scr, String fileName) {
        SMF smf = new SMF();
        try {
            double time1 = System.currentTimeMillis();
            System.out.println("----------------------------- Writing MIDI File ------------------------------");
            smf.clearTracks();
            MidiParser.scoreToSMF(scr, smf);
            FileOutputStream os = new FileOutputStream(fileName);
            smf.write(os);
            double time2 = System.currentTimeMillis();
            System.out.println("MIDI file '" + fileName + "' written from score '" + scr.getTitle() + "' in " + (time2 - time1) / 1000.0 + " seconds.");
            System.out.println("------------------------------------------------------------------------------");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void midi(Part p) {
        Write.midi(new Score(p));
    }

    public static void midi(Part p, String fileName) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Write.midi(s, fileName);
    }

    public static void midi(Phrase phr) {
        Write.midi(new Score(new Part(phr)));
    }

    public static void midi(Phrase phr, String fileName) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Write.midi(s, fileName);
    }

    public static void midi(CPhrase cphr) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.midi(s, String.valueOf(cphr.getTitle()) + ".mid");
    }

    public static void midi(CPhrase cphr, String fileName) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.midi(s, fileName);
    }

    public static void midi(Note n) {
        Write.midi(n, "SingleNote.mid");
    }

    public static void midi(Note n, String fileName) {
        Score s = new Score("Score of a single note");
        Part p = new Part(new Phrase(n));
        s.addPart(p);
        Write.midi(s, fileName);
    }

    public static void jm(Score s) {
        Write.jm(s, String.valueOf(s.getTitle()) + ".jm");
    }

    public static void jm(Score s, String fileName) {
        try {
            System.out.println("--------------------- Writing JM File -----------------------");
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(s);
            oos.flush();
            oos.close();
            System.out.println("JM file '" + fileName + "' written from score '" + s.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void jm(Part p) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Write.jm(s, String.valueOf(p.getTitle()) + ".jm");
    }

    public static void jm(Part p, String fileName) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Write.jm(s, fileName);
    }

    public static void jm(Phrase phr) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Write.jm(s, String.valueOf(phr.getTitle()) + ".jm");
    }

    public static void jm(Phrase phr, String fileName) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Write.jm(s, fileName);
    }

    public static void jm(CPhrase cphr) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.jm(s, String.valueOf(cphr.getTitle()) + ".jm");
    }

    public static void jm(CPhrase cphr, String fileName) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.jm(s, fileName);
    }

    public static void au(Score s, Instrument inst) {
        Instrument[] instArray = new Instrument[]{inst};
        Write.au(s, String.valueOf(s.getTitle()) + ".au", instArray);
    }

    public static void au(Score s, Instrument[] instList) {
        Write.au(s, String.valueOf(s.getTitle()) + ".au", instList);
    }

    public static void au(Score s, String fileName, Instrument inst) {
        Instrument[] instArray = new Instrument[]{inst};
        Write.au(s, fileName, instArray);
    }

    public static void au(Score s, String fileName, Instrument[] instList) {
        double time1 = System.currentTimeMillis();
        System.out.println("------------------------------ Writing AU File --------------------------------");
        String jpfFile = String.valueOf(fileName) + ".jpf";
        String tmpFile = "jmusic.tmp";
        File f = new File(tmpFile);
        if (f.exists()) {
            f.delete();
        }
        Audio.processScore(s, instList, jpfFile);
        Audio.combine(jpfFile, tmpFile, fileName, true, true);
        double time2 = System.currentTimeMillis();
        System.out.println("AU file '" + fileName + "' written from score '" + s.getTitle() + "' in " + (time2 - time1) / 1000.0 + " seconds.");
        System.out.println("-------------------------------------------------------------------------------");
    }

    public static void au(Part p, Instrument[] instList) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Write.au(s, String.valueOf(p.getTitle()) + ".au", instList);
    }

    public static void au(Part p, String fileName, Instrument inst) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Instrument[] instArray = new Instrument[]{inst};
        Write.au(s, fileName, instArray);
    }

    public static void au(Part p, String fileName, Instrument[] instList) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Write.au(s, fileName, instList);
    }

    public static void au(Phrase phr, Instrument[] instList) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Write.au(s, String.valueOf(phr.getTitle()) + ".au", instList);
    }

    public static void au(Phrase phr, String fileName, Instrument[] instList) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Write.au(s, fileName, instList);
    }

    public static void au(Phrase phr, String fileName, Instrument inst) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Instrument[] instArray = new Instrument[]{inst};
        Write.au(s, fileName, instArray);
    }

    public static void au(CPhrase cphr, Instrument[] instList) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.au(s, String.valueOf(cphr.getTitle()) + ".au", instList);
    }

    public static void au(CPhrase cphr, String fileName, Instrument[] instList) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.au(s, fileName, instList);
    }

    public static void audio(float[] sampleData, String fileName) {
        Write.audio(sampleData, fileName, 1, 44100, 16);
    }

    public static void audio(float[] sampleData, String fileName, int channels, int sampleRate, int sampleSizeInBits) {
        double time1 = System.currentTimeMillis();
        System.out.println("---------------------------- Writing Audio File -------------------------------");
        AudioFileOut afo = new AudioFileOut(sampleData, fileName, channels, sampleRate, sampleSizeInBits);
        double time2 = System.currentTimeMillis();
        System.out.println("Audio file '" + fileName + "' written in " + (time2 - time1) / 1000.0 + " seconds.");
        System.out.println("Channels = " + channels + " Sample rate = " + sampleRate + " Bit depth = " + sampleSizeInBits);
        System.out.println("-------------------------------------------------------------------------------");
    }

    public static void xml(Score s) {
        Write.xml(s, String.valueOf(s.getTitle()) + ".xml");
    }

    public static void xml(Score s, String fileName) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(fileName));
            System.out.println("--------------------- Writing XML File -----------------------");
            String xmlString = XMLParser.scoreToXMLString(s);
            pw.print(xmlString);
            pw.close();
            System.out.println("XML file '" + fileName + "' written from score '" + s.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void xml(Part p) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Write.xml(s, String.valueOf(p.getTitle()) + ".xml");
    }

    public static void xml(Part p, String fileName) {
        Score s = new Score("Score of " + p.getTitle());
        s.addPart(p);
        Write.xml(s, fileName);
    }

    public static void xml(Phrase phr) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Write.xml(s, String.valueOf(phr.getTitle()) + ".xml");
    }

    public static void xml(Phrase phr, String fileName) {
        Part p = new Part();
        p.addPhrase(phr);
        Score s = new Score("Score of " + phr.getTitle());
        s.addPart(p);
        Write.xml(s, fileName);
    }

    public static void xml(CPhrase cphr) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.xml(s, String.valueOf(cphr.getTitle()) + ".xml");
    }

    public static void xml(CPhrase cphr, String fileName) {
        Part p = new Part();
        p.addCPhrase(cphr);
        Score s = new Score("Score of " + cphr.getTitle());
        s.addPart(p);
        Write.xml(s, fileName);
    }

    private static Score adjustTempo(Score score) {
        Enumeration enumParts = score.getPartList().elements();
        double scrTempo = 60.0 / score.getTempo();
        while (enumParts.hasMoreElements()) {
            Part part = (Part)enumParts.nextElement();
            double partTempo = scrTempo;
            if (part.getTempo() != 0.0) {
                partTempo = 60.0 / part.getTempo();
            }
            Enumeration enumPhrases = part.getPhraseList().elements();
            while (enumPhrases.hasMoreElements()) {
                Phrase phrase = (Phrase)enumPhrases.nextElement();
                Enumeration enumNotes = phrase.getNoteList().elements();
                while (enumNotes.hasMoreElements()) {
                    Note note = (Note)enumNotes.nextElement();
                    note.setRhythmValue(note.getRhythmValue() * partTempo);
                    note.setDuration(note.getDuration() * partTempo);
                }
            }
        }
        return score;
    }
}

