/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import jm.music.data.Score;
import jm.util.ReadListener;

class ReadListenerLinkedList {
    private ReadListener listener;
    private ReadListenerLinkedList next;

    public ReadListenerLinkedList(ReadListener listener) {
        this.listener = listener;
        this.next = null;
    }

    public ReadListenerLinkedList getNext() {
        return this.next;
    }

    public ReadListener getListener() {
        return this.listener;
    }

    public void add(ReadListener l) {
        if (l == null) {
            return;
        }
        if (this.next == null) {
            this.next = new ReadListenerLinkedList(l);
        }
        this.next.add(l);
    }

    public void remove(ReadListener l) {
        if (this.next == null) {
            return;
        }
        if (l == this.next.getListener()) {
            this.next = this.next.getNext();
        }
    }

    public Score scoreRead(Score score) {
        if (this.listener == null) {
            return score;
        }
        if (this.next == null) {
            return this.listener.scoreRead(score);
        }
        return this.next.scoreRead(this.listener.scoreRead(score));
    }

    public void startedReading() {
        if (this.listener == null) {
            return;
        }
        if (this.next == null) {
            this.listener.startedReading();
            return;
        }
        this.listener.startedReading();
        this.next.startedReading();
    }

    public void finishedReading() {
        if (this.listener == null) {
            return;
        }
        if (this.next == null) {
            this.listener.finishedReading();
            return;
        }
        this.listener.finishedReading();
        this.next.finishedReading();
    }
}

