/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.ReadFilenameFilter;
import jm.util.ReadListener;
import jm.util.ReadListenerLinkedList;

public class ReadFilesJButton
extends JButton {
    public static final Mode SINGLE_FILE_MODE = new Mode("Single File");
    public static final Mode MULTIPLE_FILES_MODE = new Mode("Multiple Files");
    public static final Mode FOLDER_MODE = new Mode("Folder");
    private Mode mode;
    private ReadListenerLinkedList readListenerList;
    private JFileChooser chooser = new JFileChooser();
    private Component owner;

    public ReadFilesJButton(Component owner) {
        this(owner, MULTIPLE_FILES_MODE);
    }

    public ReadFilesJButton(final Component owner, final Mode mode) {
        this.owner = owner;
        this.setMode(mode);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Runnable processRun = new Runnable(this, owner, mode){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Component val$owner;
                    private final /* synthetic */ Mode val$mode;
                    {
                        this.this$1 = var1_1;
                        this.val$owner = component;
                        this.val$mode = mode;
                    }

                    public void run() {
                        File file;
                        ReadFilesJButton.access$0(1.access$0(this.this$1)).startedReading();
                        int chooserReturnValue = ReadFilesJButton.access$1(1.access$0(this.this$1)).showOpenDialog(this.val$owner);
                        ReadFilesJButton.access$1(1.access$0(this.this$1));
                        if (chooserReturnValue != 0) {
                            return;
                        }
                        if (this.val$mode == SINGLE_FILE_MODE) {
                            ReadFilesJButton.access$2(1.access$0(this.this$1), ReadFilesJButton.access$1(1.access$0(this.this$1)).getSelectedFile());
                        } else if (this.val$mode == MULTIPLE_FILES_MODE) {
                            ReadFilesJButton.access$3(1.access$0(this.this$1), ReadFilesJButton.access$1(1.access$0(this.this$1)).getSelectedFiles());
                        } else if (this.val$mode == FOLDER_MODE && (file = ReadFilesJButton.access$1(1.access$0(this.this$1)).getSelectedFile()).isDirectory()) {
                            String[] filenames = file.list(new ReadFilenameFilter());
                            int i = 0;
                            while (i < filenames.length) {
                                ReadFilesJButton.access$2(1.access$0(this.this$1), new File(file.getAbsolutePath(), filenames[i]));
                                ++i;
                            }
                        }
                        if (ReadFilesJButton.access$0(1.access$0(this.this$1)) != null) {
                            ReadFilesJButton.access$0(1.access$0(this.this$1)).finishedReading();
                        }
                    }
                };
                Thread processThread = new Thread(processRun, "processThread");
                processThread.start();
            }

            static /* synthetic */ ReadFilesJButton access$0(1 var0) {
                return var0.ReadFilesJButton.this;
            }
        });
    }

    private void processFile(File file) {
        Score score = Read.midiOrJmWithSwingMessaging(file, this.owner);
        if (score == null) {
            return;
        }
        if (this.readListenerList != null) {
            score = this.readListenerList.scoreRead(score);
        }
    }

    private void processFiles(File[] files) {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            this.processFile(files[i]);
            ++i;
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == SINGLE_FILE_MODE) {
            this.setText("Read File");
            this.chooser.setDialogTitle("Select a MIDI or jMusic file to import");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setFileSelectionMode(0);
        } else if (mode == MULTIPLE_FILES_MODE) {
            this.setText("Read Files");
            this.chooser.setDialogTitle("Select MIDI and/or jMusic files to import");
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setFileSelectionMode(0);
        } else if (mode == FOLDER_MODE) {
            this.setText("Read Folder");
            this.chooser.setDialogTitle("Select a folder of MIDI or jMusic files to import");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setFileSelectionMode(1);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addReadListener(ReadListener l) {
        if (l == null) {
            return;
        }
        if (this.readListenerList == null) {
            this.readListenerList = new ReadListenerLinkedList(l);
        } else {
            this.readListenerList.add(l);
        }
    }

    public void removeReadListener(ReadListener l) {
        if (this.readListenerList == null) {
            return;
        }
        if (this.readListenerList.getListener() == l) {
            this.readListenerList = this.readListenerList.getNext();
        }
    }

    static /* synthetic */ ReadListenerLinkedList access$0(ReadFilesJButton readFilesJButton) {
        return readFilesJButton.readListenerList;
    }

    static /* synthetic */ JFileChooser access$1(ReadFilesJButton readFilesJButton) {
        return readFilesJButton.chooser;
    }

    static /* synthetic */ void access$2(ReadFilesJButton readFilesJButton, File file) {
        readFilesJButton.processFile(file);
    }

    static /* synthetic */ void access$3(ReadFilesJButton readFilesJButton, File[] fileArray) {
        readFilesJButton.processFiles(fileArray);
    }

    private static class Mode {
        private final String name;

        Mode(String name) {
            this.name = name;
        }
    }
}

