/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import javax.swing.JOptionPane;
import jm.JMC;
import jm.audio.io.AudioFileIn;
import jm.midi.MidiParser;
import jm.midi.SMF;
import jm.music.data.CPhrase;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.ConversionException;
import jm.util.XMLParser;

public class Read
implements JMC {
    protected Read() {
    }

    public static void midi(Score score) {
        FileDialog fd = new FileDialog(new Frame(), "Select a MIDI file to open.", 0);
        fd.show();
        if (fd.getFile() != null) {
            Read.midi(score, String.valueOf(fd.getDirectory()) + fd.getFile());
        }
    }

    public static void midi(Score s, String fileName) {
        if (s == null) {
            System.err.println("jMusic Read.midi error: The score is not initialised! I'm doing it for you.");
            s = new Score();
        }
        s.empty();
        SMF smf = new SMF();
        smf.setVerbose(true);
        try {
            System.out.println("--------------------- Reading MIDI File ---------------------");
            FileInputStream is = new FileInputStream(fileName);
            smf.read(is);
            MidiParser.SMFToScore(s, smf);
            System.out.println("MIDI file '" + fileName + "' read into score '" + s.getTitle() + "' Tempo = " + s.getTempo());
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void midi(Score s, URL url) {
        if (s == null) {
            System.err.println("jMusic Read.midi error: The score is not initialised! I'm doing it for you.");
            s = new Score();
        }
        SMF smf = new SMF();
        smf.setVerbose(true);
        InputStream is = null;
        try {
            System.out.println("--------------------- Reading MIDI File From URL ---------------------");
            is = url.openStream();
            smf.read(is);
            MidiParser.SMFToScore(s, smf);
            System.out.println("MIDI file '" + url.getFile() + "' read into score '" + s.getTitle() + "' Tempo = " + s.getTempo());
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void midi(Part p) {
        Score s = new Score();
        Read.midi(s);
        p = s.getPart(0);
    }

    public static void midi(Part p, String fileName) {
        Score s = new Score();
        Read.midi(s, fileName);
        p = s.getPart(0);
    }

    public static void midi(Phrase phr) {
        Score s = new Score();
        Read.midi(s);
        phr = s.getPart(0).getPhrase(0);
    }

    public static void midi(Phrase phr, String fileName) {
        Part p = new Part();
        Read.midi(p, fileName);
        phr = p.getPhrase(0);
    }

    public static void midi(CPhrase cphr, String fileName) {
        Score s = new Score();
        Read.midi(s, fileName);
        Part p = new Part();
        p = s.getPart(0);
        int i = 0;
        while (i < p.size()) {
            cphr.addPhrase(p.getPhrase(i));
            ++i;
        }
    }

    public static void jm(Score s) {
        Read.jm(s, String.valueOf(s.getTitle()) + ".jm");
    }

    public static void jm(Score s, String fileName) {
        if (s == null) {
            System.err.println("jMusic Read.jm error: The score is not initialised! I'm doing it for you.");
            s = new Score();
        }
        s.empty();
        try {
            System.out.println("--------------------- Reading .jm File ---------------------");
            FileInputStream is = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(is);
            try {
                s.addPartList(((Score)ois.readObject()).getPartArray());
                System.out.println("reading");
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
            }
            System.out.println("jm file '" + fileName + "' read into score '" + s.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void jm(Part p, String fileName) {
        if (p == null) {
            System.err.println("jMusic Read.jm error: The part is not initialised! I'm doing it for you.");
            p = new Part();
        }
        p.empty();
        Score s = new Score();
        Read.jm(s, fileName);
        p.addPhraseList(s.getPart(0).getPhraseArray());
    }

    public static void jm(Phrase phr, String fileName) {
        if (phr == null) {
            System.err.println("jMusic Read.jm error: The phrase is not initialised! I'm doing it for you.");
            phr = new Phrase();
        }
        phr.empty();
        Part p = new Part();
        Read.jm(p, fileName);
        phr.addNoteList(p.getPhrase(0).getNoteArray());
    }

    public static void jm(CPhrase cphr, String fileName) {
        if (cphr == null) {
            System.err.println("jMusic Read.jm error: The CPhrase is not initialised! I'm doing it for you.");
            cphr = new CPhrase();
        }
        cphr.empty();
        Score s = new Score();
        Read.jm(s, fileName);
        Part p = new Part();
        p = s.getPart(0);
        int i = 0;
        while (i < p.size()) {
            cphr.addPhrase(p.getPhrase(i));
            ++i;
        }
    }

    public static void xml(Score score) {
        FileDialog fd = new FileDialog(new Frame(), "Select a jMusic XML file to open.", 0);
        fd.show();
        if (fd.getFile() != null) {
            Read.xml(score, String.valueOf(fd.getDirectory()) + fd.getFile());
        }
    }

    public static void xml(Score s, String fileName) {
        if (s == null) {
            System.err.println("jMusic Read.xml error: The score is not initialised! I'm doing it for you.");
            s = new Score();
        }
        s.empty();
        try {
            System.out.println("--------------------- Reading .xml File ---------------------");
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            try {
                s.addPartList(XMLParser.xmlStringToScore(br.readLine()).getPartArray());
                System.out.println("reading");
            }
            catch (ConversionException e) {
                System.err.println(e);
            }
            System.out.println("xml file '" + fileName + "' read into score '" + s.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void xml(Part p, String fileName) {
        if (p == null) {
            System.err.println("jMusic Read.xml error: The part is not initialised! I'm doing it for you.");
            p = new Part();
        }
        p.empty();
        Score s = new Score();
        Read.xml(s, fileName);
        p.addPhraseList(s.getPart(0).getPhraseArray());
    }

    public static void xml(Phrase phr, String fileName) {
        if (phr == null) {
            System.err.println("jMusic Read.xml error: The phrase is not initialised! I'm doing it for you.");
            phr = new Phrase();
        }
        phr.empty();
        Part p = new Part();
        Read.xml(p, fileName);
        phr.addNoteList(p.getPhrase(0).getNoteArray());
    }

    public static void xml(CPhrase cphr, String fileName) {
        if (cphr == null) {
            System.err.println("jMusic Read.xml error: The CPhrase is not initialised! I'm doing it for you.");
            cphr = new CPhrase();
        }
        cphr.empty();
        Score s = new Score();
        Read.xml(s, fileName);
        Part p = new Part();
        p = s.getPart(0);
        int i = 0;
        while (i < p.size()) {
            cphr.addPhrase(p.getPhrase(i));
            ++i;
        }
    }

    public static float[] audio(String fileName) {
        System.out.println("-------------------- Reading Audio File ---------------------");
        AudioFileIn afi = new AudioFileIn(fileName);
        float[] sampleData = afi.getSampleData();
        System.out.println("File '" + fileName + "' read in. Details:");
        System.out.println("Channels = " + afi.getChannels() + " Samples per channel = " + afi.getDuration() / afi.getChannels() + " Sample rate = " + afi.getSampleRate() + " Bit depth = " + afi.getSampleBitDepth());
        System.out.println("-------------------------------------------------------------");
        return sampleData;
    }

    public static void audio(float[] sampleData, String fileName) {
        System.out.println("-------------------- Reading Audio File ---------------------");
        AudioFileIn afi = new AudioFileIn(fileName);
        sampleData = afi.getSampleData();
        System.out.println("Audio file '" + fileName + "' read in. Details:");
        System.out.println("Channels = " + afi.getChannels() + " Samples per channel = " + afi.getDuration() / afi.getChannels() + " Sample rate = " + afi.getSampleRate() + " Bit depth = " + afi.getSampleBitDepth());
        System.out.println("-------------------------------------------------------------");
    }

    public static Score midiOrJmWithNoMessaging(File file) {
        return new JmMidiProcessor(file).getScore();
    }

    public static Score midiOrJmWithNoMessaging(String directory, String filename) {
        return new JmMidiProcessor(directory, filename).getScore();
    }

    public static Score midiOrJmWithAWTMessaging(File file, Frame owner) {
        JmMidiProcessor processor = new JmMidiProcessor(file);
        Read.displayErrorDialog(owner, processor.getMessage());
        return processor.getScore();
    }

    public static Score midiOrJmWithAWTMessaging(String directory, String filename, Frame owner) {
        JmMidiProcessor processor = new JmMidiProcessor(directory, filename);
        Read.displayErrorDialog(owner, processor.getMessage());
        return processor.getScore();
    }

    private static void displayErrorDialog(Frame owner, String message) {
        if (message == null) {
            return;
        }
        Dialog dialog = new Dialog(owner, "Not a valid MIDI or jMusic File", true);
        Read.completeErrorDialog(dialog, message);
    }

    private static void completeErrorDialog(final Dialog dialog, String message) {
        dialog.add((Component)new Label(message), "Center");
        Button okButton = new Button("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        Panel buttonPanel = new Panel();
        buttonPanel.add(okButton);
        dialog.add((Component)buttonPanel, "South");
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.show();
    }

    public static Score midiOrJmWithSwingMessaging(File file, Component owner) {
        JmMidiProcessor processor = new JmMidiProcessor(file);
        Read.displayErrorJDialog(owner, processor.getMessage());
        return processor.getScore();
    }

    public static Score midiOrJmWithSwingMessaging(String directory, String filename, Component owner) {
        JmMidiProcessor processor = new JmMidiProcessor(directory, filename);
        Read.displayErrorJDialog(owner, processor.getMessage());
        return processor.getScore();
    }

    private static void displayErrorJDialog(Component owner, String message) {
        if (message == null) {
            return;
        }
        JOptionPane.showMessageDialog(owner, message, "Not a valid MIDI or jMusic File", 0);
    }

    protected static class JmMidiProcessor {
        private String message = null;
        private Score score = new Score();

        public JmMidiProcessor(File file) {
            if (file == null) {
                this.message = "The selected file is null.  No JM/MIDI information could be imported.";
                this.score = null;
            } else if (file.isDirectory()) {
                this.message = "The selected file is a directory.  No JM/MIDI information could be imported.";
                this.score = null;
            } else {
                JmMidiProcessor processor = new JmMidiProcessor(String.valueOf(file.getParent()) + File.separator, file.getName());
                this.message = processor.getMessage();
                this.score = processor.getScore();
            }
        }

        public JmMidiProcessor(String directory, String filename) {
            if (filename == null) {
                this.message = "The filename String is null.  No JM/MIDI information could be imported.";
                this.score = null;
                return;
            }
            try {
                this.score.setTitle(filename);
                SMF smf = new SMF();
                if (directory == null) {
                    FileInputStream is = new FileInputStream(filename);
                    smf.read(is);
                    MidiParser.SMFToScore(this.score, smf);
                } else {
                    FileInputStream is = new FileInputStream(String.valueOf(directory) + filename);
                    smf.read(is);
                    MidiParser.SMFToScore(this.score, smf);
                }
            }
            catch (IOException e1) {
                this.message = e1.getMessage();
                if (this.message == null) {
                    this.message = "Unknown IO Exception";
                    this.score = null;
                    return;
                }
                if (this.message.equals("Track Started in wrong place!!!!  ABORTING")) {
                    this.message = "The MIDI file corrupted.  Track data started in the wrong place.";
                    this.score = null;
                    return;
                }
                if (this.message.equals("This is NOT a MIDI file !!!")) {
                    try {
                        FileInputStream fis = new FileInputStream(String.valueOf(directory) + filename);
                        ObjectInputStream ois = new ObjectInputStream(fis);
                        this.score = (Score)ois.readObject();
                        ois.close();
                        fis.close();
                    }
                    catch (SecurityException e2) {
                        this.message = "Read access not allowed to " + filename;
                        this.score = null;
                        return;
                    }
                    catch (ClassNotFoundException e2) {
                        this.message = "The file " + filename + " is neither a jm nor a MIDI file";
                        this.score = null;
                        return;
                    }
                    catch (ClassCastException e2) {
                        this.message = "The file " + filename + " is neither a jm nor a MIDI file";
                        this.score = null;
                        return;
                    }
                    catch (StreamCorruptedException e2) {
                        this.message = "The file " + filename + " is neither a jm nor a MIDI file";
                        this.score = null;
                        return;
                    }
                    catch (IOException e2) {
                        this.message = e2.getMessage();
                        if (this.message == null) {
                            this.message = "Unknown Exception.  No musical information could be imported.";
                        }
                        this.score = null;
                        return;
                    }
                }
                this.score = null;
                return;
            }
        }

        public Score getScore() {
            return this.score;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

