/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Vector;
import jm.JMC;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.gui.wave.WaveFileReader;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.music.rt.RTLine;
import jm.music.rt.RTPhrase;
import jm.util.AudioRTLine;
import jm.util.PlayCycle;
import jm.util.PlayThread;
import jm.util.Read;

public class Play
implements JMC {
    private static PlayThread pt;
    private static PlayCycle pc;
    private static boolean cyclePlaying;
    private static boolean midiPlaying;
    private static Thread pauseThread;

    static {
        cyclePlaying = false;
        midiPlaying = false;
    }

    public static void stopCycle() {
        cyclePlaying = false;
        if (pc != null) {
            pc.stopPlayCycle();
        }
    }

    public static boolean cycleIsPlaying() {
        return cyclePlaying;
    }

    public static void waitCycle(Score s) {
        try {
            Thread.sleep((int)(60000.0 / s.getTempo() * s.getEndTime() + 2000.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void midi(String fileName) {
        Score score = new Score();
        Read.midi(score, fileName);
        Play.midi(score);
    }

    public static void midi(Note n) {
        Play.midi(n, true);
    }

    public static void midi(Phrase phr) {
        Play.midi(phr, true);
    }

    public static void midi(Part p) {
        Play.midi(p, true);
    }

    public static void midi(Score s) {
        Play.midi(s, true);
    }

    public static void midi(Note n, boolean exit) {
        Score s = new Score("One note score", 60.0);
        s.addPart(new Part(new Phrase(n)));
        Play.midi(s, exit);
    }

    public static void midi(Phrase phr, boolean exit) {
        double tempo = 60.0;
        if (phr.getTempo() != -1.0) {
            tempo = phr.getTempo();
        }
        Score s = new Score(String.valueOf(phr.getTitle()) + " score", tempo);
        if (phr.getTempo() != -1.0) {
            s.setTempo(phr.getTempo());
        }
        s.addPart(new Part(phr));
        Play.midi(s, exit);
    }

    public static void midi(Part p, boolean exit) {
        double tempo = 60.0;
        if (p.getTempo() != -1.0) {
            tempo = p.getTempo();
        }
        Score s = new Score(String.valueOf(p.getTitle()) + " score", tempo);
        if (p.getTempo() != -1.0) {
            s.setTempo(p.getTempo());
        }
        s.addPart(p);
        Play.midi(s, exit);
    }

    public static void midi(Score s, boolean exit) {
        if (midiPlaying) {
            Play.stopMidi();
        }
        midiPlaying = true;
        Score defensiveCopy = s.copy();
        System.out.print("-- Constructing MIDI file from'" + s.getTitle() + "'...");
        pt = new PlayThread(defensiveCopy);
        new Thread(pt).start();
        System.out.print(" Playing with JavaSound ...");
        Play.midiWait(s, exit);
    }

    private static void midiWait(final Score score, final boolean exit) {
        pauseThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep((int)(score.getEndTime() * 60.0 / score.getTempo() * 1000.0) + 3000);
                }
                catch (Exception e) {
                    System.out.println("jMusic Play error in pause thread");
                }
                System.out.println(" Completed MIDI playback --------");
                if (exit) {
                    System.exit(0);
                }
            }
        });
        pauseThread.start();
    }

    public static void stopMidi() {
        if (pt != null) {
            pt.stopPlayThread();
            midiPlaying = false;
        }
    }

    public static void midiCycle(Note n) {
        Score s = new Score("One note score");
        s.addPart(new Part(new Phrase(n)));
        Play.midiCycle(s);
    }

    public static void midiCycle(Phrase phr) {
        Score s = new Score(String.valueOf(phr.getTitle()) + " score");
        s.addPart(new Part(phr));
        Play.midiCycle(s);
    }

    public static void midiCycle(Part p) {
        Score s = new Score(String.valueOf(p.getTitle()) + " score");
        s.addPart(p);
        Play.midiCycle(s);
    }

    public static void midiCycle(Score s) {
        if (cyclePlaying) {
            Play.stopCycle();
        }
        cyclePlaying = true;
        pc = new PlayCycle(s);
        new Thread(pc).start();
    }

    public static void au(String fileName) {
        Play.au(fileName, true);
    }

    public static void au(String fileName, boolean autoClose) {
        WaveFileReader afr = new WaveFileReader(fileName);
        RTLine[] lineArray = new RTLine[]{new AudioRTLine(fileName)};
        RTMixer mixer = new RTMixer(lineArray);
        mixer.begin();
        System.out.println("---------- Playing '" + fileName + "'... Sample rate = " + afr.getSampleRate() + " Channels = " + afr.getChannels() + " ----------");
        if (autoClose) {
            File audioFile = new File(fileName);
            try {
                int byteSize = afr.getBits() - 1;
                Thread.sleep((int)((double)audioFile.length() / (double)byteSize / (double)afr.getSampleRate() / (double)afr.getChannels() * 1000.0) + 1000);
            }
            catch (InterruptedException e) {
                System.err.println("jMusic play.au error: Thread sleeping interupted");
            }
            System.out.println("-------------------- Completed Audio Playback ----------------------");
            System.exit(0);
        }
    }

    public static void audio(Phrase phrase, Instrument[] insts) {
        Play.audio(new Score(new Part(phrase)), insts);
    }

    public static void audio(Phrase phrase, Instrument inst) {
        Part part = new Part(phrase);
        if (phrase.getTempo() != -1.0) {
            part.setTempo(phrase.getTempo());
        }
        Play.audio(part, new Instrument[]{inst});
    }

    public static void audio(Part part, Instrument[] insts) {
        Score score = new Score(part);
        if (part.getTempo() != -1.0) {
            score.setTempo(part.getTempo());
        }
        Play.audio(score, insts);
    }

    public static void audio(Part part, Instrument inst) {
        Play.audio(new Score(part), new Instrument[]{inst});
    }

    public static void audio(Score score, Instrument inst) {
        Play.audio(score, new Instrument[]{inst});
    }

    public static void audio(Score score, Instrument[] insts) {
        System.out.print("-------- Playing Score as Audio ...");
        int i = 0;
        while (i < insts.length) {
            insts[i].setOutput(1);
            ++i;
        }
        Vector<Phrase> v = new Vector<Phrase>();
        int i2 = 0;
        while (i2 < score.size()) {
            Part p = score.getPart(i2);
            int j = 0;
            while (j < p.size()) {
                Phrase phr = p.getPhrase(j);
                if (phr.getInstrument() == -1) {
                    phr.setInstrument(p.getInstrument());
                }
                if (phr.getTempo() == -1.0) {
                    phr.setTempo(p.getTempo());
                }
                v.addElement(phr);
                ++j;
            }
            ++i2;
        }
        RTLine[] lines = new RTLine[v.size()];
        int i3 = 0;
        while (i3 < v.size()) {
            Phrase phr = (Phrase)v.elementAt(i3);
            lines[i3] = new RTPhrase(phr, insts[phr.getInstrument()]);
            ++i3;
        }
        RTMixer mixer = new RTMixer(lines);
        mixer.begin();
        Play.audioWait(score, mixer);
    }

    private static void audioWait(final Score score, final RTMixer mixer) {
        pauseThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep((int)(score.getEndTime() * 60.0 / score.getTempo() * 1000.0));
                }
                catch (Exception e) {
                    System.out.println("jMusic Play error in pause thread");
                }
                System.out.println(" Completed audio playback --------");
                mixer.pause();
            }
        });
        pauseThread.start();
    }

    public static void audioClip(String fileName) {
        System.out.println("-------- Playing an audio file ----------");
        System.out.println("Loading sound into memory, please wait...");
        File audioFile = new File(fileName);
        try {
            AudioClip sound = Applet.newAudioClip(audioFile.toURL());
            System.out.println("Playing '" + fileName + "' ...");
            sound.play();
        }
        catch (MalformedURLException e) {
            System.err.println("jMusic play.au error: malformed URL or filename");
        }
        try {
            Thread.sleep((int)((double)audioFile.length() / 2.0 / 44100.0 / 2.0 * 1000.0) + 1000);
        }
        catch (InterruptedException e) {
            System.err.println("jMusic play.au error: Thread sleeping interupted");
        }
        System.out.println("-------------------- Completed Playback ----------------------");
        System.exit(0);
    }
}

