/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import jm.midi.MidiParser;
import jm.midi.SMF;
import jm.music.data.Score;

public abstract class AbstractReadButton
extends Button {
    protected Frame owner = null;

    public Score readFile(String directoryName, String fileName) {
        String message;
        Score score;
        block12: {
            if (directoryName == null || fileName == null) {
                return null;
            }
            score = null;
            message = null;
            try {
                SMF smf = new SMF();
                score = new Score(fileName);
                FileInputStream is = new FileInputStream(String.valueOf(directoryName) + fileName);
                smf.read(is);
                MidiParser.SMFToScore(score, smf);
            }
            catch (IOException e1) {
                message = e1.getMessage();
                if (message == null) {
                    message = "Unknown IO Exception";
                }
                if (message.equals("Track Started in wrong place!!!!  ABORTING")) {
                    message = "The MIDI file corrupted.  Track data started in the wrong place.";
                }
                if (!message.equals("This is NOT a MIDI file !!!")) break block12;
                try {
                    FileInputStream fis = new FileInputStream(String.valueOf(directoryName) + fileName);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    score = (Score)ois.readObject();
                    ois.close();
                    fis.close();
                }
                catch (SecurityException e2) {
                    message = "Read access not allowed to " + fileName;
                }
                catch (ClassNotFoundException e2) {
                    message = "The file " + fileName + " is neither a jm or MIDI file";
                }
                catch (ClassCastException e2) {
                    message = "The file " + fileName + " is neither a jm or MIDI file";
                }
                catch (StreamCorruptedException e2) {
                    message = "The file " + fileName + " is neither a jm or MIDI file";
                }
                catch (IOException e2) {
                    message = e2.getMessage();
                    if (message != null) break block12;
                    message = "Unknown Exception";
                }
            }
        }
        if (message != null) {
            String finalMessage = message;
            new Dialog(this.owner, "Not a valid MIDI or jMusic File", true, finalMessage){
                {
                    this.add(new Label(string));
                    this.addWindowListener(new WindowAdapter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void windowClosing(WindowEvent evt) {
                            this.this$1.dispose();
                        }
                    });
                    this.pack();
                }
            }.show();
        }
        return score;
    }
}

