/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.AdaptiveMatrix;

public final class PhraseMatrix
implements JMC {
    private AdaptiveMatrix pitchAM;
    private AdaptiveMatrix rhythmAM;
    private AdaptiveMatrix dynamicAM;
    private int pitchDepth;
    private int rhythmDepth;
    private int dynamicDepth;
    private Note[] notes;
    private final double[] rhythmMap = new double[]{4.0, 3.0, 2.0, 1.0, 0.6666666666666666, 1.5, 0.5, 0.75, 0.3333333333333333, 0.25, 0.125};

    public PhraseMatrix(Phrase phrase, int depth) {
        this(phrase, depth, depth, depth);
    }

    public PhraseMatrix(Phrase phrase, int pDepth, int rDepth, int dDepth) {
        this.pitchDepth = pDepth;
        this.rhythmDepth = rDepth;
        this.dynamicDepth = dDepth;
        this.notes = phrase.getNoteArray();
        this.calcPitch();
        this.calcRhythm();
        this.calcDynamic();
    }

    public void calcPitch() {
        int[] numArray = new int[this.notes.length];
        int i = 0;
        while (i < this.notes.length) {
            numArray[i] = this.notes[i].getPitch();
            ++i;
        }
        this.pitchAM = new AdaptiveMatrix(numArray, this.pitchDepth, 127);
    }

    public void calcRhythm() {
        int[] numArray = new int[this.notes.length];
        int i = 0;
        while (i < this.notes.length) {
            boolean flag = false;
            int j = 0;
            while (j < this.rhythmMap.length) {
                if (this.notes[i].getRhythmValue() == this.rhythmMap[j]) {
                    flag = true;
                    numArray[i] = j;
                    break;
                }
                ++j;
            }
            if (!flag) {
                System.err.print("[WARNING] PhraseMatrix only supports ");
                System.err.println("rhythm values supported in the JMC file");
            }
            ++i;
        }
        this.rhythmAM = new AdaptiveMatrix(numArray, this.rhythmDepth, this.rhythmMap.length);
    }

    public void calcDynamic() {
        int[] numArray = new int[this.notes.length];
        int i = 0;
        while (i < this.notes.length) {
            numArray[i] = this.notes[i].getDynamic();
            ++i;
        }
        this.dynamicAM = new AdaptiveMatrix(numArray, this.dynamicDepth, 127);
    }

    public Phrase generate(boolean p, boolean r, boolean d) {
        return this.generate(p, r, d, this.notes.length);
    }

    public Phrase generate(boolean p, boolean r, boolean d, int numOfNotes) {
        int i;
        int[] pitch = new int[this.pitchDepth];
        int[] rhythm = new int[this.rhythmDepth];
        int[] dynamic = new int[this.dynamicDepth];
        Note[] noteList = new Note[numOfNotes];
        int i2 = 0;
        while (i2 < numOfNotes) {
            noteList[i2] = new Note();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.pitchDepth) {
            pitch[i2] = this.notes[i2].getPitch();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.rhythmDepth) {
            int j = 0;
            while (j < this.rhythmMap.length) {
                if (this.notes[i2].getRhythmValue() == this.rhythmMap[j]) {
                    rhythm[i2] = j;
                    break;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.dynamicDepth) {
            dynamic[i2] = this.notes[i2].getDynamic();
            ++i2;
        }
        int[] retPitch = this.pitchAM.generate(numOfNotes, pitch);
        int[] retDynamic = this.dynamicAM.generate(numOfNotes, dynamic);
        int[] retRhythm = this.rhythmAM.generate(numOfNotes, rhythm);
        if (p) {
            i = 0;
            while (i < numOfNotes) {
                noteList[i].setPitch(retPitch[i]);
                ++i;
            }
        }
        if (r) {
            i = 0;
            while (i < numOfNotes) {
                noteList[i].setRhythmValue(this.rhythmMap[retRhythm[i]]);
                noteList[i].setDuration(this.rhythmMap[retRhythm[i]] * 0.9);
                ++i;
            }
        }
        if (d) {
            i = 0;
            while (i < numOfNotes) {
                noteList[i].setDynamic(retDynamic[i]);
                ++i;
            }
        }
        Phrase phrase = new Phrase();
        phrase.addNoteList(noteList);
        return phrase;
    }
}

