/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.util.Hashtable;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.NoteListException;
import jm.music.tools.QuantisationException;

public final class PhraseAnalysis {
    public static final String[] featureNames = new String[]{"01 - Pitch Variety", "02 - Pitch Range", "03 - Key Centeredness", "04 - Tonal Deviation", "05 - Dissonance", "06 - Overall Pitch Direction", "07 - Melodic Direction Stability", "08 - Pitch Movement By Tonal Step", "09 - Leap Compensation", "10 - Climax Strength", "11 - Climax Position", "12 - Climax Tonality", "13 - Note Density", "14 - Rest Density", "15 - Rhythmic Variety", "16 - Rhythmic Range", "17 - Syncopation", "18 - Repeated Pitch Density", "19 - Repeated Rhythmic Value Density", "20 - Repeated Pitch Patterns Of Three", "21 - Repeated Pitch Patterns Of Four", "22 - Repeated Rhythm Patterns Of Three", "23 - Repeated Rhythm Patterns Of Four"};
    public static final String NOTELIST_EXCEPTION_STRING = "NoteListException";
    public static final String QUANTISATION_EXCEPTION_STRING = "QuantisationException";
    public static final double NOTELIST_EXCEPTION_CONSTANT = -1.0;
    public static final double QUANTISATION_EXCEPTION_CONSTANT = -2.0;
    public static final int FEATURE_COUNT = 23;
    public static final int MAX_PITCH_RANGE = 24;
    public static final double MAX_RHYTHM_RANGE = 16.0;
    public static final int[] MAJOR_SCALE;
    public static final int[] MINOR_SCALE;
    public static final int[] PRIMARY_NOTES;
    public static final int BIG_JUMP_INTERVAL = 8;
    public static final int MAX_DISTINCT_RHYTHMS = 16;
    public static final int INTERVAL_WITH_REST = 255;
    private static final int[] GOOD_INTERVALS;
    private static final int[] BAD_INTERVALS;
    private static final int SEMITONES_PER_OCTAVE = 12;

    static {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        MAJOR_SCALE = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        nArray2[6] = 10;
        MINOR_SCALE = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 7;
        PRIMARY_NOTES = nArray3;
        int[] nArray4 = new int[10];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 5;
        nArray4[6] = 7;
        nArray4[7] = 8;
        nArray4[8] = 9;
        nArray4[9] = 12;
        GOOD_INTERVALS = nArray4;
        BAD_INTERVALS = new int[]{6, 11};
    }

    private PhraseAnalysis() {
    }

    public static String[] getAllStatisticsAsStrings(Phrase phrase, double duration, int tonic, int[] scale) {
        return PhraseAnalysis.getAllStatisticsAsStrings(phrase.getNoteArray(), duration, tonic, scale);
    }

    public static String[] getAllStatisticsAsStrings(Note[] noteArray, double duration, int tonic, int[] scale) {
        String[] statistics = new String[23];
        try {
            statistics[0] = Double.toString(PhraseAnalysis.pitchVariety(noteArray));
        }
        catch (NoteListException e) {
            statistics[0] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[1] = Double.toString(PhraseAnalysis.pitchRangePerSpan(noteArray));
        }
        catch (NoteListException e) {
            statistics[1] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[2] = Double.toString(PhraseAnalysis.keyCenteredness(noteArray, duration, tonic));
        }
        catch (NoteListException e) {
            statistics[2] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException e) {
            statistics[2] = QUANTISATION_EXCEPTION_STRING;
        }
        try {
            statistics[3] = Double.toString(PhraseAnalysis.tonalDeviation(noteArray, duration, tonic, scale));
        }
        catch (NoteListException e) {
            statistics[3] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException e) {
            statistics[3] = QUANTISATION_EXCEPTION_STRING;
        }
        statistics[4] = Double.toString(PhraseAnalysis.dissonance(noteArray));
        statistics[5] = Double.toString(PhraseAnalysis.overallPitchDirection(noteArray));
        try {
            statistics[6] = Double.toString(PhraseAnalysis.melodicDirectionStability(noteArray));
        }
        catch (NoteListException e) {
            statistics[6] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[7] = Double.toString(PhraseAnalysis.movementByStep(noteArray, tonic, scale));
        }
        catch (NoteListException e) {
            statistics[7] = NOTELIST_EXCEPTION_STRING;
        }
        statistics[8] = Double.toString(PhraseAnalysis.leapCompensation(noteArray));
        try {
            statistics[9] = Double.toString(PhraseAnalysis.climaxStrength(noteArray));
        }
        catch (NoteListException e) {
            statistics[9] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[10] = Double.toString(PhraseAnalysis.climaxPosition(noteArray));
        }
        catch (NoteListException e) {
            statistics[10] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[11] = Double.toString(PhraseAnalysis.climaxTonality(noteArray, tonic, scale));
        }
        catch (NoteListException e) {
            statistics[11] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[12] = Double.toString(PhraseAnalysis.noteDensity(noteArray, duration));
        }
        catch (NoteListException e) {
            statistics[12] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException e) {
            statistics[12] = QUANTISATION_EXCEPTION_STRING;
        }
        try {
            statistics[13] = Double.toString(PhraseAnalysis.noteDensity(noteArray, duration));
        }
        catch (NoteListException e) {
            statistics[13] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException e) {
            statistics[13] = QUANTISATION_EXCEPTION_STRING;
        }
        statistics[14] = Double.toString(PhraseAnalysis.rhythmicVariety(noteArray));
        try {
            statistics[15] = Double.toString(PhraseAnalysis.rhythmRangePerSpan(noteArray));
        }
        catch (NoteListException e) {
            statistics[15] = NOTELIST_EXCEPTION_STRING;
        }
        statistics[16] = Double.toString(PhraseAnalysis.syncopation(noteArray));
        try {
            statistics[17] = Double.toString(PhraseAnalysis.repeatedPitchDensity(noteArray));
        }
        catch (NoteListException e) {
            statistics[17] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[18] = Double.toString(PhraseAnalysis.repeatedRhythmicValueDensity(noteArray));
        }
        catch (NoteListException e) {
            statistics[18] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[19] = Double.toString(PhraseAnalysis.repeatedPitchPatterns(noteArray, 3));
        }
        catch (NoteListException e) {
            statistics[19] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[20] = Double.toString(PhraseAnalysis.repeatedPitchPatterns(noteArray, 4));
        }
        catch (NoteListException e) {
            statistics[20] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[21] = Double.toString(PhraseAnalysis.repeatedRhythmPatterns(noteArray, 3));
        }
        catch (NoteListException e) {
            statistics[21] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            statistics[22] = Double.toString(PhraseAnalysis.repeatedRhythmPatterns(noteArray, 4));
        }
        catch (NoteListException e) {
            statistics[22] = NOTELIST_EXCEPTION_STRING;
        }
        return statistics;
    }

    public static double[] getAllStatisticsAsDoubles(Phrase phrase, double duration, int tonic, int[] scale) {
        return PhraseAnalysis.getAllStatisticsAsDoubles(phrase.getNoteArray(), duration, tonic, scale);
    }

    public static double[] getAllStatisticsAsDoubles(Note[] noteArray, double duration, int tonic, int[] scale) {
        double[] statistics = new double[23];
        try {
            statistics[0] = PhraseAnalysis.pitchVariety(noteArray);
        }
        catch (NoteListException e) {
            statistics[0] = -1.0;
        }
        try {
            statistics[1] = PhraseAnalysis.pitchRangePerSpan(noteArray);
        }
        catch (NoteListException e) {
            statistics[1] = -1.0;
        }
        try {
            statistics[2] = PhraseAnalysis.keyCenteredness(noteArray, duration, tonic);
        }
        catch (NoteListException e) {
            statistics[2] = -1.0;
        }
        catch (QuantisationException e) {
            statistics[2] = -2.0;
        }
        try {
            statistics[3] = PhraseAnalysis.tonalDeviation(noteArray, duration, tonic, scale);
        }
        catch (NoteListException e) {
            statistics[3] = -1.0;
        }
        catch (QuantisationException e) {
            statistics[3] = -2.0;
        }
        statistics[4] = PhraseAnalysis.dissonance(noteArray);
        statistics[5] = PhraseAnalysis.overallPitchDirection(noteArray);
        try {
            statistics[6] = PhraseAnalysis.melodicDirectionStability(noteArray);
        }
        catch (NoteListException e) {
            statistics[6] = -1.0;
        }
        try {
            statistics[7] = PhraseAnalysis.movementByStep(noteArray, tonic, scale);
        }
        catch (NoteListException e) {
            statistics[7] = -1.0;
        }
        statistics[8] = PhraseAnalysis.leapCompensation(noteArray);
        try {
            statistics[9] = PhraseAnalysis.climaxStrength(noteArray);
        }
        catch (NoteListException e) {
            statistics[9] = -1.0;
        }
        try {
            statistics[10] = PhraseAnalysis.climaxPosition(noteArray);
        }
        catch (NoteListException e) {
            statistics[10] = -1.0;
        }
        try {
            statistics[11] = PhraseAnalysis.climaxTonality(noteArray, tonic, scale);
        }
        catch (NoteListException e) {
            statistics[11] = -1.0;
        }
        try {
            statistics[12] = PhraseAnalysis.noteDensity(noteArray, duration);
        }
        catch (NoteListException e) {
            statistics[12] = -1.0;
        }
        catch (QuantisationException e) {
            statistics[12] = -2.0;
        }
        try {
            statistics[13] = PhraseAnalysis.noteDensity(noteArray, duration);
        }
        catch (NoteListException e) {
            statistics[13] = -1.0;
        }
        catch (QuantisationException e) {
            statistics[13] = -2.0;
        }
        statistics[14] = PhraseAnalysis.rhythmicVariety(noteArray);
        try {
            statistics[15] = PhraseAnalysis.rhythmRangePerSpan(noteArray);
        }
        catch (NoteListException e) {
            statistics[15] = -1.0;
        }
        statistics[16] = PhraseAnalysis.syncopation(noteArray);
        try {
            statistics[17] = PhraseAnalysis.repeatedPitchDensity(noteArray);
        }
        catch (NoteListException e) {
            statistics[17] = -1.0;
        }
        try {
            statistics[18] = PhraseAnalysis.repeatedRhythmicValueDensity(noteArray);
        }
        catch (NoteListException e) {
            statistics[18] = -1.0;
        }
        try {
            statistics[19] = PhraseAnalysis.repeatedPitchPatterns(noteArray, 3);
        }
        catch (NoteListException e) {
            statistics[19] = -1.0;
        }
        try {
            statistics[20] = PhraseAnalysis.repeatedPitchPatterns(noteArray, 4);
        }
        catch (NoteListException e) {
            statistics[20] = -1.0;
        }
        try {
            statistics[21] = PhraseAnalysis.repeatedRhythmPatterns(noteArray, 3);
        }
        catch (NoteListException e) {
            statistics[21] = -1.0;
        }
        try {
            statistics[22] = PhraseAnalysis.repeatedRhythmPatterns(noteArray, 4);
        }
        catch (NoteListException e) {
            statistics[22] = -1.0;
        }
        return statistics;
    }

    public static Hashtable getAllStatistics(Phrase phrase, double duration, int tonic, int[] scale) {
        return PhraseAnalysis.getAllStatistics(phrase.getNoteArray(), duration, tonic, scale);
    }

    public static Hashtable getAllStatistics(Note[] noteList, double duration, int tonic, int[] scale) {
        String[] statistics = PhraseAnalysis.getAllStatisticsAsStrings(noteList, duration, tonic, scale);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int i = 0;
        while (i < featureNames.length) {
            hashtable.put(featureNames[i], statistics[i]);
            ++i;
        }
        return hashtable;
    }

    public static double noteDensity(Phrase phrase, double duration) throws NoteListException, QuantisationException {
        return PhraseAnalysis.noteDensity(phrase.getNoteArray(), duration);
    }

    public static double noteDensity(Note[] noteArray, double duration) throws NoteListException, QuantisationException {
        int quanta = PhraseAnalysis.quantumCount(noteArray, duration);
        if (quanta != 0) {
            return (double)PhraseAnalysis.noteCount(noteArray) / (double)quanta;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double pitchVariety(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.pitchVariety(phrase.getNoteArray());
    }

    public static double pitchVariety(Note[] noteArray) throws NoteListException {
        int noteCount = PhraseAnalysis.noteCount(noteArray);
        if (noteCount != 0) {
            return (double)PhraseAnalysis.distinctPitchCount(noteArray) / (double)noteCount;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static double rhythmicVariety(Phrase phrase) {
        return PhraseAnalysis.rhythmicVariety(phrase.getNoteArray());
    }

    public static double rhythmicVariety(Note[] noteArray) {
        return (double)PhraseAnalysis.distinctRhythmCount(noteArray) / 16.0;
    }

    public static double climaxStrength(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.climaxStrength(phrase.getNoteArray());
    }

    public static double climaxStrength(Note[] noteArray) throws NoteListException {
        int count = 0;
        int highestPitch = 0;
        int i = 0;
        while (i < noteArray.length) {
            int currentPitch = noteArray[i].getPitch();
            if (currentPitch != Integer.MIN_VALUE) {
                if (currentPitch > highestPitch) {
                    highestPitch = currentPitch;
                    count = 1;
                } else if (currentPitch == highestPitch) {
                    ++count;
                }
            }
            ++i;
        }
        if (count != 0) {
            return 1.0 / (double)count;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static double restDensity(Phrase phrase, double duration) throws NoteListException, QuantisationException {
        return PhraseAnalysis.restDensity(phrase.getNoteArray(), duration);
    }

    public static double restDensity(Note[] noteArray, double duration) throws NoteListException, QuantisationException {
        int quanta = PhraseAnalysis.quantumCount(noteArray, duration);
        if (quanta != 0) {
            return (double)PhraseAnalysis.restQuantumCount(noteArray, duration) / (double)quanta;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double tonalDeviation(Phrase phrase, double duration, int tonic, int[] scale) throws NoteListException, QuantisationException {
        return PhraseAnalysis.tonalDeviation(phrase.getNoteArray(), duration, tonic, scale);
    }

    public static double tonalDeviation(Note[] noteArray, double duration, int tonic, int[] scale) throws NoteListException, QuantisationException {
        int quanta = PhraseAnalysis.quantumCount(noteArray, duration);
        if (quanta != 0) {
            return (double)PhraseAnalysis.nonScaleQuantumCount(noteArray, duration, tonic, scale) / (double)quanta;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double keyCenteredness(Phrase phrase, double duration, int tonic) throws QuantisationException, NoteListException {
        return PhraseAnalysis.keyCenteredness(phrase.getNoteArray(), duration, tonic);
    }

    public static double keyCenteredness(Note[] noteArray, double duration, int tonic) throws QuantisationException, NoteListException {
        int quanta = PhraseAnalysis.quantumCount(noteArray, duration);
        if (quanta > 0) {
            return (double)PhraseAnalysis.primaryQuantumCount(noteArray, duration, tonic) / (double)quanta;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double pitchRangePerSpan(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.pitchRangePerSpan(phrase.getNoteArray());
    }

    public static double pitchRangePerSpan(Note[] noteArray) throws NoteListException {
        double temp = (double)PhraseAnalysis.pitchRange(noteArray) / 24.0;
        return temp < 1.0 ? temp : 1.0;
    }

    public static double rhythmRangePerSpan(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.rhythmRangePerSpan(phrase.getNoteArray());
    }

    public static double rhythmRangePerSpan(Note[] noteArray) throws NoteListException {
        double temp = PhraseAnalysis.rhythmRange(noteArray) / 16.0;
        return temp < 1.0 ? temp : 1.0;
    }

    public static double repeatedPitchDensity(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.repeatedPitchDensity(phrase.getNoteArray());
    }

    public static double repeatedPitchDensity(Note[] noteArray) throws NoteListException {
        int intervalCount = PhraseAnalysis.intervalCount(noteArray);
        if (intervalCount != 0) {
            return (double)PhraseAnalysis.consecutiveIdenticalPitches(noteArray) / (double)intervalCount;
        }
        throw new NoteListException("The melody should contain at least two notes.");
    }

    public static double repeatedRhythmicValueDensity(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.repeatedRhythmicValueDensity(phrase.getNoteArray());
    }

    public static double repeatedRhythmicValueDensity(Note[] noteArray) throws NoteListException {
        int intervalCount = PhraseAnalysis.intervalCount(noteArray);
        if (intervalCount != 0) {
            return (double)PhraseAnalysis.consecutiveIdenticalRhythms(noteArray) / (double)intervalCount;
        }
        throw new NoteListException("The melody should contain at least two notes.");
    }

    public static double melodicDirectionStability(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.melodicDirectionStability(phrase.getNoteArray());
    }

    public static double melodicDirectionStability(Note[] noteArray) throws NoteListException {
        int intervalCount = PhraseAnalysis.intervalCount(noteArray);
        if (intervalCount - 1 != 0) {
            return (double)PhraseAnalysis.sameDirectionIntervalCount(noteArray) / (double)intervalCount;
        }
        throw new NoteListException("The melody should contain at least three notes.");
    }

    public static double overallPitchDirection(Phrase phrase) {
        return PhraseAnalysis.overallPitchDirection(phrase.getNoteArray());
    }

    public static double overallPitchDirection(Note[] noteArray) {
        double intervalSemitoneCount = PhraseAnalysis.intervalSemitoneCount(noteArray);
        if (intervalSemitoneCount != 0.0) {
            return (double)PhraseAnalysis.risingSemitoneCount(noteArray) / intervalSemitoneCount;
        }
        return 0.5;
    }

    public static double movementByStep(Phrase phrase, int tonic, int[] scale) throws NoteListException {
        return PhraseAnalysis.movementByStep(phrase.getNoteArray(), tonic, scale);
    }

    public static double movementByStep(Note[] noteArray, int tonic, int[] scale) throws NoteListException {
        int intervalCount = PhraseAnalysis.intervalCount(noteArray);
        if (intervalCount > 0) {
            return (double)PhraseAnalysis.stepIntervalCount(noteArray, tonic, scale) / (double)intervalCount;
        }
        throw new NoteListException("The melody should contain at least two notes.");
    }

    public static double dissonance(Phrase phrase) {
        return PhraseAnalysis.dissonance(phrase.getNoteArray());
    }

    public static double dissonance(Note[] noteArray) {
        int[] intervals = PhraseAnalysis.pitchIntervals(noteArray);
        int dissonance = 0;
        int i = 0;
        while (i < intervals.length) {
            if (intervals[i] > 127) {
                int n = i;
                intervals[n] = intervals[n] - 255;
            }
            intervals[i] = Math.abs(intervals[i]);
            dissonance = intervals[i] > 12 ? (dissonance += 2) : (dissonance += PhraseAnalysis.rateDissonance(intervals[i]));
            ++i;
        }
        return (double)dissonance / (2.0 * (double)intervals.length);
    }

    public static double leapCompensation(Phrase phrase) {
        return PhraseAnalysis.leapCompensation(phrase.getNoteArray());
    }

    public static double leapCompensation(Note[] noteArray) {
        int bigJumpCount = PhraseAnalysis.bigJumpCount(noteArray);
        if (bigJumpCount != 0) {
            return (double)(bigJumpCount - PhraseAnalysis.bigJumpFollowedByStepBackCount(noteArray)) / (double)bigJumpCount;
        }
        return 0.0;
    }

    public static double syncopation(Phrase phrase) {
        return PhraseAnalysis.syncopation(phrase.getNoteArray());
    }

    public static double syncopation(Note[] noteArray) {
        int count = 0;
        double position = 0.0;
        int i = 0;
        while (i < noteArray.length) {
            double rhythmValue = noteArray[i].getRhythmValue();
            if (rhythmValue >= 1.0 && noteArray[i].getPitch() != Integer.MIN_VALUE && position % 1.0 != 0.0) {
                ++count;
            }
            position += rhythmValue;
            ++i;
        }
        return (double)count / Math.floor(PhraseAnalysis.rhythmValueCount(noteArray) - 1.0);
    }

    public static double repeatedPitchPatterns(Phrase phrase, int chunkSize) throws NoteListException {
        return PhraseAnalysis.repeatedPitchPatterns(phrase.getNoteArray(), chunkSize);
    }

    public static double repeatedPitchPatterns(Note[] noteArray, int chunkSize) throws NoteListException {
        int possiblePatterns = PhraseAnalysis.intervalCount(noteArray) - chunkSize;
        if (possiblePatterns > 0) {
            return (double)PhraseAnalysis.pitchPatternCount(noteArray, chunkSize) / (double)possiblePatterns;
        }
        throw new NoteListException("The melody must contain more intervals than the size of the pattern being searched for.");
    }

    public static double repeatedRhythmPatterns(Phrase phrase, int chunkSize) throws NoteListException {
        return PhraseAnalysis.repeatedRhythmPatterns(phrase.getNoteArray(), chunkSize);
    }

    public static double repeatedRhythmPatterns(Note[] noteArray, int chunkSize) throws NoteListException {
        int possiblePatterns = PhraseAnalysis.intervalCount(noteArray) - chunkSize;
        if (possiblePatterns > 0) {
            return (double)PhraseAnalysis.rhythmPatternCount(noteArray, chunkSize) / (double)possiblePatterns;
        }
        throw new NoteListException("The melody must contain more intervals than the size of the pattern being searched for.");
    }

    public static double climaxPosition(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.climaxPosition(phrase.getNoteArray());
    }

    public static double climaxPosition(Note[] noteArray) throws NoteListException {
        if (PhraseAnalysis.noteCount(noteArray) > 0) {
            double length = 0.0;
            int highestPitch = 0;
            int index = 0;
            int i = 0;
            while (i < noteArray.length) {
                length += noteArray[i].getRhythmValue();
                int currentPitch = noteArray[i].getPitch();
                if (currentPitch != Integer.MIN_VALUE && currentPitch >= highestPitch) {
                    highestPitch = currentPitch;
                    index = i;
                }
                ++i;
            }
            double lengthToClimax = 0.0;
            int i2 = 0;
            while (i2 < index - 1) {
                lengthToClimax += noteArray[i2].getRhythmValue();
                ++i2;
            }
            return lengthToClimax / length;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static double climaxTonality(Phrase phrase, int tonic, int[] scale) throws NoteListException {
        return PhraseAnalysis.climaxTonality(phrase.getNoteArray(), tonic, scale);
    }

    public static double climaxTonality(Note[] noteArray, int tonic, int[] scale) throws NoteListException {
        if (PhraseAnalysis.noteCount(noteArray) > 0) {
            int highestPitch = 0;
            int i = 0;
            while (i < noteArray.length) {
                int currentPitch = noteArray[i].getPitch();
                if (currentPitch != Integer.MIN_VALUE && currentPitch > highestPitch) {
                    highestPitch = currentPitch;
                }
                ++i;
            }
            if (PhraseAnalysis.isElementOf(highestPitch = PhraseAnalysis.pitchToDegree(highestPitch, tonic), PRIMARY_NOTES)) {
                return 0.0;
            }
            if (PhraseAnalysis.isElementOf(highestPitch, scale)) {
                return 0.5;
            }
            return 1.0;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static int noteCount(Phrase phrase) {
        return PhraseAnalysis.noteCount(phrase.getNoteArray());
    }

    public static int noteCount(Note[] noteArray) {
        int count = 0;
        int i = 0;
        while (i < noteArray.length) {
            if (noteArray[i].getPitch() != Integer.MIN_VALUE) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int quantumCount(Phrase phrase, double duration) throws QuantisationException {
        return PhraseAnalysis.quantumCount(phrase.getNoteArray(), duration);
    }

    public static int quantumCount(Note[] noteArray, double duration) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, duration)) {
            int count = 0;
            int i = 0;
            while (i < noteArray.length) {
                count += (int)(noteArray[i].getRhythmValue() / duration);
                ++i;
            }
            return count;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int distinctPitchCount(Phrase phrase) {
        return PhraseAnalysis.distinctPitchCount(phrase.getNoteArray());
    }

    public static int distinctPitchCount(Note[] noteArray) {
        int[] pitchArray = new int[noteArray.length];
        int index = 0;
        int i = 0;
        while (i < noteArray.length) {
            int pitch = noteArray[i].getPitch();
            if (pitch != Integer.MIN_VALUE && !PhraseAnalysis.isElementOf(pitch, pitchArray, index)) {
                pitchArray[index] = pitch;
                ++index;
            }
            ++i;
        }
        return index;
    }

    public static int distinctRhythmCount(Phrase phrase) {
        return PhraseAnalysis.distinctRhythmCount(phrase.getNoteArray());
    }

    public static int distinctRhythmCount(Note[] noteArray) {
        double[] rhythmArray = new double[noteArray.length];
        int index = 0;
        int i = 0;
        while (i < noteArray.length) {
            double rhythm;
            if (noteArray[i].getPitch() <= Integer.MIN_VALUE && !PhraseAnalysis.isElementOf(rhythm = noteArray[i].getRhythmValue(), rhythmArray, index)) {
                rhythmArray[index] = rhythm;
                ++index;
            }
            ++i;
        }
        return index;
    }

    public static int restQuantumCount(Phrase phrase, double duration) throws QuantisationException {
        return PhraseAnalysis.restQuantumCount(phrase.getNoteArray(), duration);
    }

    public static int restQuantumCount(Note[] noteArray, double duration) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, duration)) {
            int count = 0;
            int i = 0;
            while (i < noteArray.length) {
                if (noteArray[i].getPitch() == Integer.MIN_VALUE) {
                    count += (int)(noteArray[i].getRhythmValue() / duration);
                }
                ++i;
            }
            return count;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int nonScaleQuantumCount(Phrase phrase, double duration, int tonic, int[] scale) throws QuantisationException {
        return PhraseAnalysis.nonScaleQuantumCount(phrase.getNoteArray(), duration, tonic, scale);
    }

    public static int nonScaleQuantumCount(Note[] noteArray, double duration, int tonic, int[] scale) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, duration)) {
            int count = 0;
            int i = 0;
            while (i < noteArray.length) {
                int pitch = noteArray[i].getPitch();
                if (pitch != Integer.MIN_VALUE && !PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(pitch, tonic), scale)) {
                    count += (int)(noteArray[i].getRhythmValue() / duration);
                }
                ++i;
            }
            return count;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int primaryQuantumCount(Phrase phrase, double duration, int tonic) throws QuantisationException {
        return PhraseAnalysis.primaryQuantumCount(phrase.getNoteArray(), duration, tonic);
    }

    public static int primaryQuantumCount(Note[] noteArray, double duration, int tonic) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, duration)) {
            int count = 0;
            int i = 0;
            while (i < noteArray.length) {
                int pitch = noteArray[i].getPitch();
                if (pitch == Integer.MIN_VALUE || PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(pitch, tonic), PRIMARY_NOTES)) {
                    count += (int)(noteArray[i].getRhythmValue() / duration);
                }
                ++i;
            }
            return count;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int pitchRange(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.pitchRange(phrase.getNoteArray());
    }

    public static int pitchRange(Note[] noteArray) throws NoteListException {
        int highestPitch = 0;
        int lowestPitch = 127;
        int i = 0;
        while (i < noteArray.length) {
            int currentPitch = noteArray[i].getPitch();
            if (currentPitch != Integer.MIN_VALUE) {
                if (currentPitch > highestPitch) {
                    highestPitch = currentPitch;
                } else if (currentPitch < lowestPitch) {
                    lowestPitch = currentPitch;
                }
            }
            ++i;
        }
        if (highestPitch != 0 && lowestPitch != 127) {
            return highestPitch - lowestPitch;
        }
        throw new NoteListException("There are no notes in the melody.");
    }

    public static double rhythmRange(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.rhythmRange(phrase.getNoteArray());
    }

    public static double rhythmRange(Note[] noteArray) throws NoteListException {
        double longestRhythm = 0.0;
        double shortestRhythm = Double.MAX_VALUE;
        int i = 0;
        while (i < noteArray.length) {
            double currentRhythm = noteArray[i].getRhythmValue();
            if (noteArray[i].getPitch() != Integer.MIN_VALUE) {
                if (currentRhythm > longestRhythm) {
                    longestRhythm = currentRhythm;
                } else if (currentRhythm < shortestRhythm) {
                    shortestRhythm = currentRhythm;
                }
            }
            ++i;
        }
        if (longestRhythm != 0.0 && shortestRhythm != Double.MAX_VALUE) {
            return longestRhythm / shortestRhythm;
        }
        throw new NoteListException("There are no notes in the melody.");
    }

    public static int consecutiveIdenticalPitches(Phrase phrase) {
        return PhraseAnalysis.consecutiveIdenticalPitches(phrase.getNoteArray());
    }

    public static int consecutiveIdenticalPitches(Note[] noteArray) {
        int[] intervals = PhraseAnalysis.pitchIntervals(noteArray);
        int count = 0;
        int i = 0;
        while (i < intervals.length) {
            if (intervals[i] == 0 || intervals[i] == 255) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int consecutiveIdenticalRhythms(Phrase phrase) {
        return PhraseAnalysis.consecutiveIdenticalRhythms(phrase.getNoteArray());
    }

    public static int consecutiveIdenticalRhythms(Note[] noteArray) {
        double[] intervals = PhraseAnalysis.rhythmIntervals(noteArray);
        int count = 0;
        int i = 0;
        while (i < intervals.length - 1) {
            if (intervals[i] == 1.0 && intervals[i + 1] > 0.0 || intervals[i] == -1.0 && intervals[i + 1] < 0.0) {
                ++count;
            }
            ++i;
        }
        if (intervals[intervals.length - 1] == 1.0) {
            ++count;
        }
        return count;
    }

    public static int sameDirectionIntervalCount(Phrase phrase) {
        return PhraseAnalysis.sameDirectionIntervalCount(phrase.getNoteArray());
    }

    public static int sameDirectionIntervalCount(Note[] noteArray) {
        int count = 0;
        int[] intervalArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (intervalArray.length > 0) {
            if (intervalArray[0] > 127) {
                intervalArray[0] = intervalArray[0] - 255;
            }
            int i = 1;
            while (i < intervalArray.length) {
                if (intervalArray[i] > 127) {
                    int n = i;
                    intervalArray[n] = intervalArray[n] - 255;
                }
                if (intervalArray[i] > 0 && intervalArray[i - 1] > 0 || intervalArray[i] == 0 && intervalArray[i - 1] == 0 || intervalArray[i] < 0 && intervalArray[i - 1] < 0) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    public static int intervalCount(Phrase phrase) {
        return PhraseAnalysis.intervalCount(phrase.getNoteArray());
    }

    public static int intervalCount(Note[] noteArray) {
        int intervalCount = PhraseAnalysis.noteCount(noteArray) - 1;
        return intervalCount < 1 ? 0 : intervalCount;
    }

    public static int[] pitchIntervals(Phrase phrase) {
        return PhraseAnalysis.pitchIntervals(phrase.getNoteArray());
    }

    public static int[] pitchIntervals(Note[] noteArray) {
        int intervalCount = PhraseAnalysis.intervalCount(noteArray);
        if (intervalCount > 0) {
            int[] intervalArray = new int[intervalCount];
            int index = -1;
            while (noteArray[++index].getPitch() == Integer.MIN_VALUE) {
            }
            int previousPitch = noteArray[index].getPitch();
            int i = 0;
            while (i < intervalArray.length) {
                int currentPitch = noteArray[++index].getPitch();
                while (currentPitch == Integer.MIN_VALUE) {
                    if (noteArray[index - 1].getPitch() != Integer.MIN_VALUE) {
                        int n = i;
                        intervalArray[n] = intervalArray[n] + 255;
                    }
                    currentPitch = noteArray[++index].getPitch();
                }
                int n = i++;
                intervalArray[n] = intervalArray[n] + (currentPitch - previousPitch);
                previousPitch = currentPitch;
            }
            return intervalArray;
        }
        return new int[0];
    }

    public static double[] rhythmIntervals(Phrase phrase) {
        return PhraseAnalysis.rhythmIntervals(phrase.getNoteArray());
    }

    public static double[] rhythmIntervals(Note[] noteArray) {
        int intervalCount = noteArray.length - 1;
        int i = noteArray.length - 1;
        while (noteArray[i].getPitch() == Integer.MIN_VALUE && i > -1) {
            --intervalCount;
            --i;
        }
        if (intervalCount > 0) {
            double[] intervalArray = new double[intervalCount];
            int i2 = 0;
            while (i2 < intervalArray.length) {
                intervalArray[i2] = noteArray[i2 + 1].getRhythmValue() / noteArray[i2].getRhythmValue();
                if (noteArray[i2].getPitch() == Integer.MIN_VALUE) {
                    int n = i2;
                    intervalArray[n] = intervalArray[n] * -1.0;
                }
                ++i2;
            }
            return intervalArray;
        }
        return new double[0];
    }

    public static int intervalSemitoneCount(Phrase phrase) {
        return PhraseAnalysis.intervalSemitoneCount(phrase.getNoteArray());
    }

    public static int intervalSemitoneCount(Note[] noteArray) {
        int count = 0;
        int[] intervalArray = PhraseAnalysis.pitchIntervals(noteArray);
        int i = 0;
        while (i < intervalArray.length) {
            count += Math.abs(PhraseAnalysis.removeRestMarker(intervalArray[i]));
            ++i;
        }
        return count;
    }

    public static int risingSemitoneCount(Phrase phrase) {
        return PhraseAnalysis.risingSemitoneCount(phrase.getNoteArray());
    }

    public static int risingSemitoneCount(Note[] noteArray) {
        int count = 0;
        int[] intervalArray = PhraseAnalysis.pitchIntervals(noteArray);
        int i = 0;
        while (i < intervalArray.length) {
            intervalArray[i] = PhraseAnalysis.removeRestMarker(intervalArray[i]);
            if (intervalArray[i] > 0) {
                count += intervalArray[i];
            }
            ++i;
        }
        return count;
    }

    public static int stepIntervalCount(Phrase phrase, int tonic, int[] scale) {
        return PhraseAnalysis.stepIntervalCount(phrase.getNoteArray(), tonic, scale);
    }

    public static int stepIntervalCount(Note[] noteArray, int tonic, int[] scale) {
        int intervalCount = PhraseAnalysis.intervalCount(noteArray);
        if (intervalCount > 0) {
            int index = -1;
            int count = 0;
            while (noteArray[++index].getPitch() == Integer.MIN_VALUE) {
            }
            int previousPitch = noteArray[index].getPitch();
            int i = 0;
            while (i < intervalCount) {
                while (noteArray[++index].getPitch() == Integer.MIN_VALUE) {
                }
                int currentPitch = noteArray[index].getPitch();
                if (Math.abs(currentPitch - previousPitch) < 3 && PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(currentPitch, tonic), scale) && PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(previousPitch, tonic), scale)) {
                    ++count;
                }
                previousPitch = currentPitch;
                ++i;
            }
            return count;
        }
        return 0;
    }

    public static int bigJumpFollowedByStepBackCount(Phrase phrase) {
        return PhraseAnalysis.bigJumpFollowedByStepBackCount(phrase.getNoteArray());
    }

    public static int bigJumpFollowedByStepBackCount(Note[] noteArray) {
        int count = 0;
        int[] intervalArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (intervalArray.length > 0) {
            intervalArray[0] = PhraseAnalysis.removeRestMarker(intervalArray[0]);
            int i = 1;
            while (i < intervalArray.length - 1) {
                intervalArray[i] = PhraseAnalysis.removeRestMarker(intervalArray[i]);
                if (intervalArray[i - 1] >= 8 && intervalArray[i] < 0 && intervalArray[i] >= -8 || intervalArray[i - 1] <= -8 && intervalArray[i] > 0 && intervalArray[i] <= 8) {
                    ++count;
                }
                ++i;
            }
            return count;
        }
        return 0;
    }

    public static int bigJumpCount(Phrase phrase) {
        return PhraseAnalysis.bigJumpCount(phrase.getNoteArray());
    }

    public static int bigJumpCount(Note[] noteArray) {
        int count = 0;
        int[] intervalArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (intervalArray.length > 0) {
            int i = 0;
            while (i < intervalArray.length - 1) {
                intervalArray[i] = PhraseAnalysis.removeRestMarker(intervalArray[i]);
                if (Math.abs(intervalArray[i]) >= 8) {
                    ++count;
                }
                ++i;
            }
            return count;
        }
        return count;
    }

    public static int pitchPatternCount(Phrase phrase, int chunkSize) {
        return PhraseAnalysis.pitchPatternCount(phrase.getNoteArray(), chunkSize);
    }

    public static int pitchPatternCount(Note[] noteArray, int chunkSize) {
        int count = 0;
        int[] intervalArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (intervalArray.length > chunkSize) {
            int[][] patterns = new int[intervalArray.length - chunkSize][chunkSize];
            int index = 0;
            int i = 0;
            while (i < intervalArray.length - chunkSize) {
                int[] match = new int[chunkSize];
                int j = 0;
                while (j < chunkSize) {
                    match[j] = intervalArray[i + j];
                    ++j;
                }
                if (!PhraseAnalysis.isAlreadyMatched(patterns, match, index)) {
                    j = i + 1;
                    while (j < intervalArray.length - chunkSize + 1) {
                        if (PhraseAnalysis.matchPattern(intervalArray, i, j, chunkSize)) {
                            if (index == 0 || patterns[index - 1] != match) {
                                patterns[index++] = match;
                            }
                            ++count;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return count;
    }

    public static int rhythmPatternCount(Phrase phrase, int chunksize) {
        return PhraseAnalysis.rhythmPatternCount(phrase.getNoteArray(), chunksize);
    }

    public static int rhythmPatternCount(Note[] noteArray, int chunkSize) {
        int count = 0;
        double[] intervalArray = PhraseAnalysis.rhythmIntervals(noteArray);
        if (intervalArray.length > chunkSize) {
            double[][] patterns = new double[intervalArray.length - chunkSize][chunkSize];
            int index = 0;
            int i = 0;
            while (i < intervalArray.length - chunkSize) {
                double[] match = new double[chunkSize];
                int j = 0;
                while (j < chunkSize) {
                    match[j] = intervalArray[i + j];
                    ++j;
                }
                if (!PhraseAnalysis.isAlreadyMatched(patterns, match, index)) {
                    j = i + 1;
                    while (j < intervalArray.length - chunkSize + 1) {
                        if (PhraseAnalysis.matchPattern(intervalArray, i, j, chunkSize)) {
                            if (index == 0 || patterns[index - 1] != match) {
                                patterns[index++] = match;
                            }
                            ++count;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return count;
    }

    public static double rhythmValueCount(Phrase phrase) {
        return PhraseAnalysis.rhythmValueCount(phrase.getNoteArray());
    }

    public static double rhythmValueCount(Note[] noteArray) {
        double count = 0.0;
        int i = 0;
        while (i < noteArray.length) {
            count += noteArray[i].getRhythmValue();
            ++i;
        }
        return count;
    }

    public static int removeRestMarker(int interval) {
        return interval > 127 ? interval - 255 : interval;
    }

    public static boolean isQuantised(Phrase phrase, double duration) throws QuantisationException {
        return PhraseAnalysis.isQuantised(phrase.getNoteArray(), duration);
    }

    public static boolean isQuantised(Note[] noteArray, double duration) throws QuantisationException {
        if (duration > 0.0) {
            int i = 0;
            while (i < noteArray.length) {
                if (noteArray[i].getRhythmValue() % duration != 0.0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        throw new QuantisationException("The quantum duration must be greater than zero.");
    }

    private static boolean matchPattern(int[] array, int firstIndex, int secondIndex, int n) {
        boolean flag = true;
        int i = 0;
        while (i < n) {
            if (array[firstIndex + i] != array[secondIndex + i]) {
                flag = false;
            }
            ++i;
        }
        return flag;
    }

    private static boolean matchPattern(double[] array, int firstIndex, int secondIndex, int n) {
        boolean flag = true;
        int i = 0;
        while (i < n) {
            if (array[firstIndex + i] != array[secondIndex + i]) {
                flag = false;
            }
            ++i;
        }
        return flag;
    }

    private static boolean isAlreadyMatched(int[][] patterns, int[] match, int n) {
        int i = 0;
        while (i < n) {
            block3: {
                int j = 0;
                while (j < match.length) {
                    if (patterns[i][j] == match[j]) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isAlreadyMatched(double[][] patterns, double[] match, int n) {
        int i = 0;
        while (i < n) {
            block3: {
                int j = 0;
                while (j < match.length) {
                    if (patterns[i][j] == match[j]) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int rateDissonance(int i) {
        int j = 0;
        while (j < GOOD_INTERVALS.length) {
            if (i == GOOD_INTERVALS[j]) {
                return 0;
            }
            ++j;
        }
        j = 0;
        while (j < BAD_INTERVALS.length) {
            if (i == BAD_INTERVALS[j]) {
                return 2;
            }
            ++j;
        }
        return 1;
    }

    private static boolean isElementOf(int element, int[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isElementOf(int element, int[] array, int n) {
        int i = 0;
        while (i < n) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isElementOf(double element, double[] array, int n) {
        int i = 0;
        while (i < n) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int pitchToDegree(int pitch, int tonic) {
        if ((pitch -= tonic) < 0) {
            pitch += (-pitch / 12 + 1) * 12;
        }
        return pitch % 12;
    }

    public static boolean isScale(Note note, int tonic, int[] scale) {
        int pitch = note.getPitch();
        if (pitch == Integer.MIN_VALUE) {
            return true;
        }
        return PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(pitch, tonic), scale, scale.length);
    }
}

