/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.constants.Scales;
import jm.music.data.CPhrase;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class Mod
implements JMC {
    private Mod() {
    }

    public static void append(Note note1, Note note2) {
        try {
            if (note1 == null || note2 == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        note1.setRhythmValue(note1.getRhythmValue() + note2.getRhythmValue());
        note1.setDuration(note1.getDuration() + note2.getDuration());
    }

    public static void transpose(Note note, int transposition) {
        try {
            if (note == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (!note.getPitchType() && note.getPitch() != Integer.MIN_VALUE) {
            note.setPitch(note.getPitch() + transposition);
        }
        if (note.getPitchType()) {
            System.err.println("jMusic Mod transpose: No action taken - notes with frequency values cannot yet be transposed.");
        }
    }

    public static void transpose(Note note, int transposition, int[] mode, int key) {
        int pitch;
        try {
            if (note == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if ((pitch = note.getPitch()) != Integer.MIN_VALUE) {
            int octave = pitch / 12;
            int accidental = 0;
            Note n = note.copy();
            while (!n.isScale(mode)) {
                n.setPitch(n.getPitch() - 1);
                ++accidental;
            }
            int degree = 0;
            int i = 0;
            while (i < mode.length) {
                if (pitch % 12 - accidental == mode[i]) {
                    degree = i;
                    i = mode.length;
                }
                ++i;
            }
            int newDegree = degree + transposition;
            while (newDegree >= mode.length) {
                ++octave;
                newDegree -= mode.length;
            }
            while (newDegree < 0) {
                --octave;
                newDegree += mode.length;
            }
            note.setPitch(mode[newDegree] + octave * 12 + accidental);
        }
    }

    public static final void crescendo(Phrase phrase, double startTime, double endTime, int startDynamic, int endDynamic) {
        double dynDiff = endDynamic - startDynamic;
        double timeDiff = endTime - startTime;
        if (timeDiff == 0.0) {
            return;
        }
        double time = 0.0;
        Vector v = phrase.getNoteList();
        int i = 0;
        while (i < v.size()) {
            Note n = (Note)v.elementAt(i);
            if (time >= startTime) {
                n.setDynamic((int)((time - startTime) / timeDiff * dynDiff + (double)startDynamic));
            }
            if ((time += n.getRhythmValue()) > endTime) break;
            ++i;
        }
    }

    public static final void diminuendo(Phrase phrase, double startTime, double endTime, int startDynamic, int endDynamic) {
        Mod.crescendo(phrase, startTime, endTime, startDynamic, endDynamic);
    }

    public static final void decrescendo(Phrase phrase, double startTime, double endTime, int startDynamic, int endDynamic) {
        Mod.crescendo(phrase, startTime, endTime, startDynamic, endDynamic);
    }

    public static void transpose(Phrase phrase, int transposition) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        Vector noteList = phrase.getNoteList();
        Enumeration enume = noteList.elements();
        while (enume.hasMoreElements()) {
            Note note = (Note)enume.nextElement();
            if (note.getPitch() == Integer.MIN_VALUE) continue;
            note.setPitch(note.getPitch() + transposition);
        }
        phrase.setNoteList(noteList);
    }

    public static void transpose(Phrase phrase, int transposition, int[] mode, int key) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        int rootNote = key % 12;
        Vector noteList = phrase.getNoteList();
        Enumeration enume = noteList.elements();
        while (enume.hasMoreElements()) {
            Note note = (Note)enume.nextElement();
            Mod.transpose(note, transposition, mode, key);
        }
        phrase.setNoteList(noteList);
    }

    public static void repeat(Phrase phrase) {
        Mod.repeat(phrase, 2);
    }

    public static void repeat(Phrase phrase, int n) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        int initialLength = phrase.size();
        int t = 0;
        while (t < n - 1) {
            int i = 0;
            while (i < initialLength) {
                phrase.addNote(phrase.getNote(i).copy());
                ++i;
            }
            ++t;
        }
    }

    public static void repeat(Phrase phrase, double startLoc, double endLoc) {
        Mod.repeat(phrase, 2, startLoc, endLoc);
    }

    public static void repeat(Phrase phrase, int times, double startLoc, double endLoc) {
        if (phrase == null) {
            System.err.println("phrase is null");
            return;
        }
        if (startLoc >= endLoc) {
            System.err.println("startlocation is bigger or equal to end location");
            return;
        }
        if (times < 2) {
            System.err.println("times is smaller than 2");
            return;
        }
        if (startLoc < 0.0) {
            System.err.println("startLoc is smaller than 0");
            return;
        }
        Phrase repeatedBit = phrase.copy(startLoc, endLoc);
        Phrase tempPhr = new Phrase();
        boolean overlappingFirst = false;
        int overlappingNoteAt = 0;
        boolean overlappingLast = false;
        double beatCounter = phrase.getStartTime() < 0.0 ? 0.0 : phrase.getStartTime();
        int beforeCount = 0;
        while (beforeCount < phrase.size() && beatCounter + phrase.getNote(beforeCount).getRhythmValue() <= endLoc) {
            tempPhr.addNote(phrase.getNote(beforeCount));
            if (beatCounter < startLoc && beatCounter + phrase.getNote(beforeCount).getRhythmValue() > startLoc) {
                overlappingFirst = true;
                overlappingNoteAt = beforeCount;
            }
            beatCounter += phrase.getNote(beforeCount).getRhythmValue();
            ++beforeCount;
        }
        if (beforeCount + 1 < phrase.size() && beatCounter < endLoc && beatCounter + phrase.getNote(beforeCount + 1).getRhythmValue() > endLoc) {
            overlappingLast = true;
            Note partialNote = phrase.getNote(beforeCount).copy();
            partialNote.setDuration(partialNote.getDuration() * endLoc - beatCounter / partialNote.getRhythmValue());
            partialNote.setRhythmValue(endLoc - beatCounter);
            tempPhr.addNote(partialNote);
        }
        boolean endLoopFlag = false;
        int r = 0;
        while (r < times - 1) {
            int j = 0;
            while (j < repeatedBit.size()) {
                if (!endLoopFlag) {
                    tempPhr.addNote(repeatedBit.getNote(j));
                }
                ++j;
            }
            ++r;
        }
        if (overlappingLast) {
            tempPhr.removeLastNote();
        }
        int i = beforeCount;
        while (i < phrase.size()) {
            tempPhr.addNote(phrase.getNote(i));
            ++i;
        }
        phrase.setNoteList(tempPhr.getNoteList());
    }

    public static void increaseDynamic(Phrase phr, int amount) {
        try {
            if (phr == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.toString();
            return;
        }
        Enumeration enume = phr.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            n.setDynamic(n.getDynamic() + amount);
        }
    }

    public static void fadeIn(Phrase phrase, double fadeLength) {
        if (phrase == null || fadeLength <= 0.0) {
            return;
        }
        double rhythmValueCounter = 0.0;
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            if (rhythmValueCounter > fadeLength) break;
            Note nextNote = (Note)enume.nextElement();
            double fadeFactor = rhythmValueCounter / fadeLength;
            int dynamic = (int)((double)nextNote.getDynamic() * fadeFactor);
            if (dynamic == 0) {
                dynamic = 1;
            }
            nextNote.setDynamic(dynamic);
            rhythmValueCounter += nextNote.getRhythmValue();
        }
    }

    public static void fadeIn(Phrase phrase, double fadeLength, double phraseStartTime) {
        if (phrase == null || fadeLength <= 0.0 || phraseStartTime < 0.0) {
            return;
        }
        double rhythmValueCounter = phraseStartTime;
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            if (rhythmValueCounter >= fadeLength) break;
            Note nextNote = (Note)enume.nextElement();
            double fadeFactor = rhythmValueCounter / fadeLength;
            int dynamic = (int)((double)nextNote.getDynamic() * fadeFactor);
            if (dynamic == 0) {
                dynamic = 1;
            }
            nextNote.setDynamic(dynamic);
            rhythmValueCounter += nextNote.getRhythmValue();
        }
    }

    public static void fadeOut(Phrase phrase, double fadeLength) {
        if (phrase == null || fadeLength <= 0.0) {
            return;
        }
        double rhythmValueCounter = 0.0;
        int phraseLength = phrase.size() - 1;
        int i = 0;
        while (i <= phraseLength) {
            Note nextNote = (Note)phrase.getNoteList().elementAt(phraseLength - i);
            if (rhythmValueCounter > fadeLength) break;
            double fadeFactor = rhythmValueCounter / fadeLength;
            int dynamic = (int)((double)nextNote.getDynamic() * fadeFactor);
            if (dynamic == 0) {
                dynamic = 1;
            }
            nextNote.setDynamic(dynamic);
            rhythmValueCounter += nextNote.getRhythmValue();
            ++i;
        }
    }

    public static void fadeOut(Phrase phrase, double fadeLength, double phraseEndTime) {
        if (phrase == null || fadeLength <= 0.0 || phraseEndTime < 0.0) {
            return;
        }
        double rhythmValueCounter = phraseEndTime;
        int phraseLength = phrase.size() - 1;
        int i = 0;
        while (i <= phraseLength) {
            Note nextNote = (Note)phrase.getNoteList().elementAt(phraseLength - i);
            if (rhythmValueCounter >= fadeLength) break;
            double fadeFactor = rhythmValueCounter / fadeLength;
            int dynamic = (int)((double)nextNote.getDynamic() * fadeFactor);
            if (dynamic == 0) {
                dynamic = 1;
            }
            nextNote.setDynamic(dynamic);
            rhythmValueCounter += nextNote.getRhythmValue();
            ++i;
        }
    }

    public static void compress(Phrase phrase, double ratio) {
        int curr;
        Note note;
        if (phrase == null) {
            return;
        }
        Enumeration enume = phrase.getNoteList().elements();
        int max = 0;
        int min = 127;
        while (enume.hasMoreElements()) {
            note = (Note)enume.nextElement();
            if (note.getPitch() == Integer.MIN_VALUE) continue;
            curr = note.getDynamic();
            if (curr > max) {
                max = curr;
            }
            if (curr >= min) continue;
            min = curr;
        }
        int mean = (min + max) / 2;
        enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            note = (Note)enume.nextElement();
            curr = (int)((double)mean + (double)(note.getDynamic() - mean) * ratio);
            note.setDynamic(curr);
        }
    }

    public static void append(Phrase phrase1, Phrase phrase2) {
        if (phrase1 == null || phrase2 == null) {
            return;
        }
        Enumeration enume = phrase2.getNoteList().elements();
        while (enume.hasMoreElements()) {
            phrase1.addNote(((Note)enume.nextElement()).copy());
        }
    }

    public static void quantize(Phrase phrase, double qValue) {
        Mod.quantise(phrase, qValue);
    }

    public static void quantise(Phrase phrase, double qValue) {
        if (phrase == null || qValue <= 0.0) {
            return;
        }
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note note = (Note)enume.nextElement();
            double rv = note.getRhythmValue();
            if (rv % qValue < qValue / 2.0) {
                note.setRhythmValue((double)((int)(rv / qValue)) * qValue);
                continue;
            }
            note.setRhythmValue((double)((int)(rv / qValue + 1.0)) * qValue);
        }
    }

    public static void cycle(Phrase phrase, int numNotes) {
        if (phrase == null) {
            return;
        }
        int size = phrase.size();
        if (numNotes <= size) {
            return;
        }
        Phrase newPhr = new Phrase();
        int i = 0;
        while (i < numNotes) {
            newPhr.addNote(phrase.getNote(i % size).copy());
            ++i;
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enume = newPhr.getNoteList().elements();
        while (enume.hasMoreElements()) {
            phrase.getNoteList().addElement(enume.nextElement());
        }
    }

    public static void cycle(Phrase phrase, double numBeats) {
        if (phrase == null || numBeats <= phrase.getEndTime()) {
            return;
        }
        int size = phrase.size();
        Phrase newPhr = new Phrase();
        int i = 0;
        while (newPhr.getEndTime() < numBeats) {
            newPhr.addNote(phrase.getNote(i % size).copy());
            ++i;
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enume = newPhr.getNoteList().elements();
        while (enume.hasMoreElements()) {
            phrase.getNoteList().addElement(enume.nextElement());
        }
    }

    public static void shuffle(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        Phrase newPhr = new Phrase();
        newPhr.addNote(phrase.getNote((int)(Math.random() * (double)phrase.size())));
        int i = 0;
        while (i < phrase.size() - 1) {
            Note n = phrase.getNote((int)(Math.random() * (double)phrase.size()));
            boolean notUsed = true;
            int j = 0;
            while (j < newPhr.size()) {
                if (n == newPhr.getNote(j)) {
                    notUsed = false;
                }
                ++j;
            }
            if (!notUsed) continue;
            newPhr.addNote(n);
            ++i;
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enume = newPhr.getNoteList().elements();
        while (enume.hasMoreElements()) {
            phrase.getNoteList().addElement(enume.nextElement());
        }
    }

    public static void palindrome(Phrase phrase) {
        Mod.palindrome(phrase, true);
    }

    public static void palindrome(Phrase phrase, boolean repeatLastNote) {
        if (phrase == null) {
            return;
        }
        int numbNotes = repeatLastNote ? phrase.size() : phrase.size() - 1;
        int i = numbNotes - 1;
        while (i >= 0) {
            phrase.addNote(phrase.getNote(i));
            --i;
        }
    }

    public static void rotate(Phrase phrase) {
        Mod.rotate(phrase, 1);
    }

    public static void rotate(Phrase phrase, int numSteps) {
        if (phrase == null) {
            return;
        }
        Vector v = phrase.getNoteList();
        int i = 0;
        while (i < numSteps) {
            v.insertElementAt(v.lastElement(), 0);
            v.removeElementAt(v.size() - 1);
            ++i;
        }
    }

    public static void retrograde(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        Phrase backwards = new Phrase();
        int i = phrase.size();
        while (i > 0) {
            backwards.addNote(phrase.getNote(i - 1));
            --i;
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enume = backwards.getNoteList().elements();
        while (enume.hasMoreElements()) {
            phrase.getNoteList().addElement(enume.nextElement());
        }
    }

    public static void inversion(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        int i = 0;
        int firstNote = Integer.MIN_VALUE;
        while (i < phrase.size() && firstNote == Integer.MIN_VALUE) {
            firstNote = phrase.getNote(i++).getPitch();
        }
        while (i < phrase.size()) {
            phrase.getNote(i).setPitch(firstNote - (phrase.getNote(i).getPitch() - firstNote));
            ++i;
        }
    }

    public static void changeLength(Phrase phrase, double newLength) {
        if (phrase == null || newLength <= 0.0) {
            return;
        }
        double oldLength = phrase.getEndTime() - phrase.getStartTime();
        Mod.elongate(phrase, newLength / oldLength);
    }

    public static void elongate(Phrase phrase, double scaleFactor) {
        if (phrase == null || scaleFactor <= 0.0) {
            return;
        }
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note note = (Note)enume.nextElement();
            note.setRhythmValue(note.getRhythmValue() * scaleFactor);
            note.setDuration(note.getDuration() * scaleFactor);
        }
    }

    public static void accents(Phrase phrase, double meter) {
        double[] beats = new double[]{0.0};
        Mod.accents(phrase, meter, beats);
    }

    public static void accents(Phrase phrase, double meter, double[] accentedBeats) {
        Mod.accents(phrase, meter, accentedBeats, 20);
    }

    public static void accents(Phrase phrase, double meter, double[] accentedBeats, int accentAmount) {
        if (phrase == null || meter <= 0.0) {
            return;
        }
        int i = 0;
        while (i < accentedBeats.length) {
            if (accentedBeats[i] < 0.0 || accentedBeats[i] >= meter) {
                return;
            }
            ++i;
        }
        double beatCounter = phrase.getStartTime() < 0.0 ? 0.0 : phrase.getStartTime();
        Vector v = phrase.getNoteList();
        int i2 = 0;
        while (i2 < v.size()) {
            Note n = (Note)v.elementAt(i2);
            int j = 0;
            while (j < accentedBeats.length) {
                if (beatCounter % meter == accentedBeats[j]) {
                    int tempDyn = n.getDynamic();
                    n.setDynamic(tempDyn += accentAmount);
                }
                ++j;
            }
            beatCounter += n.getRhythmValue();
            ++i2;
        }
    }

    public static void normalise(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        int max = 0;
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            if (n.getDynamic() <= max) continue;
            max = n.getDynamic();
        }
        if (max == 127) {
            return;
        }
        int diff = 127 - max;
        Enumeration enume2 = phrase.getNoteList().elements();
        while (enume2.hasMoreElements()) {
            Note n = (Note)enume2.nextElement();
            n.setDynamic(n.getDynamic() + diff);
        }
    }

    public static void shake(Phrase phrase) {
        Mod.shake(phrase, 20);
    }

    public static void shake(Phrase phrase, int amount) {
        if (phrase == null) {
            return;
        }
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            int newValue;
            Note n = (Note)enume.nextElement();
            int currentValue = n.getDynamic();
            while ((newValue = currentValue + (int)(Math.random() * 2.0 * (double)amount - (double)amount)) < 0 || newValue > 127) {
            }
            n.setDynamic(newValue);
        }
    }

    public static void mutate(Phrase phrase) {
        Mod.mutate(phrase, 1, 1, Scales.CHROMATIC_SCALE, phrase.getLowestPitch(), phrase.getHighestPitch(), new double[]{0.25, 0.5, 1.0, 1.5, 2.0});
    }

    public static void mutate(Phrase phrase, int pitchCount, int[] scale) {
        Mod.mutate(phrase, 1, 0, scale, phrase.getLowestPitch(), phrase.getHighestPitch(), new double[0]);
    }

    public static void mutate(Phrase phrase, int pitchCount, int rhythmCount, int[] pitches, int lowestPitch, int highestPitch, double[] rhythms) {
        Note noteToChange;
        int i = 0;
        while (i < pitchCount) {
            int newPitch = (int)(Math.random() * (double)(highestPitch - lowestPitch) + (double)lowestPitch);
            int pitchToChange = (int)(Math.random() * (double)phrase.size());
            noteToChange = phrase.getNote(pitchToChange);
            noteToChange.setPitch(newPitch);
            while (!noteToChange.isScale(pitches)) {
                newPitch = (int)(Math.random() * (double)(highestPitch - lowestPitch) + (double)lowestPitch);
                pitchToChange = (int)(Math.random() * (double)phrase.size());
                noteToChange = phrase.getNote(pitchToChange);
            }
            ++i;
        }
        i = 0;
        while (i < rhythmCount) {
            double newRV = rhythms[(int)(Math.random() * (double)rhythms.length)];
            noteToChange = phrase.getNote((int)(Math.random() * (double)phrase.size()));
            noteToChange.setRhythmValue(newRV);
            noteToChange.setDuration(newRV * 0.9);
            ++i;
        }
    }

    public static void tiePitches(Phrase phrase) {
        int i = 0;
        while (i < phrase.size() - 1) {
            Note currNote = phrase.getNote(i);
            Note nextNote = phrase.getNote(i + 1);
            if (currNote.getPitch() == nextNote.getPitch()) {
                currNote.setRhythmValue(currNote.getRhythmValue() + nextNote.getRhythmValue());
                currNote.setDuration(currNote.getDuration() + nextNote.getDuration());
                phrase.removeNote(i + 1);
                continue;
            }
            ++i;
        }
    }

    public static void tieRests(Phrase phrase) {
        int i = 0;
        while (i < phrase.size() - 1) {
            Note currNote = phrase.getNote(i);
            Note nextNote = phrase.getNote(i + 1);
            if (currNote.getPitch() == Integer.MIN_VALUE && nextNote.getPitch() == Integer.MIN_VALUE) {
                currNote.setRhythmValue(currNote.getRhythmValue() + nextNote.getRhythmValue());
                currNote.setDuration(currNote.getDuration() + nextNote.getDuration());
                phrase.removeNote(i + 1);
                continue;
            }
            ++i;
        }
    }

    public static void fillRests(Phrase phrase) {
        int i = 0;
        while (i < phrase.size() - 1) {
            Note currNote = phrase.getNote(i);
            Note nextNote = phrase.getNote(i + 1);
            if (currNote.getPitch() != Integer.MIN_VALUE && nextNote.getPitch() == Integer.MIN_VALUE) {
                currNote.setRhythmValue(currNote.getRhythmValue() + nextNote.getRhythmValue());
                currNote.setDuration(currNote.getDuration() + nextNote.getDuration());
                phrase.removeNote(i + 1);
                continue;
            }
            ++i;
        }
    }

    public static void spread(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            n.setPan(Math.random());
        }
    }

    public static void bounce(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        boolean left = true;
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            if (left) {
                n.setPan(0.0);
            } else {
                n.setPan(1.0);
            }
            boolean bl = left = !left;
        }
    }

    public static void varyLength(Phrase phrase, double minLength, double maxLength) {
        if (phrase == null || maxLength < minLength) {
            return;
        }
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            double dur = Math.random() * (maxLength - minLength) + minLength;
            n.setDuration(dur);
        }
    }

    public static void randomize(Phrase phrase, int pitchVariation) {
        Mod.randomize(phrase, pitchVariation, 0.0);
    }

    public static void randomize(Phrase phrase, int pitchVariation, double rhythmVariation) {
        Mod.randomize(phrase, pitchVariation, rhythmVariation, 0);
    }

    public static void randomize(Phrase phrase, int pitchVariation, double rhythmVariation, int dynamicVariation) {
        if (phrase == null) {
            return;
        }
        boolean left = true;
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            if (pitchVariation > 0) {
                n.setPitch(n.getPitch() + (int)(Math.random() * (double)(pitchVariation * 2) - (double)pitchVariation));
            }
            if (rhythmVariation > 0.0) {
                double var = Math.random() * (rhythmVariation * 2.0) - rhythmVariation;
                n.setRhythmValue(n.getRhythmValue() + var);
                n.setDuration(n.getDuration() + var);
            }
            if (dynamicVariation <= 0) continue;
            n.setDynamic(n.getDynamic() + (int)(Math.random() * (double)(dynamicVariation * 2) - (double)dynamicVariation));
        }
    }

    public static void slurUp(Phrase phrase) {
        Mod.slurUp(phrase, 2);
    }

    public static void slurDown(Phrase phrase) {
        Mod.slurDown(phrase, 2);
    }

    public static void slurUp(Phrase phrase, int numberOfNotes) {
        if (phrase == null || phrase.size() < numberOfNotes || numberOfNotes < 2) {
            System.err.println("jMusic Mod.slurUp error: Arguments not valid.");
            return;
        }
        boolean change = false;
        int max = phrase.size() - numberOfNotes;
        int i = 0;
        while (i < max) {
            int j = 0;
            while (j < numberOfNotes - 1) {
                if (phrase.getNote(i + j).getPitch() < 0 || phrase.getNote(i + j).getPitch() >= phrase.getNote(i + j + 1).getPitch()) {
                    change = false;
                    break;
                }
                change = true;
                ++j;
            }
            if (change) {
                int k = 0;
                while (k < numberOfNotes - 1) {
                    phrase.getNote(i + k).setDuration(phrase.getNote(i + k).getRhythmValue());
                    ++k;
                }
                i += numberOfNotes - 1;
            } else {
                ++i;
            }
            change = false;
        }
    }

    public static void slurDown(Phrase phrase, int numberOfNotes) {
        if (phrase == null || phrase.size() < numberOfNotes || numberOfNotes < 2) {
            System.err.println("jMusic Mod.slurDown error: Arguments not valid.");
            return;
        }
        boolean change = false;
        int max = phrase.size() - numberOfNotes;
        int i = 0;
        while (i < max) {
            int j = 0;
            while (j < numberOfNotes - 1) {
                if (phrase.getNote(i + j).getPitch() < 0 || phrase.getNote(i + j).getPitch() <= phrase.getNote(i + j + 1).getPitch()) {
                    change = false;
                    break;
                }
                change = true;
                ++j;
            }
            if (change) {
                int k = 0;
                while (k < numberOfNotes - 1) {
                    phrase.getNote(i + k).setDuration(phrase.getNote(i + k).getRhythmValue());
                    ++k;
                }
                i += numberOfNotes - 1;
            } else {
                ++i;
            }
            change = false;
        }
    }

    public static void increaseDuration(Phrase phrase, double multiplyer) {
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            n.setDuration(n.getDuration() * multiplyer);
        }
    }

    public static void addToDuration(Phrase phrase, double amount) {
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            n.setDuration(n.getDuration() + amount);
        }
    }

    public static void addToRhythmValue(Phrase phrase, double amount) {
        Enumeration enume = phrase.getNoteList().elements();
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            n.setRhythmValue(n.getRhythmValue() + amount);
        }
    }

    public static void addToLength(Phrase phrase, double amount) {
        Enumeration enume = phrase.getNoteList().elements();
        double articulation = 0.0;
        while (enume.hasMoreElements()) {
            Note n = (Note)enume.nextElement();
            articulation = n.getRhythmValue() / n.getDuration();
            n.setRhythmValue(n.getRhythmValue() + amount);
            n.setDuration(n.getRhythmValue() * articulation);
        }
    }

    public static void expandIntervals(Phrase phrase, double amount) {
        int phraseSize = phrase.size();
        if (phraseSize < 2) {
            return;
        }
        Note firstNote = phrase.getNote(0);
        int i = 1;
        while (i < phraseSize) {
            Note currNote = phrase.getNote(i);
            int newInterval = (int)((double)(currNote.getPitch() - firstNote.getPitch()) * amount);
            currNote.setPitch(currNote.getPitch() + newInterval);
            ++i;
        }
    }

    public static void transpose(CPhrase cphrase, int trans) {
        if (cphrase == null) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Mod.transpose((Phrase)enume.nextElement(), trans);
        }
    }

    public static void transpose(CPhrase cphrase, int transposition, int[] mode, int key) {
        if (cphrase == null) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Mod.transpose((Phrase)enume.nextElement(), transposition, mode, key);
        }
    }

    public static void repeat(CPhrase cphrase) {
        Mod.repeat(cphrase, 2);
    }

    public static void repeat(CPhrase cphrase, int times) {
        if (cphrase == null) {
            return;
        }
        int initialLength = cphrase.getPhraseList().size();
        int t = 0;
        while (t < times - 1) {
            double initialEndTime = cphrase.getEndTime();
            int i = 0;
            while (i < initialLength) {
                Phrase phr = (Phrase)cphrase.getPhraseList().elementAt(i);
                Phrase phrCopy = phr.copy();
                phrCopy.setStartTime(initialEndTime + phr.getStartTime());
                cphrase.addPhrase(phrCopy);
                ++i;
            }
            ++t;
        }
    }

    public static void repeat(CPhrase cphrase, double startLoc, double endLoc) {
        Mod.repeat(cphrase, 2, startLoc, endLoc);
    }

    public static void repeat(CPhrase cphrase, int times, double startLoc, double endLoc) {
        if (cphrase == null || startLoc >= endLoc || times < 2) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.repeat(nextPhrase, times, startLoc - cphrase.getStartTime(), endLoc - cphrase.getStartTime());
        }
    }

    public static void fadeIn(CPhrase cphrase, double fadeLength) {
        if (cphrase == null || fadeLength <= 0.0) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeIn(nextPhrase, fadeLength, nextPhrase.getStartTime());
        }
    }

    public static void fadeIn(CPhrase cphrase, double fadeLength, double cphraseStartTime) {
        if (cphrase == null || fadeLength < 0.0 || cphraseStartTime < 0.0 || fadeLength <= cphraseStartTime) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeIn(nextPhrase, fadeLength, cphraseStartTime + nextPhrase.getStartTime());
        }
    }

    public static void fadeOut(CPhrase cphrase, double fadeLength) {
        if (cphrase == null || fadeLength <= 0.0) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeOut(nextPhrase, fadeLength, cphrase.getEndTime() - nextPhrase.getEndTime());
        }
    }

    public static void fadeOut(CPhrase cphrase, double fadeLength, double cphraseEndTime) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeOut(nextPhrase, fadeLength, cphraseEndTime + cphrase.getEndTime() - nextPhrase.getEndTime());
        }
    }

    public static void compress(CPhrase cphrase, double ratio) {
        if (cphrase == null) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Mod.compress((Phrase)enume.nextElement(), ratio);
        }
    }

    public static void append(CPhrase cphrase1, CPhrase cphrase2) {
        if (cphrase1 == null || cphrase2 == null) {
            return;
        }
        double et = cphrase1.getEndTime();
        Enumeration enume = cphrase2.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase tempPhrase = (Phrase)enume.nextElement();
            tempPhrase.setStartTime(et + tempPhrase.getStartTime());
            cphrase1.addPhrase(tempPhrase);
        }
    }

    public static void merge(CPhrase cphrase1, CPhrase cphrase2) {
        if (cphrase1 == null || cphrase2 == null) {
            return;
        }
        Enumeration enume = cphrase2.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            cphrase1.addPhrase((Phrase)enume.nextElement());
        }
    }

    public static void quantize(CPhrase cphrase, double qValue) {
        Mod.quantise(cphrase, qValue);
    }

    public static void quantise(CPhrase cphrase, double qValue) {
        if (cphrase == null || qValue <= 0.0) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Mod.quantise((Phrase)enume.nextElement(), qValue);
        }
    }

    public static void shuffle(CPhrase cphrase) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Mod.shuffle((Phrase)enume.nextElement());
        }
    }

    public static void cycle(Part part, double to) {
        if (part == null || to <= 0.0 || to == part.getEndTime()) {
            return;
        }
        double endTime = part.getEndTime();
        if (to < endTime) {
            Part copy = part.copy(0.0, to);
            part.empty();
            part.addPhraseList(copy.getPhraseArray());
            return;
        }
        int startPoint = 1;
        double cycleAt = to;
        cycleAt = to;
        while ((int)(cycleAt / endTime) > 1) {
            Phrase[] phrases = part.getPhraseArray();
            int i = 0;
            while (i < phrases.length) {
                phrases[i].setStartTime(phrases[i].getStartTime() + (double)startPoint * endTime);
                part.addPhrase(phrases[i]);
                ++i;
            }
            ++startPoint;
            cycleAt -= endTime;
        }
        double remainder = to - (double)startPoint * endTime;
        if (remainder > 0.0) {
            Part copy = part.copy(0.0, remainder, true, true, false);
            Phrase[] phrases = copy.getPhraseArray();
            int i = 0;
            while (i < phrases.length) {
                phrases[i].setStartTime(phrases[i].getStartTime() + (double)startPoint * endTime);
                part.addPhrase(phrases[i]);
                ++i;
            }
        }
    }

    public static void elongate(CPhrase cphrase, double scaleFactor) {
        if (cphrase == null || scaleFactor <= 0.0) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.elongate(phr, scaleFactor);
            phr.setStartTime(phr.getStartTime() * scaleFactor);
        }
    }

    public static void accents(CPhrase cphrase, double meter) {
        double[] beats = new double[]{0.0};
        Mod.accents(cphrase, meter, beats);
    }

    public static void accents(CPhrase cphrase, double meter, double[] accentedBeats) {
        Mod.accents(cphrase, meter, accentedBeats, 20);
    }

    public static void accents(CPhrase cphrase, double meter, double[] accentedBeats, int accentAmount) {
        if (cphrase == null || meter <= 0.0) {
            return;
        }
        int i = 0;
        while (i < accentedBeats.length) {
            if (accentedBeats[i] < 0.0 || accentedBeats[i] >= meter) {
                return;
            }
            ++i;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.accents(phrase, meter, accentedBeats, accentAmount);
        }
    }

    public static void normalise(CPhrase cphrase) {
        if (cphrase == null) {
            return;
        }
        int max = 0;
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Enumeration enume1 = phrase.getNoteList().elements();
            while (enume1.hasMoreElements()) {
                Note n = (Note)enume1.nextElement();
                if (n.getDynamic() <= max) continue;
                max = n.getDynamic();
            }
        }
        if (max == 127) {
            return;
        }
        int diff = 127 - max;
        Enumeration enume3 = cphrase.getPhraseList().elements();
        while (enume3.hasMoreElements()) {
            Phrase phrase = (Phrase)enume3.nextElement();
            Enumeration enume2 = phrase.getNoteList().elements();
            while (enume2.hasMoreElements()) {
                Note n = (Note)enume2.nextElement();
                n.setDynamic(n.getDynamic() + diff);
            }
        }
    }

    public static void spread(CPhrase cphrase) {
        if (cphrase == null) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.spread(phr);
        }
    }

    public static void bounce(CPhrase cphrase) {
        if (cphrase == null) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.bounce(phr);
        }
    }

    public static void tiePitches(CPhrase cphrase) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.tiePitches(phrase);
        }
    }

    public static void tieRests(CPhrase cphrase) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.tieRests(phrase);
        }
    }

    public static void fillRests(CPhrase cphrase) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.fillRests(phrase);
        }
    }

    public static void varyLength(CPhrase cphrase, double minLength, double maxLength) {
        if (cphrase == null || maxLength < minLength) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.varyLength(phrase, minLength, maxLength);
        }
    }

    public static void randomize(CPhrase cphrase, int pitchVariation) {
        Mod.randomize(cphrase, pitchVariation, 0.0);
    }

    public static void randomize(CPhrase cphrase, int pitchVariation, double rhythmVariation) {
        Mod.randomize(cphrase, pitchVariation, rhythmVariation, 0);
    }

    public static void randomize(CPhrase cphrase, int pitchVariation, double rhythmVariation, int dynamicVariation) {
        if (cphrase == null) {
            return;
        }
        boolean left = true;
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.randomize(phr, pitchVariation, rhythmVariation, dynamicVariation);
        }
    }

    public static void slurUp(CPhrase cphrase, int numberOfNotes) {
        if (cphrase == null) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.slurUp(phr, numberOfNotes);
        }
    }

    public static void slurDown(CPhrase cphrase, int numberOfNotes) {
        if (cphrase == null) {
            return;
        }
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.slurDown(phr, numberOfNotes);
        }
    }

    public static void increaseDuration(CPhrase cphrase, double multiplyer) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.increaseDuration(phr, multiplyer);
        }
    }

    public static void addToDuration(CPhrase cphrase, double amount) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.addToDuration(phr, amount);
        }
    }

    public static void addToRhythmValue(CPhrase cphrase, double amount) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.addToRhythmValue(phr, amount);
        }
    }

    public static void addToLength(CPhrase cphrase, double amount) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.addToLength(phr, amount);
        }
    }

    public static void expandIntervals(CPhrase cphrase, double amount) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.expandIntervals(phr, amount);
        }
    }

    public static void shake(CPhrase cphrase, int amount) {
        Enumeration enume = cphrase.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.shake(phr, amount);
        }
    }

    public static void repeat(Part part) {
        Mod.repeat(part, 2);
    }

    public static void repeat(Part part, int times) {
        if (part == null) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.repeat(nextPhrase, times);
        }
    }

    public static void repeat(Part part, double startLoc, double endLoc) {
        Mod.repeat(part, 2, startLoc, endLoc);
    }

    public static void repeat(Part part, int times, double startLoc, double endLoc) {
        if (part == null || startLoc >= endLoc || times < 2) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.repeat(nextPhrase, times, startLoc, endLoc);
        }
    }

    public static void transpose(Part part, int transposition) {
        if (part == null || transposition == 0) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.transpose(phr, transposition);
        }
    }

    public static void transpose(Part part, int degrees, int[] mode, int key) {
        if (part == null) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Mod.transpose((Phrase)enume.nextElement(), degrees, mode, key);
        }
    }

    public static void compress(Part part, double ratio) {
        if (part == null) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.compress(phrase, ratio);
        }
    }

    public static void append(Part part1, Part part2) {
        Mod.append(part1, part2, part1.getEndTime());
    }

    public static void append(Part part1, Part part2, double fromLoc) {
        if (part1 == null || part2 == null) {
            return;
        }
        Enumeration enume = part2.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase tempPhrase = ((Phrase)enume.nextElement()).copy();
            tempPhrase.setStartTime(fromLoc + tempPhrase.getStartTime());
            if (tempPhrase.getInstrument() == part1.getInstrument()) {
                tempPhrase.setInstrument(-1);
            }
            part1.addPhrase(tempPhrase);
        }
    }

    public static void increaseDynamic(Part p, int amount) {
        try {
            if (p == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.toString();
            return;
        }
        Enumeration enume = p.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.increaseDynamic(phr, amount);
        }
    }

    public static void fadeIn(Part part, double fadeLength) {
        if (part == null || fadeLength <= 0.0) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeIn(nextPhrase, fadeLength, nextPhrase.getStartTime());
        }
    }

    public static void fadeIn(Part part, double fadeLength, double partStartTime) {
        if (part == null || fadeLength <= 0.0 || partStartTime < 0.0) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeIn(nextPhrase, fadeLength, partStartTime + nextPhrase.getStartTime());
        }
    }

    public static void fadeOut(Part part, double fadeLength) {
        if (part == null || fadeLength <= 0.0) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeOut(nextPhrase, fadeLength, part.getEndTime() - nextPhrase.getEndTime());
        }
    }

    public static void fadeOut(Part part, double fadeLength, double partEndTime) {
        if (part == null || fadeLength <= 0.0 || partEndTime < 0.0) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhrase = (Phrase)enume.nextElement();
            Mod.fadeOut(nextPhrase, fadeLength, partEndTime + part.getEndTime() - nextPhrase.getEndTime());
        }
    }

    public static void merge(Part part1, Part part2) {
        if (part1 == null || part2 == null) {
            return;
        }
        Enumeration enume = part2.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            part1.addPhrase((Phrase)enume.nextElement());
        }
    }

    public static void quantize(Part part, double qValue) {
        Mod.quantise(part, qValue);
    }

    public static void quantise(Part part, double qValue) {
        if (part == null || qValue <= 0.0) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.quantise(phrase, qValue);
        }
    }

    public static void shuffle(Part part) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Mod.shuffle((Phrase)enume.nextElement());
        }
    }

    public static void accents(Part part, double meter) {
        double[] beats = new double[]{0.0};
        Mod.accents(part, meter, beats);
    }

    public static void accents(Part part, double meter, double[] accentedBeats) {
        Mod.accents(part, meter, accentedBeats, 20);
    }

    public static void accents(Part part, double meter, double[] accentedBeats, int accentAmount) {
        if (part == null || meter <= 0.0) {
            return;
        }
        int i = 0;
        while (i < accentedBeats.length) {
            if (accentedBeats[i] < 0.0 || accentedBeats[i] >= meter) {
                return;
            }
            ++i;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.accents(phrase, meter, accentedBeats, accentAmount);
        }
    }

    public static void normalise(Part part) {
        if (part == null) {
            return;
        }
        int max = 0;
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Enumeration enume1 = phrase.getNoteList().elements();
            while (enume1.hasMoreElements()) {
                Note n = (Note)enume1.nextElement();
                if (n.getDynamic() <= max) continue;
                max = n.getDynamic();
            }
        }
        if (max == 127) {
            return;
        }
        int diff = 127 - max;
        Enumeration enume3 = part.getPhraseList().elements();
        while (enume3.hasMoreElements()) {
            Phrase phrase = (Phrase)enume3.nextElement();
            Enumeration enume2 = phrase.getNoteList().elements();
            while (enume2.hasMoreElements()) {
                Note n = (Note)enume2.nextElement();
                n.setDynamic(n.getDynamic() + diff);
            }
        }
    }

    public static void elongate(Part part, double scaleFactor) {
        if (part == null || scaleFactor <= 0.0) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.elongate(phrase, scaleFactor);
        }
    }

    public static void tiePitches(Part part) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.tiePitches(phrase);
        }
    }

    public static void tieRests(Part part) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.tieRests(phrase);
        }
    }

    public static void fillRests(Part part) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.fillRests(phrase);
        }
    }

    public static void spread(Part part) {
        if (part == null) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.spread(phr);
        }
    }

    public static void bounce(Part part) {
        if (part == null) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.bounce(phr);
        }
    }

    public static void varyLength(Part part, double minLength, double maxLength) {
        if (part == null || maxLength < minLength) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            Mod.varyLength(phrase, minLength, maxLength);
        }
    }

    public static void randomize(Part part, int pitchVariation) {
        Mod.randomize(part, pitchVariation, 0.0);
    }

    public static void randomize(Part part, int pitchVariation, double rhythmVariation) {
        Mod.randomize(part, pitchVariation, rhythmVariation, 0);
    }

    public static void randomize(Part part, int pitchVariation, double rhythmVariation, int dynamicVariation) {
        if (part == null) {
            return;
        }
        boolean left = true;
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.randomize(phr, pitchVariation, rhythmVariation, dynamicVariation);
        }
    }

    public static void slurUp(Part part, int numberOfNotes) {
        if (part == null) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.slurUp(phr, numberOfNotes);
        }
    }

    public static void slurDown(Part part, int numberOfNotes) {
        if (part == null) {
            return;
        }
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.slurDown(phr, numberOfNotes);
        }
    }

    public static void increaseDuration(Part part, double multiplyer) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.increaseDuration(phr, multiplyer);
        }
    }

    public static void addToDuration(Part part, double amount) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.addToDuration(phr, amount);
        }
    }

    public static void addToRhythmValue(Part part, double amount) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.addToRhythmValue(phr, amount);
        }
    }

    public static void addToLength(Part part, double amount) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.addToLength(phr, amount);
        }
    }

    public static void expandIntervals(Part part, double amount) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.expandIntervals(phr, amount);
        }
    }

    public static void shake(Part part, int amount) {
        Enumeration enume = part.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phr = (Phrase)enume.nextElement();
            Mod.shake(phr, amount);
        }
    }

    public static void transpose(Score scr, int transposition) {
        if (scr == null || transposition == 0) {
            return;
        }
        Enumeration enume = scr.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.transpose(part, transposition);
        }
    }

    public static void transpose(Score score, int degrees, int[] mode, int key) {
        if (score == null) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Mod.transpose((Part)enume.nextElement(), degrees, mode, key);
        }
    }

    public static void fadeIn(Score score, double fadeLength) {
        if (score == null || fadeLength <= 0.0) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part nextPart = (Part)enume.nextElement();
            Mod.fadeIn(nextPart, fadeLength);
        }
    }

    public static void increaseDynamic(Score s, int amount) {
        try {
            if (s == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.toString();
            return;
        }
        Enumeration enume = s.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.increaseDynamic(p, amount);
        }
    }

    public static void fadeOut(Score score, double fadeLength) {
        if (score == null || fadeLength <= 0.0) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part nextPart = (Part)enume.nextElement();
            Mod.fadeOut(nextPart, fadeLength, score.getEndTime() - nextPart.getEndTime());
        }
    }

    public static void compress(Score score, double ratio) {
        if (score == null) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.compress(part, ratio);
        }
    }

    public static void repeat(Score score) {
        Mod.repeat(score, 2);
    }

    public static void repeat(Score score, int times) {
        if (score == null || times < 2) {
            return;
        }
        double maxEndTime = 0.0;
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            if (!(maxEndTime < part.getEndTime())) continue;
            maxEndTime = part.getEndTime();
        }
        int i = 0;
        while (i < score.getPartList().size()) {
            Part p = (Part)score.getPartList().elementAt(i);
            int numbOfPhrases = p.getPhraseList().size();
            int t = 0;
            while (t < times - 1) {
                double initialEndTime = maxEndTime * (double)(t + 1);
                int j = 0;
                while (j < numbOfPhrases) {
                    Phrase phr = (Phrase)p.getPhraseList().elementAt(j);
                    Phrase phrCopy = phr.copy();
                    phrCopy.setStartTime(initialEndTime + phr.getStartTime());
                    p.addPhrase(phrCopy);
                    ++j;
                }
                ++t;
            }
            ++i;
        }
    }

    public static void append(Score score1, Score score2) {
        if (score1 == null || score2 == null) {
            return;
        }
        score2.clean();
        if (score2.size() == 0) {
            return;
        }
        double endTime = score1.getEndTime();
        Enumeration enume = score2.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part currPart = (Part)enume.nextElement();
            Enumeration enume2 = currPart.getPhraseList().elements();
            while (enume2.hasMoreElements()) {
                Phrase currPhrase = (Phrase)enume2.nextElement();
                currPhrase.setStartTime(currPhrase.getStartTime() + endTime);
                if (currPhrase.getInstrument() != 250 && currPhrase.getInstrument() != currPart.getInstrument()) {
                    currPhrase.setInstrument(currPart.getInstrument());
                }
                if (currPhrase.getInstrument() != currPart.getInstrument()) continue;
                currPhrase.setInstrument(-1);
            }
        }
        Mod.merge(score1, score2);
    }

    public static void merge(Score score1, Score score2) {
        if (score1 == null || score2 == null) {
            return;
        }
        boolean channelExists = false;
        int s1Size = score1.size();
        int s2Size = score2.size();
        int i = 0;
        while (i < s2Size) {
            Part partToMerge = score2.getPart(i);
            int chan = partToMerge.getChannel();
            int j = 0;
            while (j < s1Size) {
                Part existingPart = score1.getPart(j);
                if (chan == existingPart.getChannel()) {
                    int phraseNumb = partToMerge.size();
                    int k = 0;
                    while (k < phraseNumb) {
                        existingPart.addPhrase(partToMerge.getPhrase(k));
                        ++k;
                    }
                    channelExists = true;
                    j = s1Size;
                }
                ++j;
            }
            if (!channelExists) {
                score1.addPart(partToMerge);
                channelExists = false;
            }
            ++i;
        }
    }

    public static void quantize(Score score, double qValue) {
        Mod.quantise(score, qValue);
    }

    public static void quantise(Score score, double qValue) {
        if (score == null || qValue <= 0.0) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.quantise(part, qValue);
        }
    }

    public static void shuffle(Score score) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Mod.shuffle((Part)enume.nextElement());
        }
    }

    public static void accents(Score score, double meter) {
        double[] beats = new double[]{0.0};
        Mod.accents(score, meter, beats);
    }

    public static void accents(Score score, double meter, double[] accentedBeats) {
        Mod.accents(score, meter, accentedBeats, 20);
    }

    public static void accents(Score score, double meter, double[] accentedBeats, int accentAmount) {
        if (score == null || meter <= 0.0) {
            return;
        }
        int i = 0;
        while (i < accentedBeats.length) {
            if (accentedBeats[i] < 0.0 || accentedBeats[i] >= meter) {
                return;
            }
            ++i;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.accents(part, meter, accentedBeats, accentAmount);
        }
    }

    public static void normalise(Score score) {
        if (score == null) {
            return;
        }
        int max = 0;
        Enumeration enumeS = score.getPartList().elements();
        while (enumeS.hasMoreElements()) {
            Part part = (Part)enumeS.nextElement();
            Enumeration enume = part.getPhraseList().elements();
            while (enume.hasMoreElements()) {
                Phrase phrase = (Phrase)enume.nextElement();
                Enumeration enume1 = phrase.getNoteList().elements();
                while (enume1.hasMoreElements()) {
                    Note n = (Note)enume1.nextElement();
                    if (n.getDynamic() <= max) continue;
                    max = n.getDynamic();
                }
            }
        }
        if (max == 127) {
            return;
        }
        int diff = 127 - max;
        Enumeration enumeS2 = score.getPartList().elements();
        while (enumeS2.hasMoreElements()) {
            Part part = (Part)enumeS2.nextElement();
            Enumeration enume3 = part.getPhraseList().elements();
            while (enume3.hasMoreElements()) {
                Phrase phrase = (Phrase)enume3.nextElement();
                Enumeration enume2 = phrase.getNoteList().elements();
                while (enume2.hasMoreElements()) {
                    Note n = (Note)enume2.nextElement();
                    n.setDynamic(n.getDynamic() + diff);
                }
            }
        }
    }

    public static void consolidate(Score score) {
        if (score == null) {
            return;
        }
        int c = 0;
        while (c < score.size()) {
            Part p = score.getPart(c);
            int chan = p.getChannel();
            int scoreSize = score.size();
            int i = scoreSize - 1;
            while (i > c) {
                Part p2 = score.getPart(i);
                if (p2.getChannel() == chan) {
                    int phraseSize = p2.size();
                    int j = 0;
                    while (j < phraseSize) {
                        Phrase phr = p2.getPhrase(j);
                        phr.setAppend(false);
                        p.addPhrase(phr);
                        ++j;
                    }
                    score.removePart(i);
                }
                --i;
            }
            ++c;
        }
    }

    public static void elongate(Score score, double scaleFactor) {
        if (score == null || scaleFactor <= 0.0) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.elongate(part, scaleFactor);
        }
    }

    public static void tiePitches(Score score) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.tiePitches(part);
        }
    }

    public static void tieRests(Score score) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.tieRests(part);
        }
    }

    public static void fillRests(Score score) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.fillRests(part);
        }
    }

    public static void spread(Score score) {
        if (score == null) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.spread(p);
        }
    }

    public static void bounce(Score score) {
        if (score == null) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.bounce(p);
        }
    }

    public static void varyLength(Score score, double minLength, double maxLength) {
        if (score == null || maxLength < minLength) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.varyLength(part, minLength, maxLength);
        }
    }

    public static void randomize(Score score, int pitchVariation) {
        Mod.randomize(score, pitchVariation, 0.0);
    }

    public static void randomize(Score score, int pitchVariation, double rhythmVariation) {
        Mod.randomize(score, pitchVariation, rhythmVariation, 0);
    }

    public static void randomize(Score score, int pitchVariation, double rhythmVariation, int dynamicVariation) {
        if (score == null) {
            return;
        }
        boolean left = true;
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.randomize(p, pitchVariation, rhythmVariation, dynamicVariation);
        }
    }

    public static void slurUp(Score score, int numberOfNotes) {
        if (score == null) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.slurUp(p, numberOfNotes);
        }
    }

    public static void slurDown(Score score, int numberOfNotes) {
        if (score == null) {
            return;
        }
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.slurDown(p, numberOfNotes);
        }
    }

    public static void increaseDuration(Score score, double multiplyer) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.increaseDuration(p, multiplyer);
        }
    }

    public static void addToDuration(Score score, double amount) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.addToDuration(p, amount);
        }
    }

    public static void addToRhythmValue(Score score, double amount) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.addToRhythmValue(p, amount);
        }
    }

    public static void addToLength(Score score, double amount) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.addToLength(p, amount);
        }
    }

    public static void expandIntervals(Score score, double amount) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part p = (Part)enume.nextElement();
            Mod.expandIntervals(p, amount);
        }
    }

    public static void shake(Score score, int amount) {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            Mod.shake(part, amount);
        }
    }
}

