/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.PhraseAnalysis;

public final class ChordAnalysis {
    public static final int[] RATINGS = new int[]{1, 4, 4, 3, 2, 5, 7};

    private ChordAnalysis() {
    }

    public static Possible[] getChords(Phrase phrase, double beatLength, int tonic, int[] scale) {
        int[][] triads = new int[scale.length][3];
        int i = 0;
        while (i < scale.length) {
            triads[i][0] = scale[i];
            triads[i][1] = scale[(i + 2) % scale.length];
            triads[i][2] = scale[(i + 4) % scale.length];
            ++i;
        }
        double startTime = phrase.getStartTime();
        if (startTime < 0.0) {
            startTime = 0.0;
        }
        double rvCount = 0.0;
        int noteCount = 0;
        double endTime = phrase.getEndTime();
        if (endTime == 0.0) {
            return new Possible[0];
        }
        Note downBeat = new Note();
        Note halfBeat = new Note();
        int size = phrase.size();
        Possible[] chords = new Possible[(int)Math.ceil(endTime / beatLength)];
        int i2 = 0;
        i2 = 0;
        block1: while (i2 < chords.length) {
            downBeat = rvCount == (double)i2 * beatLength ? phrase.getNote(noteCount) : null;
            while (rvCount < ((double)i2 + 0.5) * beatLength) {
                rvCount += phrase.getNote(noteCount).getRhythmValue();
                if (++noteCount < size) continue;
                halfBeat = null;
                break block1;
            }
            halfBeat = rvCount == ((double)i2 + 0.5) * beatLength ? phrase.getNote(noteCount) : null;
            while (rvCount < (double)(i2 + 1) * beatLength) {
                rvCount += phrase.getNote(noteCount).getRhythmValue();
                if (++noteCount >= size) break block1;
            }
            chords[i2] = ChordAnalysis.firstPass(downBeat, halfBeat, tonic, scale, triads);
            ++i2;
        }
        chords[i2] = ChordAnalysis.firstPass(downBeat, halfBeat, tonic, scale, triads);
        return chords;
    }

    public static int[] getFirstPassChords(Phrase phrase, double beatLength, int tonic, int[] scale) {
        Possible[] chords = ChordAnalysis.getChords(phrase, beatLength, tonic, scale);
        int[] returnChords = new int[chords.length];
        int j = 0;
        while (j < chords.length) {
            returnChords[j] = chords[j] != null ? chords[j].getBestChord() : 7;
            ++j;
        }
        return returnChords;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] getSecondPassChords(Phrase phrase, double beatLength, int tonic, int[] scale) {
        chords = ChordAnalysis.getChords(phrase, beatLength, tonic, scale);
        returnChords = new int[chords.length];
        index = chords.length - 1;
        if (index >= 0) ** GOTO lbl9
        return new int[0];
lbl-1000:
        // 1 sources

        {
            returnChords[index] = 7;
            if (--index >= 0) continue;
            return returnChords;
lbl9:
            // 2 sources

            ** while (chords[index] == null)
        }
lbl10:
        // 1 sources

        returnChords[index] = chords[index].getBestChord();
        previousChord = returnChords[index];
        --index;
        ** GOTO lbl22
        {
            returnChords[index] = 7;
            if (--index < 1) break;
            do {
                if (chords[index] == null) continue block1;
                dominantIndex = (previousChord + 4) % scale.length;
                returnChords[index] = ChordAnalysis.acceptableChange(chords[index].chords, dominantIndex, chords[index].getBestChord()) != false ? dominantIndex : chords[index].getBestChord();
                previousChord = returnChords[index];
                --index;
lbl22:
                // 2 sources

            } while (index > 0);
        }
        returnChords[0] = chords[0] == null ? 7 : chords[0].getBestChord();
        return returnChords;
    }

    private static boolean acceptableChange(int[] chords, int dominantIndex, int previous) {
        int i = 0;
        while (i < chords.length) {
            if (chords[i] == dominantIndex && RATINGS[chords[i]] <= 2 + RATINGS[previous]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Possible firstPass(Note downBeat, Note halfBeat, int tonic, int[] scale, int[][] triads) {
        if (ChordAnalysis.isBad(downBeat, tonic, scale)) {
            if (ChordAnalysis.isBad(halfBeat, tonic, scale)) {
                return null;
            }
            return ChordAnalysis.firstPassChords(halfBeat, tonic, scale, triads);
        }
        if (ChordAnalysis.isBad(halfBeat, tonic, scale)) {
            return ChordAnalysis.firstPassChords(downBeat, tonic, scale, triads);
        }
        if (PhraseAnalysis.pitchToDegree(downBeat.getPitch(), tonic) == PhraseAnalysis.pitchToDegree(halfBeat.getPitch(), tonic)) {
            return ChordAnalysis.firstPassChords(downBeat, tonic, scale, triads);
        }
        return ChordAnalysis.firstPassChords(downBeat, halfBeat, tonic, scale, triads);
    }

    private static boolean isBad(Note note, int tonic, int[] scale) {
        if (note == null) {
            return true;
        }
        if (note.getPitch() == Integer.MIN_VALUE) {
            return true;
        }
        return !PhraseAnalysis.isScale(note, tonic, scale);
    }

    private static Possible firstPassChords(Note note, int tonic, int[] scale, int[][] triads) {
        Possible returnChords = new Possible(new int[3]);
        int index = 0;
        int degree = PhraseAnalysis.pitchToDegree(note.getPitch(), tonic);
        int i = 0;
        while (i < triads.length) {
            if (ChordAnalysis.isInTriad(degree, triads[i])) {
                returnChords.chords[index++] = i;
            }
            ++i;
        }
        return returnChords;
    }

    private static Possible firstPassChords(Note note1, Note note2, int tonic, int[] scale, int[][] triads) {
        Possible firstChords = ChordAnalysis.firstPassChords(note1, tonic, scale, triads);
        Possible secondChords = ChordAnalysis.firstPassChords(note2, tonic, scale, triads);
        Possible commonChords = ChordAnalysis.findCommonChords(firstChords.chords, secondChords.chords);
        return commonChords == null ? firstChords : commonChords;
    }

    private static boolean isInTriad(int degree, int[] triad) {
        int i = 0;
        while (i < triad.length) {
            if (triad[i] == degree) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Possible findCommonChords(int[] firstChords, int[] secondChords) {
        Possible returnChords = new Possible(new int[2]);
        int index = 0;
        int i = 0;
        while (i < firstChords.length) {
            int j = 0;
            while (j < secondChords.length) {
                if (firstChords[i] == secondChords[j]) {
                    returnChords.chords[index++] = firstChords[i];
                }
                ++j;
            }
            ++i;
        }
        if (index == 0) {
            return null;
        }
        if (index == 2) {
            return returnChords;
        }
        if (index == 1) {
            int[] value = new int[]{returnChords.chords[0]};
            return new Possible(value);
        }
        throw new Error("Unexpected value for index");
    }

    private static class Possible {
        int[] chords = null;

        Possible() {
        }

        Possible(int[] chords) {
            this.chords = chords;
        }

        int getBestChord() {
            if (this.chords == null) {
                return -1;
            }
            int currentBest = 6;
            int i = 0;
            while (i < this.chords.length) {
                if (RATINGS[this.chords[i]] < RATINGS[currentBest]) {
                    currentBest = this.chords[i];
                }
                ++i;
            }
            return currentBest;
        }
    }
}

