/*
 * Decompiled with CFR 0.152.
 */
package jm.music.rt;

import jm.JMC;
import jm.audio.Instrument;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.rt.RTLine;

public class RTPhrase
extends RTLine
implements JMC {
    private Phrase phrase;
    private int noteCounter = 0;
    private boolean waitForStartTime = true;
    private Note aRest = new Note(Integer.MIN_VALUE, 1.0);

    public RTPhrase(Phrase phrase, Instrument inst) {
        this(phrase, new Instrument[]{inst});
    }

    public RTPhrase(Phrase phrase, Instrument[] instArray) {
        super(instArray);
        this.phrase = phrase;
        if (phrase.getTempo() != -1.0) {
            this.setTempo(phrase.getTempo());
        }
        if (phrase.getStartTime() == 0.0) {
            this.waitForStartTime = false;
        }
    }

    public synchronized Note getNote() {
        if (this.waitForStartTime) {
            this.waitForStartTime = false;
            this.aRest.setRhythmValue(this.phrase.getStartTime());
            return this.aRest;
        }
        if (this.noteCounter < this.phrase.getSize()) {
            return this.phrase.getNote(this.noteCounter++);
        }
        this.aRest.setRhythmValue(1.0);
        return this.aRest;
    }
}

