/*
 * Decompiled with CFR 0.152.
 */
package jm.music.rt;

import jm.audio.AOException;
import jm.audio.AudioChainListener;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.music.data.Note;

public abstract class RTLine
implements AudioChainListener {
    protected Instrument[] inst;
    protected boolean clear = false;
    private double localCounter = 0.0;
    private boolean newNote = true;
    private double tempo = 60.0;
    private double testpos;
    private double size;

    public RTLine(Instrument[] inst) {
        this.inst = inst;
        int i = 0;
        while (i < inst.length) {
            inst[i].addRTLine(this);
            ++i;
        }
        int sr = inst[0].getSampleRate();
        int ch = inst[0].getChannels();
        int i2 = 0;
        while (i2 < inst.length) {
            if (inst[i2].getSampleRate() != sr) {
                System.err.println("jMusic RTLine error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (inst[i2].getChannels() != ch) {
                System.err.println("jMusic RTLine error: All instruments must have the same number of channels.");
                System.exit(0);
            }
            ++i2;
        }
        this.size = sr * ch;
    }

    public Instrument[] getInstrument() {
        return this.inst;
    }

    public int getNumLines() {
        return this.inst.length;
    }

    public void setTempo(double tempo) {
        this.tempo = tempo;
    }

    public void setBufferSize(int buf) {
        int i = 0;
        while (i < this.inst.length) {
            this.inst[i].setBufSize(buf);
            ++i;
        }
    }

    public int getSampleRate() {
        return this.inst[0].getSampleRate();
    }

    public int getChannels() {
        return this.inst[0].getChannels();
    }

    public void externalAction(Object obj, int actionNumber) {
    }

    public synchronized void controlChange(float[] buffer, int returned, boolean finished) {
    }

    public void instNote(Instrument inst, long samplesProcessed) {
        Note note = null;
        double scorePos = (double)samplesProcessed / this.size;
        double temp = 60.0 / this.tempo;
        if (scorePos > this.testpos - 0.001 && scorePos < this.testpos + 0.001) {
            note = this.getNote().copy();
            note.setRhythmValue(note.getRhythmValue() * temp);
            note.setDuration(note.getDuration() * temp);
            this.testpos += note.getRhythmValue();
        } else {
            note = new Note(Integer.MIN_VALUE, this.testpos - scorePos);
            note.setRhythmValue(note.getRhythmValue() * temp);
            note.setDuration(note.getRhythmValue());
        }
        inst.renderNote(note, scorePos);
    }

    public void start(double scorePosition, RTMixer rta) {
        int i = 0;
        while (i < this.inst.length) {
            try {
                if (!this.inst[i].getInitialised()) {
                    this.inst[i].createChain();
                    this.inst[i].setInitialised(true);
                }
                this.inst[i].addAudioChainListener(rta);
            }
            catch (AOException aoe) {
                aoe.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < this.inst.length) {
            this.inst[i].start();
            ++i;
        }
    }

    public void pause() {
        int i = 0;
        while (i < this.inst.length) {
            this.inst[i].pause();
            ++i;
        }
    }

    public void unPause() {
        int i = 0;
        while (i < this.inst.length) {
            this.inst[i].unPause();
            ++i;
        }
    }

    public abstract Note getNote();
}

