/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class CPhrase
implements JMC,
Cloneable,
Serializable {
    private Vector phraseList;
    private double currentTime;
    private double startTime;
    private String title;
    private int instrument = -1;
    private boolean append = false;
    private Phrase linkedPhrase;
    private double pan = 0.5;
    private double tempo = -1.0;
    private int volume = 100;

    public CPhrase() {
        this("Untitled CPhrase", 0.0, -1, true);
    }

    public CPhrase(double startTime) {
        this("Untitled CPhrase", startTime, -1, false);
    }

    public CPhrase(String title) {
        this(title, 0.0, -1, true);
    }

    public CPhrase(String title, double startTime) {
        this(title, startTime, -1, false);
    }

    public CPhrase(double startTime, int instrument) {
        this("Untitled CPhrase", startTime, instrument, false);
    }

    public CPhrase(String title, double startTime, int instrument) {
        this(title, startTime, instrument, false);
    }

    public CPhrase(String title, double startTime, int instrument, boolean append) {
        this.title = title;
        this.startTime = startTime;
        this.currentTime = startTime;
        this.instrument = instrument;
        this.append = append;
        this.phraseList = new Vector();
    }

    public Vector getPhraseList() {
        return this.phraseList;
    }

    public void setPhraseList(Vector phraseList) {
        this.phraseList = phraseList;
    }

    public void addPhrase(Phrase phrase) {
        if (phrase.getAppend()) {
            phrase.setStartTime(this.startTime);
        }
        if (phrase.getStartTime() >= this.startTime) {
            this.phraseList.addElement(phrase);
        } else {
            System.err.println("Phrase to added to CPhrase: Phrases added to a CPhrase must have a start time at ot after the CPhrase start time.");
        }
    }

    public void removePhrase(Phrase phrase) {
        this.phraseList.removeElement(phrase);
    }

    public void addChord(int[] pitchArray, double rhythmValue) {
        this.addChord(pitchArray, rhythmValue, 70);
    }

    public void addChord(int[] pitchArray, double rhythmValue, int dynamic) {
        if (this.phraseList.size() < pitchArray.length) {
            int num = pitchArray.length - this.phraseList.size();
            int i = 0;
            while (i < num) {
                Phrase phr = new Phrase(this.getEndTime(), this.instrument);
                this.phraseList.addElement(phr);
                ++i;
            }
        }
        int i = 0;
        while (i < pitchArray.length) {
            Note newNote = new Note(pitchArray[i], rhythmValue, dynamic);
            ((Phrase)this.phraseList.elementAt(i)).addNote(newNote);
            ++i;
        }
        while (i < this.phraseList.size()) {
            Note newNote = new Note(Integer.MIN_VALUE, rhythmValue);
            ((Phrase)this.phraseList.elementAt(i)).addNote(newNote);
            ++i;
        }
    }

    public void addChord(Note[] noteArray) {
        this.currentTime = this.getEndTime();
        double rhythmValue = noteArray[0].getRhythmValue();
        if (this.phraseList.size() < noteArray.length) {
            int num = noteArray.length - this.phraseList.size();
            int i = 0;
            while (i < num) {
                Phrase phr = new Phrase(this.getEndTime(), this.instrument);
                this.phraseList.addElement(phr);
                ++i;
            }
        }
        int i = 0;
        while (i < noteArray.length) {
            noteArray[i].setRhythmValue(rhythmValue);
            ((Phrase)this.phraseList.elementAt(i)).addNote(noteArray[i]);
            ++i;
        }
        while (i < this.phraseList.size()) {
            Note newNote = new Note(Integer.MIN_VALUE, rhythmValue);
            ((Phrase)this.phraseList.elementAt(i)).addNote(newNote);
            ++i;
        }
        this.currentTime += rhythmValue;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        double startOffset = startTime - this.startTime;
        Enumeration enume = this.phraseList.elements();
        while (enume.hasMoreElements()) {
            Phrase ph = (Phrase)enume.nextElement();
            ph.setStartTime(ph.getStartTime() + startOffset);
        }
        this.startTime = startTime;
        this.append = false;
    }

    public double getEndTime() {
        double endTime = this.getStartTime();
        Enumeration enume = this.phraseList.elements();
        while (enume.hasMoreElements()) {
            Phrase nextPhr = (Phrase)enume.nextElement();
            double phraseEnd = nextPhr.getEndTime();
            if (!(phraseEnd > endTime)) continue;
            endTime = phraseEnd;
        }
        return endTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setTitle(int instrument) {
        if (instrument < -1) {
            this.instrument = instrument;
        }
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public Phrase getLinkedPhrase() {
        return this.linkedPhrase;
    }

    public void setLinkedPhrase(Phrase link) {
        this.linkedPhrase = link;
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan;
        Enumeration enume = this.phraseList.elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            phrase.setPan(pan);
        }
    }

    public int getHighestPitch() {
        int max = 0;
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            if (phrase.getHighestPitch() <= max) continue;
            max = phrase.getHighestPitch();
        }
        return max;
    }

    public int getLowestPitch() {
        int min = 127;
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            if (phrase.getLowestPitch() >= min) continue;
            min = phrase.getLowestPitch();
        }
        return min;
    }

    public double getLongestRhythmValue() {
        double max = 0.0;
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            if (!(phrase.getLongestRhythmValue() > max)) continue;
            max = phrase.getLongestRhythmValue();
        }
        return max;
    }

    public double getShortestRhythmValue() {
        double min = 1000.0;
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            if (!(phrase.getShortestRhythmValue() < min)) continue;
            min = phrase.getShortestRhythmValue();
        }
        return min;
    }

    public CPhrase copy() {
        Vector<Phrase> tempVect = new Vector<Phrase>();
        CPhrase cp = new CPhrase(String.valueOf(this.title) + " copy", this.startTime, this.instrument);
        Enumeration enume = this.phraseList.elements();
        while (enume.hasMoreElements()) {
            Phrase ph = ((Phrase)enume.nextElement()).copy();
            tempVect.addElement(ph);
        }
        cp.setPhraseList(tempVect);
        cp.setAppend(this.append);
        cp.setLinkedPhrase(this.linkedPhrase);
        return cp;
    }

    public CPhrase copy(double startLoc, double endLoc) {
        Vector<Phrase> tempVect = new Vector<Phrase>();
        CPhrase cp = new CPhrase(String.valueOf(this.title) + " copy", startLoc, this.instrument);
        Enumeration enume = this.phraseList.elements();
        while (enume.hasMoreElements()) {
            Phrase ph = ((Phrase)enume.nextElement()).copy(startLoc, endLoc);
            ph.setStartTime(0.0);
            tempVect.addElement(ph);
        }
        cp.setPhraseList(tempVect);
        cp.setAppend(this.append);
        cp.setLinkedPhrase(this.linkedPhrase);
        return cp;
    }

    public void empty() {
        this.phraseList.removeAllElements();
    }

    public String toString() {
        String cphraseData = new String("---- jMusic CPHRASE: '" + this.title + "' Start time: " + this.startTime + " ----" + '\n');
        Enumeration enume = this.phraseList.elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            cphraseData = String.valueOf(cphraseData) + phrase.toString() + '\n';
        }
        return cphraseData;
    }

    public void setDynamic(int dyn) {
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            phrase.setDynamic(dyn);
        }
    }

    public void setPitch(int val) {
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            phrase.setPitch(val);
        }
    }

    public void setRhythmValue(int val) {
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            phrase.setRhythmValue(val);
        }
    }

    public void setDuration(double val) {
        Enumeration enume = this.getPhraseList().elements();
        while (enume.hasMoreElements()) {
            Phrase phrase = (Phrase)enume.nextElement();
            phrase.setDuration(val);
        }
    }

    public void flam() {
        this.flam(0.05);
    }

    public void flam(double offsetAmount) {
        int phraseCounter = 0;
        Enumeration enume = this.phraseList.elements();
        while (enume.hasMoreElements()) {
            double currOffset = offsetAmount * (double)phraseCounter;
            Phrase phr = (Phrase)enume.nextElement();
            Enumeration enum2 = phr.getNoteList().elements();
            while (enum2.hasMoreElements()) {
                Note n = (Note)enum2.nextElement();
                n.setOffset(currOffset);
            }
            ++phraseCounter;
        }
    }

    public void setTempo(double val) {
        if (val > 0.0) {
            this.tempo = val;
            Enumeration enume = this.phraseList.elements();
            while (enume.hasMoreElements()) {
                Phrase phr = (Phrase)enume.nextElement();
                phr.setTempo(val);
            }
        }
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setVolume(int val) {
        if ((double)val > 0.0) {
            this.volume = val;
            Enumeration enume = this.phraseList.elements();
            while (enume.hasMoreElements()) {
                Phrase phr = (Phrase)enume.nextElement();
                phr.setVolume(val);
            }
        }
    }

    public double getVolume() {
        return this.volume;
    }
}

