/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;

public final class TempoEvent
implements Event {
    private short id = (short)16;
    private int time = 0;
    private double tempo = 60.0;

    public TempoEvent() {
        this(0, 0.0);
    }

    public TempoEvent(double tempo) {
        this(0, tempo);
    }

    public TempoEvent(int time, double tempo) {
        this.time = time;
        this.tempo = tempo;
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double tempo) {
        this.tempo = tempo;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return this.id;
    }

    public int write(DataOutputStream dos) throws IOException {
        int bytes_out = MidiUtil.writeVarLength(this.time, dos);
        dos.writeByte(-1);
        dos.writeByte(81);
        int temp = (int)(60.0f / (float)this.tempo * 1000000.0f);
        dos.writeByte((byte)(temp >> 16 & 0xFF));
        dos.writeByte((byte)(temp >> 8 & 0xFF));
        dos.writeByte((byte)(temp & 0xFF));
        return (bytes_out += MidiUtil.writeVarLength(3, dos)) + 5;
    }

    public int read(DataInputStream dis) throws IOException {
        int b1 = dis.readUnsignedByte();
        int b2 = dis.readUnsignedByte();
        int b3 = dis.readUnsignedByte();
        int temp = (b1 << 16) + (b2 << 8) + b3;
        this.tempo = 1000000.0f / (float)temp * 60.0f;
        return 3;
    }

    public Event copy() throws CloneNotSupportedException {
        TempoEvent event;
        try {
            event = (TempoEvent)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new TempoEvent();
        }
        return event;
    }

    public void print() {
        System.out.println("TempoEvent(020):             [time = " + this.time + "][tempo = " + this.tempo + "]");
    }
}

