/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class CChange
implements VoiceEvt,
Cloneable {
    private final short id = (short)3;
    private short controllerNum;
    private short value;
    private short midiChannel;
    private int time;

    public CChange() {
        this.controllerNum = 0;
        this.value = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public CChange(short controllerNum, short value, short midiChannel, int time) {
        this.controllerNum = controllerNum;
        this.value = value;
        this.midiChannel = midiChannel;
        this.time = time;
    }

    public short getControllerNum() {
        return this.controllerNum;
    }

    public void setControllerNum(short controllerNum) {
        this.controllerNum = controllerNum;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    public short getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(short midiChannel) {
        this.midiChannel = midiChannel;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return 3;
    }

    public int write(DataOutputStream dos) throws IOException {
        int bytes_out = MidiUtil.writeVarLength(this.time, dos);
        dos.writeByte((byte)(176 + this.midiChannel));
        dos.writeByte((byte)this.controllerNum);
        dos.writeByte((byte)this.value);
        return bytes_out + 3;
    }

    public int read(DataInputStream dis) throws IOException {
        this.controllerNum = (short)dis.readUnsignedByte();
        this.value = (short)dis.readUnsignedByte();
        return 2;
    }

    public Event copy() throws CloneNotSupportedException {
        CChange event;
        try {
            event = (CChange)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new CChange();
        }
        return event;
    }

    public void print() {
        System.out.println("Contol Change(003):\t\t\t [time = " + this.time + "][midiChannel = " + this.midiChannel + "][contoller_num = " + this.controllerNum + "][value = " + this.value + "]");
    }
}

