/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.midi.MidiUtil;
import jm.midi.Track;
import jm.midi.event.EndTrack;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class SMF
implements JMC {
    private short fileType;
    private short numOfTracks;
    private int numOfBytes;
    private short ppqn;
    private Vector trackList;
    private boolean VERBOSE = false;

    public SMF() {
        this(1, 480);
    }

    public SMF(short fileType, short ppqn) {
        this.fileType = fileType;
        this.ppqn = ppqn;
        this.numOfBytes = 0;
        this.numOfTracks = 0;
        this.trackList = new Vector();
    }

    public void setVerbose(boolean val) {
        this.VERBOSE = val;
    }

    public Vector getTrackList() {
        return this.trackList;
    }

    public short getPPQN() {
        return this.ppqn;
    }

    public void clearTracks() {
        if (!this.trackList.isEmpty()) {
            this.trackList.removeAllElements();
        }
    }

    public void read(InputStream is) throws IOException {
        byte[] fileData = this.getBytes(is);
        ByteArrayInputStream bais = new ByteArrayInputStream(fileData);
        DataInputStream dis = new DataInputStream(bais);
        if (!this.trackList.isEmpty()) {
            this.trackList.removeAllElements();
        }
        if (dis.readInt() != 1297377380) {
            throw new IOException("This is NOT a MIDI file !!!");
        }
        dis.readInt();
        try {
            this.fileType = dis.readShort();
            if (this.VERBOSE) {
                System.out.println("MIDI file type = " + this.fileType);
            }
            this.numOfTracks = dis.readShort();
            if (this.VERBOSE) {
                System.out.println("Number of tracks = " + this.numOfTracks);
            }
            this.ppqn = dis.readShort();
            if (this.VERBOSE) {
                System.out.println("ppqn = " + this.ppqn);
            }
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.numOfTracks) {
            this.readTrackChunk(dis);
            ++i;
        }
        is.close();
        dis.close();
    }

    private byte[] getBytes(InputStream is) {
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = bis.read();
            while (c != -1) {
                out.write(c);
                c = bis.read();
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void write(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        this.numOfTracks = (short)this.trackList.size();
        try {
            dos.writeInt(1297377380);
            dos.writeInt(6);
            dos.writeShort(1);
            dos.writeShort(this.numOfTracks);
            dos.writeShort(this.ppqn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration enume = this.trackList.elements();
        while (enume.hasMoreElements()) {
            Track smfTrack = (Track)enume.nextElement();
            this.writeTrackChunk(dos, smfTrack);
        }
        os.flush();
        os.close();
        dos.flush();
        dos.close();
    }

    public void print() {
        Enumeration enume = this.trackList.elements();
        while (enume.hasMoreElements()) {
            Track track = (Track)enume.nextElement();
            track.print();
        }
    }

    private void skipATrack(RandomAccessFile dos) throws IOException {
        if (this.VERBOSE) {
            System.out.println("Skipping the tempo track . . .");
        }
        dos.readInt();
        dos.skipBytes(dos.readInt());
    }

    private void readTrackChunk(DataInputStream dis) throws IOException {
        Track track = new Track();
        this.trackList.addElement(track);
        int deltaTime = 0;
        if (this.VERBOSE) {
            System.out.println("Reading Track ..........");
        }
        if (dis.readInt() != 1297379947) {
            throw new IOException("Track started in wrong place!!!!  ABORTING");
        }
        dis.readInt();
        int oldStatus = 0;
        boolean eventNum = false;
        int eventLength = 0;
        Event event = null;
        while (true) {
            try {
                deltaTime = MidiUtil.readVarLength(dis);
                dis.mark(2);
                int status = dis.readUnsignedByte();
                if (status < 128) {
                    status = oldStatus;
                    dis.reset();
                }
                if (status >= 255) {
                    int type = dis.readUnsignedByte();
                    eventLength = MidiUtil.readVarLength(dis);
                    event = MidiUtil.createMetaEvent(type);
                } else if (status >= 240) {
                    System.out.println("SysEX---");
                    eventLength = MidiUtil.readVarLength(dis);
                } else if (status >= 128) {
                    short selection = (short)(status / 16);
                    short midiChannel = (short)(status - selection * 16);
                    VoiceEvt evt = (VoiceEvt)MidiUtil.createVoiceEvent(selection);
                    evt.setMidiChannel(midiChannel);
                    event = evt;
                    if (event == null) {
                        throw new IOException("MIDI file read error: invalid voice event type!");
                    }
                }
                oldStatus = status;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (event != null) {
                event.setTime(deltaTime);
                event.read(dis);
                track.addEvent(event);
                if (!(event instanceof EndTrack)) continue;
                break;
            }
            dis.skipBytes(eventLength);
        }
    }

    private void writeTrackChunk(DataOutputStream odos, Track track) throws IOException {
        if (this.VERBOSE) {
            System.out.println("Writing MIDI Track");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int header = 1297379947;
        Enumeration enume = track.getEvtList().elements();
        enume = track.getEvtList().elements();
        while (enume.hasMoreElements()) {
            Event evt = (Event)enume.nextElement();
            evt.write(dos);
        }
        odos.writeInt(header);
        odos.writeInt(baos.size());
        odos.write(baos.toByteArray(), 0, baos.size());
    }
}

