/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import jm.JMC;
import jm.midi.event.ATouch;
import jm.midi.event.CChange;
import jm.midi.event.CPres;
import jm.midi.event.EndTrack;
import jm.midi.event.Event;
import jm.midi.event.NoteOff;
import jm.midi.event.NoteOn;
import jm.midi.event.PChange;
import jm.midi.event.PWheel;
import jm.midi.event.TempoEvent;

public final class MidiUtil
implements JMC {
    private static boolean VERBOSE = false;

    public static int readVarLength(DataInputStream dis) throws IOException {
        int c;
        int value = c = (int)dis.readUnsignedByte();
        if ((c & 0x80) != 0) {
            value &= 0x7F;
            do {
                c = (short)dis.readUnsignedByte();
                value = (value << 7) + (c & 0x7F);
            } while ((c & 0x80) != 0);
        }
        return value;
    }

    public static int writeVarLength(int value, DataOutputStream dos) throws IOException {
        int bytes_out = 0;
        long buffer = value & 0x7F;
        while ((value >>= 7) > 0) {
            buffer <<= 8;
            buffer |= (long)(value & 0x7F | 0x80);
        }
        while (true) {
            dos.writeByte((byte)buffer);
            ++bytes_out;
            if ((buffer & 0x80L) == 0L) break;
            buffer >>= 8;
        }
        return bytes_out;
    }

    public static int varLengthBytes(int value) {
        int numOfBytes = 0;
        long buffer = value & 0x7F;
        while ((value >>= 7) > 0) {
            buffer <<= 8;
            buffer |= (long)(value & 0x7F | 0x80);
        }
        while (true) {
            ++numOfBytes;
            if ((buffer & 0x80L) == 0L) break;
            buffer >>= 8;
        }
        return numOfBytes;
    }

    public static double getEndEvt(short pitch, Vector evtList, int index) {
        double time = 0.0;
        ++index;
        while (index < evtList.size()) {
            Event evt = (Event)evtList.elementAt(index);
            time += (double)evt.getTime();
            switch (evt.getID()) {
                case 5: {
                    NoteOn noteOn = (NoteOn)evt;
                    if (noteOn.getPitch() != pitch || noteOn.getVelocity() != 0 || !(time > 0.0)) break;
                    noteOn.setPitch((short)255);
                    return time;
                }
                case 4: {
                    NoteOff noteOff = (NoteOff)evt;
                    if (noteOff.getPitch() != pitch || !(time > 0.0)) break;
                    noteOff.setPitch((short)255);
                    return time;
                }
            }
            ++index;
        }
        System.out.println("Error reading file - sorry!");
        System.out.println("Try to continue reading anyway");
        return 0.0;
    }

    public static Event createVoiceEvent(int id) throws IOException {
        switch (id) {
            case 8: {
                return new NoteOff();
            }
            case 9: {
                return new NoteOn();
            }
            case 10: {
                return new ATouch();
            }
            case 11: {
                return new CChange();
            }
            case 12: {
                return new PChange();
            }
            case 13: {
                return new CPres();
            }
            case 14: {
                return new PWheel();
            }
        }
        return null;
    }

    public static Event createMetaEvent(int id) throws IOException {
        switch (id) {
            case 81: {
                if (VERBOSE) {
                    System.out.println("META EVENT: TempoEvent: " + id);
                }
                return new TempoEvent();
            }
            case 47: {
                if (VERBOSE) {
                    System.out.println("End of Track");
                }
                return new EndTrack();
            }
        }
        if (VERBOSE) {
            System.out.println("META: " + id);
        }
        return null;
    }

    public static Event createSysExEvent(int id) throws IOException {
        return null;
    }
}

